/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.pointcut;

import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.MatcherHelper;
import org.jboss.aop.pointcut.Pointcut;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTAll;
import org.jboss.aop.pointcut.ast.ASTAllParameter;
import org.jboss.aop.pointcut.ast.ASTAndCFlow;
import org.jboss.aop.pointcut.ast.ASTAttribute;
import org.jboss.aop.pointcut.ast.ASTCFlow;
import org.jboss.aop.pointcut.ast.ASTCFlowBoolean;
import org.jboss.aop.pointcut.ast.ASTCFlowExpression;
import org.jboss.aop.pointcut.ast.ASTCall;
import org.jboss.aop.pointcut.ast.ASTCompositeCFlow;
import org.jboss.aop.pointcut.ast.ASTConstructor;
import org.jboss.aop.pointcut.ast.ASTExecution;
import org.jboss.aop.pointcut.ast.ASTField;
import org.jboss.aop.pointcut.ast.ASTGet;
import org.jboss.aop.pointcut.ast.ASTHas;
import org.jboss.aop.pointcut.ast.ASTHasField;
import org.jboss.aop.pointcut.ast.ASTMethod;
import org.jboss.aop.pointcut.ast.ASTNotCFlow;
import org.jboss.aop.pointcut.ast.ASTOrCFlow;
import org.jboss.aop.pointcut.ast.ASTParameter;
import org.jboss.aop.pointcut.ast.ASTSet;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ASTSubCFlow;
import org.jboss.aop.pointcut.ast.ASTWithin;
import org.jboss.aop.pointcut.ast.ASTWithincode;
import org.jboss.aop.pointcut.ast.ClassExpression;
import org.jboss.aop.pointcut.ast.Node;
import org.jboss.aop.pointcut.ast.SimpleNode;

public class SoftClassMatcher
extends MatcherHelper {
    protected Advisor advisor;
    protected String classname;
    protected boolean match = false;
    protected Class clazz;

    public SoftClassMatcher(Advisor advisor, String classname, ASTStart start) {
        super(start, advisor.getManager());
        this.advisor = advisor;
        this.classname = classname;
        this.start = start;
        if (advisor instanceof ClassAdvisor) {
            this.clazz = ((ClassAdvisor)advisor).getClazz();
        }
    }

    protected Boolean resolvePointcut(Pointcut p) {
        return new Boolean(p.softMatch(this.advisor));
    }

    public Object visit(ASTCall node, Object data) {
        return node.getBehavior().jjtAccept(this, null);
    }

    public Object visit(ASTAll node, Object data) {
        return this.matches(node.getClazz());
    }

    public Boolean matches(ClassExpression expr) {
        if (expr.isAnnotation()) {
            if (this.advisor == null) {
                return Boolean.TRUE;
            }
            if (this.clazz == null) {
                return Boolean.TRUE;
            }
            String sub = expr.getOriginal().substring(1);
            if (!this.advisor.getClassMetaData().hasTag(sub)) {
                try {
                    if (this.clazz == null) {
                        return Boolean.TRUE;
                    }
                    if (!this.advisor.hasAnnotation(sub)) {
                        return Boolean.FALSE;
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        } else if (expr.isInstanceOf()) {
            if (this.clazz == null) {
                return Boolean.TRUE;
            }
            if (!Util.subtypeOf(this.clazz, expr)) {
                return Boolean.FALSE;
            }
        } else if (expr.isTypedef()) {
            if (this.clazz == null) {
                return Boolean.TRUE;
            }
            if (!Util.matchesTypedef(this.clazz, expr, this.advisor)) {
                return Boolean.FALSE;
            }
        } else if (!expr.matches(this.classname)) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Object visit(ASTWithin node, Object data) {
        return this.matches(node.getClazz());
    }

    public Object visit(ASTWithincode node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, null);
    }

    public Object visit(ASTExecution node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, null);
    }

    public Object visit(ASTGet node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, null);
    }

    public Object visit(ASTSet node, Object data) {
        return node.jjtGetChild(0).jjtAccept(this, null);
    }

    public Object visit(ASTMethod node, Object data) {
        ClassExpression classExpression = node.getClazz();
        return this.matchClass(classExpression);
    }

    private Object matchClass(ClassExpression classExpression) {
        if (classExpression.isAnnotation()) {
            String sub = classExpression.getOriginal().substring(1);
            if (this.advisor.getClassMetaData().hasTag(sub)) {
                return Boolean.TRUE;
            }
        } else if (classExpression.isInstanceOf()) {
            if (this.clazz == null) {
                return Boolean.TRUE;
            }
            if (Util.subtypeOf(this.clazz.getDeclaringClass(), classExpression)) {
                return Boolean.TRUE;
            }
        } else if (classExpression.isInstanceOf()) {
            if (this.clazz == null) {
                return Boolean.TRUE;
            }
            if (Util.subtypeOf(this.clazz.getDeclaringClass(), classExpression)) {
                return Boolean.TRUE;
            }
        } else {
            return new Boolean(classExpression.matches(this.classname));
        }
        return Boolean.FALSE;
    }

    public Object visit(ASTConstructor node, Object data) {
        ClassExpression classExpression = node.getClazz();
        return this.matchClass(classExpression);
    }

    public Object visit(ASTField node, Object data) {
        ClassExpression classExpression = node.getClazz();
        return this.matchClass(classExpression);
    }

    public Object visit(ASTHas node, Object data) {
        if (this.clazz == null) {
            return Boolean.TRUE;
        }
        Node n = node.jjtGetChild(0);
        if (n instanceof ASTMethod) {
            return new Boolean(Util.has(this.clazz, (ASTMethod)n, this.advisor));
        }
        return new Boolean(Util.has(this.clazz, (ASTConstructor)n, this.advisor));
    }

    public Object visit(ASTHasField node, Object data) {
        if (this.clazz == null) {
            return Boolean.TRUE;
        }
        ASTField f = (ASTField)node.jjtGetChild(0);
        return new Boolean(Util.has(this.clazz, f, this.advisor));
    }

    public Object visit(ASTAttribute node, Object data) {
        return data;
    }

    public Object visit(ASTParameter node, Object data) {
        return data;
    }

    public Object visit(ASTAllParameter node, Object data) {
        return data;
    }

    public Object visit(ASTCFlowExpression node, Object data) {
        return data;
    }

    public Object visit(ASTCFlowBoolean node, Object data) {
        return data;
    }

    public Object visit(ASTNotCFlow node, Object data) {
        return data;
    }

    public Object visit(ASTCompositeCFlow node, Object data) {
        return data;
    }

    public Object visit(ASTSubCFlow node, Object data) {
        return data;
    }

    public Object visit(ASTAndCFlow node, Object data) {
        return data;
    }

    public Object visit(ASTOrCFlow node, Object data) {
        return data;
    }

    public Object visit(ASTCFlow node, Object data) {
        return data;
    }

    public Object visit(SimpleNode node, Object data) {
        return data;
    }
}

