/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aop.introduction;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import javassist.CtClass;
import org.jboss.aop.Advisor;
import org.jboss.aop.ClassAdvisor;
import org.jboss.aop.pointcut.TypeMatcher;
import org.jboss.aop.pointcut.Util;
import org.jboss.aop.pointcut.ast.ASTStart;
import org.jboss.aop.pointcut.ast.ClassExpression;

public class InterfaceIntroduction {
    protected String name;
    protected ArrayList advisors = new ArrayList();
    protected String[] interfaces;
    protected ArrayList mixins = new ArrayList();
    protected ClassExpression classExpr;
    protected ASTStart ast;

    public InterfaceIntroduction(String name, String exp, String[] interfaces) {
        this.name = name;
        this.interfaces = interfaces;
        this.classExpr = new ClassExpression(exp);
    }

    public InterfaceIntroduction(String name, ASTStart ast, String[] interfaces) {
        this.name = name;
        this.ast = ast;
        this.interfaces = interfaces;
    }

    public String getName() {
        return this.name;
    }

    public String[] getInterfaces() {
        return this.interfaces;
    }

    public ArrayList getMixins() {
        return this.mixins;
    }

    public void addAdvisor(Advisor advisor) {
        this.advisors.add(new WeakReference<Advisor>(advisor));
        advisor.addInterfaceIntroduction(this);
    }

    public void clearAdvisors() {
        for (int i = 0; i < this.advisors.size(); ++i) {
            WeakReference ref = (WeakReference)this.advisors.get(i);
            Advisor advisor = (Advisor)ref.get();
            if (advisor == null) continue;
            advisor.removeInterfaceIntroduction(this);
        }
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof InterfaceIntroduction)) {
            return false;
        }
        return ((InterfaceIntroduction)obj).getName().equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getClassExpr() {
        if (this.classExpr == null) {
            return null;
        }
        return this.classExpr.getOriginal();
    }

    public ASTStart getAst() {
        return this.ast;
    }

    public boolean matches(Advisor advisor, CtClass clazz) throws Exception {
        if (this.classExpr != null) {
            return Util.matchesClassExpr(this.classExpr, clazz, advisor);
        }
        TypeMatcher matcher = new TypeMatcher((Advisor)((ClassAdvisor)advisor), clazz);
        return (Boolean)this.ast.jjtAccept(matcher, null);
    }

    public boolean matches(Advisor advisor, Class clazz) {
        if (this.classExpr != null) {
            return Util.matchesClassExpr(this.classExpr, clazz, advisor);
        }
        TypeMatcher matcher = new TypeMatcher(advisor, clazz);
        return (Boolean)this.ast.jjtAccept(matcher, null);
    }

    public static class Mixin {
        protected final String classname;
        protected final String[] interfaces;
        protected final String construction;
        protected final boolean trans;

        public Mixin(String classname, String[] interfaces, String construction, boolean trans) {
            this.classname = classname;
            this.interfaces = interfaces;
            this.construction = construction;
            this.trans = trans;
        }

        public String getClassName() {
            return this.classname;
        }

        public String[] getInterfaces() {
            return this.interfaces;
        }

        public String getConstruction() {
            return this.construction;
        }

        public boolean isTransient() {
            return this.trans;
        }
    }
}

