/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.scriptio;

import java.io.IOException;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.NumberSequence;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.scriptio.ScriptReaderBinary;
import org.hsqldb.scriptio.ScriptReaderText;
import org.hsqldb.scriptio.ScriptReaderZipped;

public abstract class ScriptReaderBase {
    public static final int ANY_STATEMENT = 1;
    public static final int DELETE_STATEMENT = 2;
    public static final int INSERT_STATEMENT = 3;
    public static final int SEQUENCE_STATEMENT = 4;
    public static final int COMMIT_STATEMENT = 5;
    public static final int SESSION_ID = 6;
    Database db;
    int lineCount;
    String fileName;
    int statementType;
    int sessionNumber;
    Object[] rowData;
    long sequenceValue;
    String statement;
    Table currentTable;
    NumberSequence currentSequence;

    public static ScriptReaderBase newScriptReader(Database database, String string, int n) throws HsqlException, IOException {
        if (n == 0) {
            return new ScriptReaderText(database, string);
        }
        if (n == 1) {
            return new ScriptReaderBinary(database, string);
        }
        return new ScriptReaderZipped(database, string);
    }

    ScriptReaderBase(Database database, String string) throws HsqlException, IOException {
        this.db = database;
        this.fileName = string;
        this.openFile();
    }

    protected abstract void openFile() throws IOException;

    public void readAll(Session session) throws IOException, HsqlException {
        this.readDDL(session);
        this.readExistingData(session);
    }

    protected abstract void readDDL(Session var1) throws IOException, HsqlException;

    protected abstract void readExistingData(Session var1) throws IOException, HsqlException;

    public abstract boolean readLoggedStatement() throws IOException;

    public int getStatementType() {
        return this.statementType;
    }

    public int getSessionNumber() {
        return this.sessionNumber;
    }

    public Object[] getData() {
        return this.rowData;
    }

    public String getLoggedStatement() {
        return this.statement;
    }

    public NumberSequence getCurrentSequence() {
        return this.currentSequence;
    }

    public long getSequenceValue() {
        return this.sequenceValue;
    }

    public Table getCurrentTable() {
        return this.currentTable;
    }

    public int getLineNumber() {
        return this.lineCount;
    }

    public abstract void close();
}

