/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.hsqldb.Database;
import org.hsqldb.HsqlException;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.Storage;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.ScaledRAFile;
import org.hsqldb.rowio.RowOutputBinary;

final class DataFileDefrag {
    BufferedOutputStream fileStreamOut;
    long filePos;
    StopWatch stopw = new StopWatch();
    String filename;
    int[][] rootsList;
    Database database;
    DataFileCache cache;
    int scale;

    DataFileDefrag(Database database, DataFileCache dataFileCache, String string) {
        this.database = database;
        this.cache = dataFileCache;
        this.scale = dataFileCache.cacheFileScale;
        this.filename = string;
        this.rootsList = new int[database.getTables().size()][];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void process() throws HsqlException, IOException {
        Storage storage;
        block11: {
            Trace.printSystemOut("Defrag Transfer begins");
            HsqlArrayList hsqlArrayList = this.database.getTables();
            storage = null;
            try {
                try {
                    Object object;
                    int n;
                    OutputStream outputStream = this.database.getFileAccess().openOutputStreamElement(this.filename + ".new");
                    this.fileStreamOut = new BufferedOutputStream(outputStream, 4096);
                    for (n = 0; n < 32; ++n) {
                        this.fileStreamOut.write(0);
                    }
                    this.filePos = 32L;
                    int n2 = hsqlArrayList.size();
                    for (n = 0; n < n2; ++n) {
                        object = (Table)hsqlArrayList.get(n);
                        if (((Table)object).getTableType() == 4) {
                            int[] nArray = this.writeTableToDataFile((Table)object);
                            this.rootsList[n] = nArray;
                        } else {
                            this.rootsList[n] = null;
                        }
                        Trace.printSystemOut(((Table)object).getName().name + " complete");
                    }
                    this.fileStreamOut.close();
                    storage = ScaledRAFile.newScaledRAFile(this.filename + ".new", false, 0, this.database.getURLProperties().getProperty("storage_class_name"), this.database.getURLProperties().getProperty("storage_key"));
                    storage.seek(12L);
                    storage.writeLong(this.filePos);
                    n2 = this.rootsList.length;
                    for (n = 0; n < n2; ++n) {
                        object = this.rootsList[n];
                        if (object == null) continue;
                        Trace.printSystemOut(StringUtil.getList((int[])object, ",", ""));
                    }
                    Object var9_9 = null;
                    if (this.fileStreamOut == null) break block11;
                }
                catch (IOException iOException) {
                    throw Trace.error(29, this.filename + ".new");
                }
            }
            catch (Throwable throwable) {
                Object var9_10 = null;
                if (this.fileStreamOut != null) {
                    this.fileStreamOut.close();
                }
                if (storage == null) throw throwable;
                storage.close();
                throw throwable;
            }
            this.fileStreamOut.close();
        }
        if (storage == null) return;
        storage.close();
    }

    void updateTableIndexRoots() throws HsqlException {
        HsqlArrayList hsqlArrayList = this.database.getTables();
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            Table table = (Table)hsqlArrayList.get(i);
            if (table.getTableType() != 4) continue;
            int[] nArray = this.rootsList[i];
            table.setIndexRoots(nArray);
        }
    }

    int[] writeTableToDataFile(Table table) throws IOException, HsqlException {
        Row row;
        RowOutputBinary rowOutputBinary = new RowOutputBinary();
        DoubleIntIndex doubleIntIndex = new DoubleIntIndex(table.getPrimaryIndex().sizeEstimate(), false);
        int[] nArray = table.getIndexRootsArray();
        long l = this.filePos;
        int n = 0;
        doubleIntIndex.setKeysSearchTarget();
        Trace.printSystemOut("lookup begins: " + this.stopw.elapsedTime());
        RowIterator rowIterator = table.rowIterator(null);
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            doubleIntIndex.addUnsorted(row.getPos(), (int)(l / (long)this.scale));
            if (n % 50000 == 0) {
                Trace.printSystemOut("pointer pair for row " + n + " " + row.getPos() + " " + l);
            }
            l += (long)row.getStorageSize();
            ++n;
        }
        Trace.printSystemOut(table.getName().name + " list done ", this.stopw.elapsedTime());
        n = 0;
        rowIterator = table.rowIterator(null);
        while (rowIterator.hasNext()) {
            row = rowIterator.next();
            rowOutputBinary.reset();
            row.write(rowOutputBinary, doubleIntIndex);
            this.fileStreamOut.write(rowOutputBinary.getOutputStream().getBuffer(), 0, rowOutputBinary.size());
            this.filePos += (long)row.getStorageSize();
            if (n % 50000 == 0) {
                Trace.printSystemOut(n + " rows " + this.stopw.elapsedTime());
            }
            ++n;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == -1) continue;
            int n2 = doubleIntIndex.findFirstEqualKeyIndex(nArray[i]);
            if (n2 == -1) {
                throw Trace.error(129);
            }
            nArray[i] = doubleIntIndex.getValue(n2);
        }
        Trace.printSystemOut(table.getName().name + " : table converted");
        return nArray;
    }
}

