/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Column;
import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.ValuePool;

class Parser {
    private Database database;
    private Tokenizer tokenizer;
    private Session session;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;
    private int subQueryLevel;
    private HsqlArrayList subQueryList = new HsqlArrayList();
    static HashMap simpleFunctions = new HashMap();
    private static IntValueHashMap tokenSet;
    HsqlArrayList parameters = new HsqlArrayList();
    private static final Expression[] noParameters;
    private static final SubQuery[] noSubqueries;

    Parser(Session session, Database database, Tokenizer tokenizer) {
        this.database = database;
        this.tokenizer = tokenizer;
        this.session = session;
    }

    void reset(String string) {
        this.sTable = null;
        this.sToken = null;
        this.oData = null;
        this.tokenizer.reset(string);
        this.subQueryList.clear();
        this.subQueryLevel = 0;
        this.parameters.clear();
    }

    void checkTableWriteAccess(Table table, int n) throws HsqlException {
        this.session.checkReadWrite();
        this.session.check(table.getName(), n);
        if (table.isView()) {
            throw Trace.error(55, table.getName().name);
        }
        table.checkDataReadOnly();
    }

    static HsqlArrayList getColumnNames(Database database, Tokenizer tokenizer, boolean bl) throws HsqlException {
        String string;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        do {
            if (bl) {
                string = tokenizer.getIdentifier();
                boolean bl2 = tokenizer.wasQuotedIdentifier();
                HsqlNameManager.HsqlName hsqlName = database.nameManager.newHsqlName(string, bl2);
                hsqlArrayList.add(hsqlName);
                continue;
            }
            hsqlArrayList.add(tokenizer.getString());
        } while ((string = tokenizer.getString()).equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        return hsqlArrayList;
    }

    SubQuery parseSubquery(int n, HsqlNameManager.HsqlName[] hsqlNameArray, boolean bl, int n2) throws HsqlException {
        int[] nArray;
        int n3;
        SubQuery subQuery = new SubQuery();
        ++this.subQueryLevel;
        Select select = this.parseSelect(n, false, true);
        subQuery.level = this.subQueryLevel--;
        boolean bl2 = select.resolveAll(bl);
        subQuery.select = select;
        subQuery.isResolved = bl2;
        if (!bl2) {
            return subQuery;
        }
        Table table = new Table(this.database, this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false), 1, 0);
        if (hsqlNameArray != null) {
            if (hsqlNameArray.length != select.iResultLen) {
                throw Trace.error(5);
            }
            for (n3 = 0; n3 < select.iResultLen; ++n3) {
                HsqlNameManager.HsqlName hsqlName = hsqlNameArray[n3];
                select.exprColumns[n3].setAlias(hsqlName.name, hsqlName.isNameQuoted);
            }
        } else {
            for (n3 = 0; n3 < select.iResultLen; ++n3) {
                String string = select.exprColumns[n3].getAlias();
                if (string != null && string.length() != 0) continue;
                string = "COL_" + String.valueOf(n3 + 1);
                select.exprColumns[n3].setAlias(string, false);
            }
        }
        table.addColumns(select);
        if (n2 == 30) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 0;
        } else {
            nArray = null;
        }
        int[] nArray3 = nArray;
        table.createPrimaryKey(nArray3);
        subQuery.table = table;
        subQuery.isInPredicate = n2 == 30;
        this.subQueryList.add(subQuery);
        return subQuery;
    }

    SubQuery getViewSubquery(View view) {
        SubQuery subQuery = view.viewSubQuery;
        for (int i = 0; i < view.viewSubqueries.length; ++i) {
            this.subQueryList.add(view.viewSubqueries[i]);
        }
        return subQuery;
    }

    Select parseSelect(int n, boolean bl, boolean bl2) throws HsqlException {
        Expression expression;
        Object object;
        Expression expression2;
        String string;
        Select select = new Select();
        if (bl) {
            this.parseLimit(select);
        }
        if ((string = this.tokenizer.getString()).equals("DISTINCT")) {
            select.isDistinctSelect = true;
        } else if (!string.equals("ALL")) {
            this.tokenizer.back();
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        do {
            expression2 = this.parseExpression();
            string = this.tokenizer.getString();
            if (string.equals("AS")) {
                expression2.setAlias(this.tokenizer.getName(), this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            } else if (this.tokenizer.wasName()) {
                expression2.setAlias(string, this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            }
            hsqlArrayList.add(expression2);
        } while (string.equals(","));
        if (string.equals("INTO")) {
            boolean bl3 = true;
            string = this.tokenizer.getString();
            switch (Token.get(string)) {
                case 302: {
                    select.intoType = 4;
                    break;
                }
                case 326: {
                    select.intoType = 2;
                    break;
                }
                case 327: {
                    select.intoType = 6;
                    break;
                }
                case 310: {
                    select.intoType = 3;
                    break;
                }
                default: {
                    select.intoType = 3;
                    bl3 = false;
                }
            }
            if (bl3) {
                string = this.tokenizer.getString();
            }
            select.sIntoTable = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
            string = this.tokenizer.getString();
            if ("?".equals(this.sToken)) {
                throw Trace.error(11, 195);
            }
        }
        if (!string.equals("FROM")) {
            throw Trace.error(11, string);
        }
        expression2 = null;
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        hsqlArrayList2.add(this.parseTableFilter(false));
        while (true) {
            if ((string = this.tokenizer.getString()).equals("INNER")) {
                this.tokenizer.getThis("JOIN");
                string = "JOIN";
            }
            if (string.equals("LEFT")) {
                this.tokenizer.isGetThis("OUTER");
                this.tokenizer.getThis("JOIN");
                object = this.parseTableFilter(true);
                hsqlArrayList2.add(object);
                this.tokenizer.getThis("ON");
                expression = this.parseExpression();
                expression.checkTables(hsqlArrayList2);
                expression2 = Parser.addJoinCondition(expression2, expression, (TableFilter)object, true);
                continue;
            }
            if (string.equals("JOIN")) {
                hsqlArrayList2.add(this.parseTableFilter(false));
                this.tokenizer.getThis("ON");
                object = this.parseExpression();
                ((Expression)object).checkTables(hsqlArrayList2);
                expression2 = Parser.addJoinCondition(expression2, (Expression)object, null, false);
                continue;
            }
            if (!string.equals(",")) break;
            hsqlArrayList2.add(this.parseTableFilter(false));
        }
        this.tokenizer.back();
        Parser.resolveSelectTableFilter(select, hsqlArrayList, hsqlArrayList2);
        string = this.tokenizer.getString();
        if (string.equals("WHERE")) {
            object = this.parseExpression();
            object = Parser.resolveWhereColumnAliases((Expression)object, hsqlArrayList);
            expression2 = Parser.addCondition(expression2, (Expression)object);
            string = this.tokenizer.getString();
        }
        select.queryCondition = expression2;
        if (string.equals("GROUP")) {
            this.tokenizer.getThis("BY");
            int n2 = 0;
            do {
                expression = this.parseExpression();
                hsqlArrayList.add(expression);
                string = this.tokenizer.getString();
                ++n2;
            } while (string.equals(","));
            select.iGroupLen = n2;
        }
        if (string.equals("HAVING")) {
            select.iHavingIndex = hsqlArrayList.size();
            select.havingCondition = this.parseExpression();
            string = this.tokenizer.getString();
            hsqlArrayList.add(select.havingCondition);
        }
        if (n > 0 && string.equals(")")) {
            n -= Parser.parseCloseBrackets(this.tokenizer, n - 1) + 1;
            string = this.tokenizer.getString();
        }
        select.unionDepth = n;
        int n3 = this.parseUnion(string);
        if (n3 != 0) {
            select.unionType = n3;
            if (this.tokenizer.isGetThis("(")) {
                n += Parser.parseOpenBrackets(this.tokenizer) + 1;
            }
            this.tokenizer.getThis("SELECT");
            select.unionSelect = this.parseSelect(n, false, false);
        }
        if (bl) {
            string = this.tokenizer.getString();
            if (string.equals("ORDER")) {
                this.tokenizer.getThis("BY");
                this.parseOrderBy(select, hsqlArrayList);
            } else {
                this.tokenizer.back();
            }
        }
        if (bl2) {
            select.prepareUnions();
        }
        int n4 = hsqlArrayList.size();
        select.exprColumns = new Expression[n4];
        hsqlArrayList.toArray(select.exprColumns);
        return select;
    }

    int parseUnion(String string) throws HsqlException {
        int n = 0;
        switch (Token.get(string)) {
            case 227: {
                string = this.tokenizer.getString();
                if (string.equals("ALL")) {
                    n = 2;
                    break;
                }
                if (string.equals("DISTINCT")) {
                    n = 1;
                    break;
                }
                n = 1;
                this.tokenizer.back();
                break;
            }
            case 115: {
                this.tokenizer.isGetThis("DISTINCT");
                n = 3;
                break;
            }
            case 78: 
            case 311: {
                this.tokenizer.isGetThis("DISTINCT");
                n = 4;
                break;
            }
            default: {
                this.tokenizer.back();
            }
        }
        return n;
    }

    private void parseLimit(Select select) throws HsqlException {
        Expression expression;
        Expression expression2;
        String string = this.tokenizer.getString();
        boolean bl = false;
        if (string.equals("LIMIT")) {
            this.read();
            expression2 = this.readTerm();
            expression = this.readTerm();
            bl = true;
            this.tokenizer.back();
        } else if (string.equals("TOP")) {
            this.read();
            expression2 = new Expression(4, ValuePool.getInt(0));
            expression = this.readTerm();
            this.tokenizer.back();
        } else {
            this.tokenizer.back();
            return;
        }
        if ((expression2.getType() == 1 && expression2.getDataType() == 4 && (Integer)expression2.getValue(null) >= 0 || expression2.isParam()) && (expression.getType() == 1 && expression.getDataType() == 4 && (Integer)expression2.getValue(null) >= 0 || expression.isParam())) {
            expression2.setDataType(4);
            expression.setDataType(4);
            select.limitCondition = new Expression(8, expression2, expression);
            return;
        }
        int n = bl ? 168 : 169;
        throw Trace.error(16, n);
    }

    private void parseOrderBy(Select select, HsqlArrayList hsqlArrayList) throws HsqlException {
        String string;
        int n = 0;
        do {
            Expression expression = this.parseExpression();
            expression = Parser.resolveOrderByColumnAlias(expression, hsqlArrayList, select.iResultLen, select.unionSelect != null);
            string = this.tokenizer.getString();
            if (string.equals("DESC")) {
                expression.setDescending();
                string = this.tokenizer.getString();
            } else if (string.equals("ASC")) {
                string = this.tokenizer.getString();
            }
            hsqlArrayList.add(expression);
            ++n;
        } while (string.equals(","));
        this.tokenizer.back();
        select.iOrderLen = n;
    }

    private static void resolveSelectTableFilter(Select select, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) throws HsqlException {
        Expression expression;
        int n;
        int n2 = hsqlArrayList2.size();
        TableFilter[] tableFilterArray = new TableFilter[n2];
        hsqlArrayList2.toArray(tableFilterArray);
        select.tFilter = tableFilterArray;
        n2 = hsqlArrayList.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            expression = (Expression)hsqlArrayList.get(n);
            if (expression.getType() == 6) {
                n3 = n;
                Table table = null;
                String string = expression.getTableName();
                for (int i = 0; i < tableFilterArray.length; ++i) {
                    TableFilter tableFilter = tableFilterArray[i];
                    expression.resolveTables(tableFilter);
                    if (string != null && !string.equals(tableFilter.getName())) continue;
                    table = tableFilter.getTable();
                    int n4 = table.getColumnCount();
                    for (int j = 0; j < n4; ++j) {
                        Expression expression2 = new Expression(tableFilter.getName(), table.getColumn(j));
                        hsqlArrayList.add(n3++, expression2);
                        ++n2;
                    }
                }
                Trace.check(table != null, 22, string);
                --n2;
                hsqlArrayList.remove(n3);
                continue;
            }
            if (expression.getType() != 2 || expression.getFilter() != null) continue;
            for (n3 = 0; n3 < tableFilterArray.length; ++n3) {
                expression.resolveTables(tableFilterArray[n3]);
            }
        }
        for (n = 0; n < n2; ++n) {
            expression = (Expression)hsqlArrayList.get(n);
            expression.resolveTypes();
        }
        select.iResultLen = n2;
    }

    private static Expression resolveWhereColumnAliases(Expression expression, HsqlArrayList hsqlArrayList) throws HsqlException {
        return expression;
    }

    private static Expression resolveOrderByColumnAlias(Expression expression, HsqlArrayList hsqlArrayList, int n, boolean bl) throws HsqlException {
        if (expression.getType() == 1) {
            return Parser.resolveOrderByColumnIndex(expression, hsqlArrayList, n);
        }
        if (expression.getType() != 2) {
            if (bl) {
                throw Trace.error(70);
            }
            return expression;
        }
        String string = expression.getColumnName();
        String string2 = expression.getTableName();
        if (string2 != null) {
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                Expression expression2 = (Expression)hsqlArrayList.get(i);
                if (!string.equals(expression2.getColumnName()) || !string2.endsWith(expression2.getTableName())) continue;
                expression2.orderColumnIndex = i;
                return expression2;
            }
            if (bl) {
                throw Trace.error(70, string);
            }
            return expression;
        }
        Expression expression3 = expression;
        int n3 = hsqlArrayList.size();
        for (int i = 0; i < n3; ++i) {
            Expression expression4 = (Expression)hsqlArrayList.get(i);
            String string3 = expression4.getDefinedAlias();
            String string4 = expression4.getColumnName();
            if (!string.equals(string3) && !string.equals(string4)) continue;
            if (expression3 != expression && i < n) {
                throw Trace.error(156, string);
            }
            if (expression3 != expression) continue;
            expression3 = expression4;
            expression3.orderColumnIndex = i;
        }
        if (bl && (expression3 == expression || expression3.orderColumnIndex >= n)) {
            throw Trace.error(70, string);
        }
        return expression3;
    }

    private static Expression resolveOrderByColumnIndex(Expression expression, HsqlArrayList hsqlArrayList, int n) throws HsqlException {
        int n2;
        if (expression.getDataType() == 4 && 0 < (n2 = ((Integer)expression.getValue(null)).intValue()) && n2 <= n) {
            Expression expression2 = (Expression)hsqlArrayList.get(n2 - 1);
            expression2.orderColumnIndex = n2 - 1;
            return expression2;
        }
        throw Trace.error(70);
    }

    private TableFilter parseSimpleTableFilter(int n) throws HsqlException {
        String string = null;
        String string2 = this.tokenizer.getString();
        Table table = this.database.getTable(this.session, string2);
        this.checkTableWriteAccess(table, n);
        string2 = this.tokenizer.getString();
        if (string2.equals("AS")) {
            string = this.tokenizer.getName();
        } else if (this.tokenizer.wasName()) {
            string = string2;
        } else {
            this.tokenizer.back();
        }
        return new TableFilter(table, string, false);
    }

    private TableFilter parseTableFilter(boolean bl) throws HsqlException {
        String string = this.tokenizer.getString();
        Table table = null;
        String string2 = null;
        if (string.equals("(")) {
            int n = 0;
            if (this.tokenizer.isGetThis("(")) {
                n += Parser.parseOpenBrackets(this.tokenizer) + 1;
            }
            this.tokenizer.getThis("SELECT");
            SubQuery subQuery = this.parseSubquery(n, null, true, 3);
            this.tokenizer.getThis(")");
            table = subQuery.table;
        } else {
            table = this.database.getTable(this.session, string);
            this.session.check(table.getName(), 1);
            if (table.isView()) {
                SubQuery subQuery = this.getViewSubquery((View)table);
                subQuery.select = ((View)table).viewSelect;
                table = subQuery.table;
                string2 = string;
            }
        }
        string = this.tokenizer.getString();
        if (string.equals("LEFT")) {
            this.tokenizer.back();
        } else if (string.equals("AS")) {
            string2 = this.tokenizer.getName();
        } else if (this.tokenizer.wasName()) {
            string2 = string;
        } else {
            this.tokenizer.back();
        }
        TableFilter tableFilter = new TableFilter(table, string2, bl);
        return tableFilter;
    }

    private static Expression addCondition(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(28, expression, expression2);
    }

    private static Expression addJoinCondition(Expression expression, Expression expression2, TableFilter tableFilter, boolean bl) throws HsqlException {
        if (!expression2.setForJoin(tableFilter, bl)) {
            throw Trace.error(64);
        }
        return Parser.addCondition(expression, expression2);
    }

    Expression parseExpression() throws HsqlException {
        this.read();
        Expression expression = this.readOr();
        this.tokenizer.back();
        return expression;
    }

    private Expression readAggregate() throws HsqlException {
        boolean bl = false;
        boolean bl2 = false;
        int n = this.iToken;
        this.read();
        String string = this.tokenizer.getString();
        if (string.equals("DISTINCT")) {
            bl = true;
        } else if (string.equals("ALL")) {
            bl2 = true;
        } else {
            this.tokenizer.back();
        }
        this.readThis(101);
        Expression expression = this.readOr();
        this.readThis(102);
        if ((bl2 || bl) && (n == 47 || n == 48 || n == 49 || n == 50)) {
            throw Trace.error(200);
        }
        Expression expression2 = new Expression(n, expression, null);
        expression2.setDistinctAggregate(bl);
        return expression2;
    }

    private Expression readOr() throws HsqlException {
        Expression expression = this.readAnd();
        while (this.iToken == 29) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() throws HsqlException {
        Expression expression = this.readCondition();
        while (this.iToken == 28) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() throws HsqlException {
        switch (this.iToken) {
            case 20: {
                int n = this.iToken;
                this.read();
                return new Expression(n, this.readCondition(), null);
            }
            case 31: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                int n2 = 0;
                if (this.iToken == 101) {
                    n2 += Parser.parseOpenBrackets(this.tokenizer) + 1;
                    this.read();
                }
                Trace.check(this.iToken == 103, 11);
                SubQuery subQuery = this.parseSubquery(n2, null, false, 31);
                Select select = subQuery.select;
                Expression expression = new Expression(select, subQuery.table, !subQuery.isResolved);
                this.read();
                this.readThis(102);
                return new Expression(n, expression, null);
            }
        }
        Expression expression = this.readConcat();
        if (this.iToken == 109) {
            boolean bl;
            this.read();
            if (this.iToken == 20) {
                bl = true;
                this.read();
            } else {
                bl = false;
            }
            Trace.check(this.iToken == 1 && this.oData == null, 11);
            this.read();
            expression = new Expression(32, expression, new Expression(0, null));
            if (bl) {
                expression = new Expression(20, expression, null);
            }
            return expression;
        }
        boolean bl = false;
        if (this.iToken == 20) {
            bl = true;
            this.read();
        }
        switch (this.iToken) {
            case 27: {
                expression = this.parseLikePredicate(expression);
                break;
            }
            case 106: {
                expression = this.parseBetweenPredicate(expression);
                break;
            }
            case 30: {
                expression = this.parseInPredicate(expression);
                break;
            }
            default: {
                Trace.check(!bl, 11);
                if (Expression.isCompare(this.iToken)) {
                    int n = this.iToken;
                    this.read();
                    return new Expression(n, expression, this.readConcat());
                }
                return expression;
            }
        }
        if (bl) {
            expression = new Expression(20, expression, null);
        }
        return expression;
    }

    private Expression parseLikePredicate(Expression expression) throws HsqlException {
        this.read();
        Expression expression2 = this.readTerm();
        Character c = null;
        if (this.sToken.equals("ESCAPE")) {
            this.read();
            Expression expression3 = this.readTerm();
            Trace.check(expression3.getType() == 1, 7);
            String string = (String)expression3.getValue(this.session, 12);
            if (string == null || string.length() < 1) {
                throw Trace.error(7, string);
            }
            c = new Character(string.charAt(0));
        }
        expression = new Expression(expression, expression2, c);
        return expression;
    }

    private Expression parseBetweenPredicate(Expression expression) throws HsqlException {
        this.read();
        Expression expression2 = new Expression(22, expression, this.readConcat());
        this.readThis(28);
        Expression expression3 = new Expression(25, expression, this.readConcat());
        if (expression2.getArg().isParam() && expression2.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        if (expression3.getArg().isParam() && expression3.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        return new Expression(28, expression2, expression3);
    }

    private Expression parseInPredicate(Expression expression) throws HsqlException {
        int n = this.iToken;
        this.read();
        this.readThis(101);
        Expression expression2 = null;
        int n2 = 0;
        if (this.iToken == 101) {
            n2 += Parser.parseOpenBrackets(this.tokenizer) + 1;
            this.read();
        }
        if (this.iToken == 103) {
            SubQuery subQuery = this.parseSubquery(n2, null, false, 30);
            Select select = subQuery.select;
            Trace.check(select.iResultLen == 1, 159);
            expression2 = new Expression(select, subQuery.table, !subQuery.isResolved);
            this.read();
        } else {
            Expression[] expressionArray;
            this.tokenizer.back();
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            do {
                expressionArray = this.parseExpression();
                if (expressionArray.exprType == 1 && expressionArray.valueData == null && !expressionArray.isParam()) {
                    throw Trace.error(79);
                }
                hsqlArrayList.add(expressionArray);
                this.read();
            } while (this.iToken == 104);
            expressionArray = (Expression[])hsqlArrayList.toArray(new Expression[hsqlArrayList.size()]);
            expression2 = new Expression(expressionArray);
        }
        this.readThis(102);
        return new Expression(n, expression, expression2);
    }

    private void readThis(int n) throws HsqlException {
        Trace.check(this.iToken == n, 11);
        this.read();
    }

    private Expression readConcat() throws HsqlException {
        Expression expression = this.readSum();
        while (this.iToken == 105) {
            int n = 15;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readSum());
        }
        return expression;
    }

    private Expression readSum() throws HsqlException {
        Expression expression = this.readFactor();
        while (true) {
            int n;
            if (this.iToken == 100) {
                n = 11;
            } else {
                if (this.iToken != 10) break;
                n = 12;
            }
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() throws HsqlException {
        Expression expression = this.readTerm();
        while (this.iToken == 13 || this.iToken == 14) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readTerm());
        }
        return expression;
    }

    private Expression readTerm() throws HsqlException {
        Expression expression = null;
        switch (this.iToken) {
            case 2: {
                expression = this.readColumnExpression();
                break;
            }
            case 10: {
                int n = this.iToken;
                this.read();
                expression = new Expression(n, this.readTerm(), null);
                Trace.check(!expression.getArg().isParam(), 212);
                break;
            }
            case 100: {
                this.read();
                expression = this.readTerm();
                Trace.check(!expression.isParam(), 216, Trace.getMessage(212));
                break;
            }
            case 101: {
                this.read();
                expression = this.readOr();
                if (this.iToken != 102) {
                    throw Trace.error(11, this.sToken);
                }
                this.read();
                break;
            }
            case 1: {
                expression = new Expression(this.iType, this.oData);
                this.read();
                break;
            }
            case 9: {
                expression = new Expression(0, null, true);
                this.parameters.add(expression);
                this.read();
                break;
            }
            case 103: {
                Select select = this.parseSelect(0, true, true);
                select.resolve();
                expression = new Expression(select, null, true);
                this.read();
                break;
            }
            case 13: {
                expression = new Expression(this.sTable, (String)null);
                this.read();
                break;
            }
            case 15: {
                return this.readConcatExpression();
            }
            case 62: {
                return this.readCaseWhenExpression();
            }
            case 68: {
                return this.readCaseExpression();
            }
            case 67: {
                return this.readNullIfExpression();
            }
            case 60: 
            case 69: {
                return this.readCoalesceExpression();
            }
            case 71: {
                return this.readSequenceExpression();
            }
            case 61: 
            case 107: {
                return this.readCastExpression();
            }
            case 63: {
                return this.readExtractExpression();
            }
            case 65: {
                return this.readTrimExpression();
            }
            case 64: {
                return this.readPositionExpression();
            }
            case 66: {
                return this.readSubstringExpression();
            }
            default: {
                if (Expression.isAggregate(this.iToken)) {
                    return this.readAggregate();
                }
                throw Trace.error(11, this.sToken);
            }
        }
        return expression;
    }

    Expression readCaseExpression() throws HsqlException {
        Expression expression;
        int n = 62;
        Expression expression2 = null;
        Expression expression3 = null;
        this.read();
        if (this.iToken != 110) {
            expression3 = this.readOr();
        }
        Expression expression4 = null;
        do {
            expression = this.parseCaseWhen(expression3);
            if (expression2 == null) {
                expression2 = expression;
            } else {
                expression4.setRightExpression(expression);
            }
            expression4 = expression.getRightExpression();
        } while (this.iToken == 110);
        if (this.iToken == 112) {
            this.readThis(112);
            expression = this.readOr();
            expression4.setRightExpression(expression);
        }
        this.readThis(113);
        return expression2;
    }

    private Expression parseCaseWhen(Expression expression) throws HsqlException {
        this.readThis(110);
        Expression expression2 = expression == null ? this.readOr() : new Expression(21, expression, this.readOr());
        this.readThis(111);
        Expression expression3 = this.readOr();
        Expression expression4 = new Expression(70, expression3, new Expression(0, null));
        Expression expression5 = new Expression(62, expression2, expression4);
        return expression5;
    }

    private Expression readCaseWhenExpression() throws HsqlException {
        int n = this.iToken;
        Expression expression = null;
        this.read();
        this.readThis(101);
        expression = this.readOr();
        this.readThis(104);
        Expression expression2 = this.readOr();
        this.readThis(104);
        expression2 = new Expression(70, expression2, this.readOr());
        expression = new Expression(n, expression, expression2);
        this.readThis(102);
        return expression;
    }

    private Expression readCastExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        Expression expression = this.readOr();
        if (this.iToken == 61) {
            this.readThis(104);
        } else {
            this.readThis(122);
        }
        int n = Types.getTypeNr(this.sToken);
        int n2 = 0;
        int n3 = 0;
        if (Types.acceptsPrecisionCreateParam(n) && this.tokenizer.isGetThis("(")) {
            n2 = this.tokenizer.getInt();
            if (Types.acceptsScaleCreateParam(n) && this.tokenizer.isGetThis(",")) {
                n3 = this.tokenizer.getInt();
            }
            this.tokenizer.getThis(")");
        }
        if (expression.isParam()) {
            expression.setDataType(n);
        }
        expression = new Expression(61, expression, n, n2, n3);
        this.read();
        this.readThis(102);
        return expression;
    }

    private Expression readColumnExpression() throws HsqlException {
        String string = this.sToken;
        Expression expression = new Expression(this.sTable, string);
        this.read();
        if (this.iToken == 101) {
            String string2 = this.database.getJavaName(string);
            Function function = new Function(string, string2, false);
            this.session.check(string2, 15);
            int n = function.getArgCount();
            int n2 = 0;
            this.read();
            if (this.iToken != 102) {
                while (true) {
                    function.setArgument(n2++, this.readOr());
                    if (this.iToken != 104) break;
                    this.read();
                }
            }
            this.readThis(102);
            expression = new Expression(function);
        } else {
            String string3 = (String)simpleFunctions.get(string);
            if (string3 != null) {
                Function function = new Function(string, string3, true);
                expression = new Expression(function);
            }
        }
        return expression;
    }

    private Expression readConcatExpression() throws HsqlException {
        int n = this.iToken;
        this.read();
        this.readThis(101);
        Expression expression = this.readOr();
        this.readThis(104);
        expression = new Expression(n, expression, this.readOr());
        this.readThis(102);
        return expression;
    }

    private Expression readNullIfExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        Expression expression = this.readOr();
        this.readThis(104);
        Expression expression2 = new Expression(70, new Expression(0, null), expression);
        expression = new Expression(21, expression, this.readOr());
        expression = new Expression(62, expression, expression2);
        this.readThis(102);
        return expression;
    }

    private Expression readCoalesceExpression() throws HsqlException {
        Expression expression = null;
        this.read();
        this.readThis(101);
        Expression expression2 = null;
        while (true) {
            Expression expression3 = this.readOr();
            Expression expression4 = new Expression(32, expression3, null);
            Expression expression5 = new Expression(70, new Expression(0, null), expression3);
            Expression expression6 = new Expression(62, expression4, expression5);
            if (expression == null) {
                expression = expression6;
            } else {
                expression2.setLeftExpression(expression6);
            }
            expression2 = expression5;
            if (this.iToken == 102) break;
            this.readThis(104);
        }
        this.readThis(102);
        return expression;
    }

    private Expression readExtractExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        String string = this.sToken;
        if (!Expression.SQL_EXTRACT_FIELD_NAMES.contains(string)) {
            throw Trace.error(11, this.sToken);
        }
        this.readToken();
        this.readThis(124);
        Function function = new Function(string, this.database.getJavaName(string), false);
        function.setArgument(0, this.readOr());
        this.readThis(102);
        return new Expression(function);
    }

    private Expression readPositionExpression() throws HsqlException {
        this.read();
        this.readThis(101);
        Function function = new Function("POSITION", "org.hsqldb.Library.position", false);
        function.setArgument(0, this.readTerm());
        this.readThis(30);
        function.setArgument(1, this.readOr());
        this.readThis(102);
        return new Expression(function);
    }

    private Expression readSubstringExpression() throws HsqlException {
        boolean bl = false;
        this.read();
        this.readThis(101);
        Function function = new Function("SUBSTRING", "org.hsqldb.Library.substring", false);
        function.setArgument(0, this.readTerm());
        if (this.iToken == 124) {
            this.readThis(124);
        } else {
            this.readThis(104);
            bl = true;
        }
        function.setArgument(1, this.readOr());
        Expression expression = null;
        if (!bl && this.iToken == 123) {
            this.readThis(123);
            expression = this.readTerm();
        } else if (bl && this.iToken == 104) {
            this.readThis(104);
            expression = this.readTerm();
        }
        function.setArgument(2, expression);
        this.readThis(102);
        return new Expression(function);
    }

    private Expression readSequenceExpression() throws HsqlException {
        this.tokenizer.getThis("VALUE");
        this.tokenizer.getThis("FOR");
        String string = this.tokenizer.getIdentifier();
        this.tokenizer.getString();
        NumberSequence numberSequence = this.database.sequenceManager.getSequence(string);
        Trace.check(numberSequence != null, 191);
        return new Expression(numberSequence);
    }

    private Expression readTrimExpression() throws HsqlException {
        Expression expression;
        Expression expression2;
        String string;
        this.read();
        this.readThis(101);
        String string2 = this.sToken;
        if (Expression.SQL_TRIM_SPECIFICATION.contains(string2)) {
            this.read();
        } else {
            string2 = "BOTH";
        }
        if (this.sToken.length() == 1) {
            string = this.sToken;
            this.read();
        } else {
            string = " ";
        }
        this.readThis(124);
        Expression expression3 = new Expression(1, (Object)string);
        if (string2.equals("LEADING")) {
            expression2 = new Expression(true);
            expression = new Expression(false);
        } else if (string2.equals("TRAILING")) {
            expression2 = new Expression(false);
            expression = new Expression(true);
        } else {
            expression2 = expression = new Expression(true);
        }
        Function function = new Function("TRIM", "org.hsqldb.Library.trim", false);
        function.setArgument(0, this.readOr());
        function.setArgument(1, expression3);
        function.setArgument(2, expression2);
        function.setArgument(3, expression);
        this.readThis(102);
        return new Expression(function);
    }

    Expression readDefaultClause(int n) throws HsqlException {
        Object var2_2 = null;
        this.read();
        switch (this.iToken) {
            case 2: {
                String string = this.sToken;
                String string2 = (String)simpleFunctions.get(string);
                if (string2 == null) break;
                Function function = new Function(string, string2, true);
                return new Expression(function);
            }
            case 10: {
                int n2 = this.iToken;
                this.read();
                if (this.iToken != 1) break;
                this.oData = Column.convertObject(this.oData, n);
                return new Expression(n2, new Expression(n, this.oData), null);
            }
            case 1: {
                String string = this.sToken.toUpperCase();
                String string3 = (String)simpleFunctions.get(string);
                if (Types.isDatetimeType(n) && string3 != null) {
                    Function function = new Function(string, string3, true);
                    return new Expression(function);
                }
                this.oData = Column.convertObject(this.oData, n);
                return new Expression(n, this.oData);
            }
        }
        throw Trace.error(46, this.sToken);
    }

    private void read() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        if (this.tokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tokenizer.getAsValue();
            this.iType = this.tokenizer.getType();
        } else if (this.tokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tokenizer.wasLongName()) {
            this.sTable = this.tokenizer.getLongNameFirst();
            this.iToken = this.sToken.equals("*") ? 13 : 2;
        } else if (this.sToken.length() == 0) {
            this.iToken = 108;
        } else {
            this.iToken = tokenSet.get((Object)this.sToken, -1);
            if (this.iToken == -1) {
                this.iToken = 108;
            }
            switch (this.iToken) {
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 50: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case 13: {
                    this.sTable = null;
                    break;
                }
                default: {
                    this.iToken = 108;
                }
            }
        }
    }

    private void readToken() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.iToken = tokenSet.get((Object)this.sToken, -1);
    }

    Expression[] getParameters() {
        Expression[] expressionArray = this.parameters.size() == 0 ? noParameters : (Expression[])this.parameters.toArray(new Expression[this.parameters.size()]);
        this.parameters.clear();
        return expressionArray;
    }

    void clearParameters() {
        this.parameters.clear();
    }

    void setAsView(View view) {
        for (int i = 0; i < this.subQueryList.size(); ++i) {
            SubQuery subQuery = (SubQuery)this.subQueryList.get(i);
            if (subQuery.view != null) continue;
            subQuery.view = view;
        }
    }

    SubQuery[] getSortedSubqueries() {
        if (this.subQueryList.size() == 0) {
            return noSubqueries;
        }
        this.subQueryList.sort((SubQuery)this.subQueryList.get(0));
        SubQuery[] subQueryArray = new SubQuery[this.subQueryList.size()];
        this.subQueryList.toArray(subQueryArray);
        this.subQueryList.clear();
        return subQueryArray;
    }

    CompiledStatement compileCallStatement() throws HsqlException {
        this.clearParameters();
        Expression expression = this.parseExpression();
        CompiledStatement compiledStatement = new CompiledStatement(expression, this.getParameters());
        compiledStatement.subqueries = this.getSortedSubqueries();
        return compiledStatement;
    }

    CompiledStatement compileDeleteStatement() throws HsqlException {
        Expression expression = null;
        this.clearParameters();
        this.tokenizer.getThis("FROM");
        TableFilter tableFilter = this.parseSimpleTableFilter(2);
        String string = this.tokenizer.getString();
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        CompiledStatement compiledStatement = new CompiledStatement(tableFilter, expression, this.getParameters());
        compiledStatement.subqueries = this.getSortedSubqueries();
        return compiledStatement;
    }

    private void getInsertColumnValueExpressions(Table table, Expression[] expressionArray, int n) throws HsqlException {
        int n2;
        boolean bl = false;
        this.tokenizer.getThis("(");
        for (n2 = 0; n2 < n; ++n2) {
            Expression expression = this.parseExpression();
            expression.resolveTables(null);
            expression.resolveTypes();
            expressionArray[n2] = expression;
            String string = this.tokenizer.getString();
            if (string.equals(",")) continue;
            if (string.equals(")")) {
                bl = true;
                break;
            }
            throw Trace.error(11, string);
        }
        if (!bl || n2 != n - 1) {
            throw Trace.error(5);
        }
    }

    CompiledStatement compileInsertStatement() throws HsqlException {
        int n;
        this.clearParameters();
        this.tokenizer.getThis("INTO");
        String string = this.tokenizer.getString();
        Table table = this.database.getTable(this.session, string);
        this.checkTableWriteAccess(table, 4);
        HsqlArrayList hsqlArrayList = null;
        boolean[] blArray = null;
        int[] nArray = table.getColumnMap();
        int n2 = table.getColumnCount();
        int n3 = Parser.parseOpenBrackets(this.tokenizer);
        string = this.tokenizer.getString();
        if (n3 == 1 && !"SELECT".equals(string)) {
            n3 = 0;
            this.tokenizer.back();
            hsqlArrayList = Parser.getColumnNames(this.database, this.tokenizer, false);
            if (hsqlArrayList.size() > n2) {
                throw Trace.error(5);
            }
            n2 = hsqlArrayList.size();
            blArray = table.getNewColumnCheckList();
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                int n4;
                nArray[n] = n4 = table.getColumnNr((String)hsqlArrayList.get(n));
                blArray[n4] = true;
            }
            string = this.tokenizer.getString();
        }
        n = Token.get(string);
        switch (n) {
            case 226: {
                Expression[] expressionArray = new Expression[n2];
                this.getInsertColumnValueExpressions(table, expressionArray, n2);
                CompiledStatement compiledStatement = new CompiledStatement(table, nArray, expressionArray, blArray, this.getParameters());
                compiledStatement.subqueries = this.getSortedSubqueries();
                return compiledStatement;
            }
            case 313: {
                n3 = Parser.parseOpenBrackets(this.tokenizer) + 1;
                this.tokenizer.getThis("SELECT");
            }
            case 193: {
                Select select = this.parseSelect(n3, true, true);
                if (n2 != select.iResultLen) {
                    throw Trace.error(5);
                }
                CompiledStatement compiledStatement = new CompiledStatement(table, nArray, blArray, select, this.getParameters());
                compiledStatement.subqueries = this.getSortedSubqueries();
                return compiledStatement;
            }
        }
        throw Trace.error(11, string);
    }

    CompiledStatement compileSelectStatement(int n) throws HsqlException {
        this.clearParameters();
        Select select = this.parseSelect(n, true, true);
        if (select.sIntoTable != null) {
            this.session.checkDDLWrite();
            String string = select.sIntoTable.name;
            if (this.database.findUserTable(this.session, string) != null) {
                throw Trace.error(21, string);
            }
        }
        CompiledStatement compiledStatement = new CompiledStatement(select, this.getParameters());
        compiledStatement.subqueries = this.getSortedSubqueries();
        return compiledStatement;
    }

    CompiledStatement compileUpdateStatement() throws HsqlException {
        this.clearParameters();
        TableFilter tableFilter = this.parseSimpleTableFilter(8);
        Table table = tableFilter.filterTable;
        this.tokenizer.getThis("SET");
        int[] nArray = table.getNewColumnMap();
        Expression[] expressionArray = new Expression[nArray.length];
        int n = 0;
        String string = null;
        do {
            int n2 = table.getColumnNr(this.tokenizer.getString());
            this.tokenizer.getThis("=");
            Expression expression = this.parseExpression();
            if (n == nArray.length) {
                throw Trace.error(5);
            }
            nArray[n] = n2;
            expressionArray[n] = expression;
            string = this.tokenizer.getString();
            ++n;
        } while (string.equals(","));
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        nArray = (int[])ArrayUtil.resizeArray(nArray, n);
        expressionArray = (Expression[])ArrayUtil.resizeArray(expressionArray, n);
        CompiledStatement compiledStatement = new CompiledStatement(tableFilter, nArray, expressionArray, expression, this.getParameters());
        compiledStatement.subqueries = this.getSortedSubqueries();
        return compiledStatement;
    }

    static int parseOpenBrackets(Tokenizer tokenizer) throws HsqlException {
        int n = 0;
        while (tokenizer.isGetThis("(")) {
            ++n;
        }
        return n;
    }

    static int parseCloseBrackets(Tokenizer tokenizer, int n) throws HsqlException {
        int n2;
        for (n2 = 0; n2 < n && tokenizer.isGetThis(")"); ++n2) {
        }
        return n2;
    }

    static {
        simpleFunctions.put("CURRENT_DATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("CURRENT_TIME", "org.hsqldb.Library.curtime");
        simpleFunctions.put("CURRENT_TIMESTAMP", "org.hsqldb.Library.now");
        simpleFunctions.put("CURRENT_USER", "org.hsqldb.Library.user");
        simpleFunctions.put("SYSDATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("NOW", "org.hsqldb.Library.now");
        simpleFunctions.put("TODAY", "org.hsqldb.Library.curdate");
        tokenSet = new IntValueHashMap(37);
        tokenSet.put(",", 104);
        tokenSet.put("=", 21);
        tokenSet.put("!=", 26);
        tokenSet.put("<>", 26);
        tokenSet.put("<", 24);
        tokenSet.put(">", 23);
        tokenSet.put("<=", 25);
        tokenSet.put(">=", 22);
        tokenSet.put("AND", 28);
        tokenSet.put("NOT", 20);
        tokenSet.put("OR", 29);
        tokenSet.put("IN", 30);
        tokenSet.put("EXISTS", 31);
        tokenSet.put("BETWEEN", 106);
        tokenSet.put("+", 100);
        tokenSet.put("-", 10);
        tokenSet.put("*", 13);
        tokenSet.put("/", 14);
        tokenSet.put("||", 105);
        tokenSet.put("(", 101);
        tokenSet.put(")", 102);
        tokenSet.put("SELECT", 103);
        tokenSet.put("LIKE", 27);
        tokenSet.put("COUNT", 40);
        tokenSet.put("SUM", 41);
        tokenSet.put("MIN", 42);
        tokenSet.put("MAX", 43);
        tokenSet.put("AVG", 44);
        tokenSet.put("EVERY", 45);
        tokenSet.put("SOME", 46);
        tokenSet.put("STDDEV_POP", 47);
        tokenSet.put("STDDEV_SAMP", 48);
        tokenSet.put("VAR_POP", 49);
        tokenSet.put("VAR_SAMP", 50);
        tokenSet.put("IFNULL", 60);
        tokenSet.put("NULLIF", 67);
        tokenSet.put("CONVERT", 61);
        tokenSet.put("CAST", 107);
        tokenSet.put("NEXT", 71);
        tokenSet.put("CASE", 68);
        tokenSet.put("WHEN", 110);
        tokenSet.put("THEN", 111);
        tokenSet.put("ELSE", 112);
        tokenSet.put("END", 113);
        tokenSet.put("CASEWHEN", 62);
        tokenSet.put("CONCAT", 15);
        tokenSet.put("COALESCE", 69);
        tokenSet.put("EXTRACT", 63);
        tokenSet.put("POSITION", 64);
        tokenSet.put("FROM", 124);
        tokenSet.put("TRIM", 65);
        tokenSet.put("SUBSTRING", 66);
        tokenSet.put("FOR", 123);
        tokenSet.put("AS", 122);
        tokenSet.put("IS", 109);
        tokenSet.put("?", 9);
        noParameters = new Expression[0];
        noSubqueries = new SubQuery[0];
    }
}

