/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.proxy;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceFactory;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPBodyElement;
import javax.xml.soap.SOAPFactory;
import javax.xml.soap.SOAPMessage;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.request.Admin;
import org.apache.juddi.datatype.request.AuthInfo;
import org.apache.juddi.datatype.request.Inquiry;
import org.apache.juddi.datatype.request.Publish;
import org.apache.juddi.datatype.request.SecurityPolicy;
import org.apache.juddi.datatype.response.AuthToken;
import org.apache.juddi.error.RegistryException;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.proxy.RegistryProxy;
import org.apache.juddi.util.Loader;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SAAJRegistryProxy
extends RegistryProxy {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$proxy$RegistryProxy == null ? (class$org$apache$juddi$proxy$RegistryProxy = SAAJRegistryProxy.class$("org.apache.juddi.proxy.RegistryProxy")) : class$org$apache$juddi$proxy$RegistryProxy));
    private static HandlerMaker maker = HandlerMaker.getInstance();
    private static final String PROPFILE_NAME = "juddi.properties";
    public static final String INQUIRY_ENDPOINT_PROPERTY_NAME = "juddi.proxy.inquiryURL";
    public static final String PUBLISH_ENDPOINT_PROPERTY_NAME = "juddi.proxy.publishURL";
    public static final String ADMIN_ENDPOINT_PROPERTY_NAME = "juddi.proxy.adminURL";
    public static final String SECURITY_PROVIDER_PROPERTY_NAME = "juddi.proxy.securityProvider";
    public static final String PROTOCOL_HANDLER_PROPERTY_NAME = "juddi.proxy.protocolHandler";
    public static final String UDDI_VERSION_PROPERTY_NAME = "juddi.proxy.uddiVersion";
    public static final String UDDI_NAMESPACE_PROPERTY_NAME = "juddi.proxy.uddiNamespace";
    public static final String DEFAULT_INQUIRY_ENDPOINT = "http://localhost/juddi/inquiry";
    public static final String DEFAULT_PUBLISH_ENDPOINT = "http://localhost/juddi/publish";
    public static final String DEFAULT_ADMIN_ENDPOINT = "http://localhost/juddi/admin";
    public static final String DEFAULT_SECURITY_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    public static final String DEFAULT_PROTOCOL_HANDLER = "com.sun.net.ssl.internal.www.protocol";
    public static final String DEFAULT_UDDI_VERSION = "2.0";
    public static final String DEFAULT_UDDI_NAMESPACE = "urn:uddi-org:api_v2";
    private URL inquiryURL;
    private URL publishURL;
    private URL adminURL;
    private String securityProvider;
    private String protocolHandler;
    private String uddiVersion;
    private String uddiNamespace;
    static /* synthetic */ Class class$org$apache$juddi$proxy$RegistryProxy;

    public SAAJRegistryProxy() {
        Properties props = new Properties();
        try {
            InputStream stream = Loader.getResourceAsStream(PROPFILE_NAME);
            if (stream != null) {
                props.load(stream);
            }
        }
        catch (IOException ioex) {
            ioex.printStackTrace();
        }
        this.init(props);
    }

    public SAAJRegistryProxy(Properties props) {
        this.init(props);
    }

    private void init(Properties props) {
        if (props == null) {
            props = new Properties();
        }
        try {
            String iURL = props.getProperty(INQUIRY_ENDPOINT_PROPERTY_NAME);
            if (iURL != null) {
                this.setInquiryURL(new URL(iURL));
            } else {
                this.setInquiryURL(new URL(DEFAULT_INQUIRY_ENDPOINT));
            }
            String pURL = props.getProperty(PUBLISH_ENDPOINT_PROPERTY_NAME);
            if (pURL != null) {
                this.setPublishURL(new URL(pURL));
            } else {
                this.setPublishURL(new URL(DEFAULT_PUBLISH_ENDPOINT));
            }
            String aURL = props.getProperty(ADMIN_ENDPOINT_PROPERTY_NAME);
            if (aURL != null) {
                this.setAdminURL(new URL(aURL));
            } else {
                this.setAdminURL(new URL(DEFAULT_ADMIN_ENDPOINT));
            }
        }
        catch (MalformedURLException muex) {
            muex.printStackTrace();
        }
        String secProvider = props.getProperty(SECURITY_PROVIDER_PROPERTY_NAME);
        if (secProvider != null) {
            this.setSecurityProvider(secProvider);
        } else {
            this.setSecurityProvider(DEFAULT_SECURITY_PROVIDER);
        }
        String protoHandler = props.getProperty(PROTOCOL_HANDLER_PROPERTY_NAME);
        if (protoHandler != null) {
            this.setProtocolHandler(protoHandler);
        } else {
            this.setProtocolHandler(DEFAULT_PROTOCOL_HANDLER);
        }
        String uddiVer = props.getProperty(UDDI_VERSION_PROPERTY_NAME);
        if (uddiVer != null) {
            this.setUddiVersion(uddiVer);
        } else {
            this.setUddiVersion(DEFAULT_UDDI_VERSION);
        }
        String uddiNS = props.getProperty(UDDI_NAMESPACE_PROPERTY_NAME);
        if (uddiNS != null) {
            this.setUddiNamespace(uddiNS);
        } else {
            this.setUddiNamespace(DEFAULT_UDDI_NAMESPACE);
        }
    }

    public URL getAdminURL() {
        return this.adminURL;
    }

    public void setAdminURL(URL url) {
        this.adminURL = url;
    }

    public URL getInquiryURL() {
        return this.inquiryURL;
    }

    public void setInquiryURL(URL url) {
        this.inquiryURL = url;
    }

    public URL getPublishURL() {
        return this.publishURL;
    }

    public void setPublishURL(URL url) {
        this.publishURL = url;
    }

    public String getProtocolHandler() {
        return this.protocolHandler;
    }

    public void setProtocolHandler(String protoHandler) {
        this.protocolHandler = protoHandler;
    }

    public String getSecurityProvider() {
        return this.securityProvider;
    }

    public void setSecurityProvider(String secProvider) {
        this.securityProvider = secProvider;
    }

    public String getUddiNamespace() {
        return this.uddiNamespace;
    }

    public void setUddiNamespace(String uddiNS) {
        this.uddiNamespace = uddiNS;
    }

    public String getUddiVersion() {
        return this.uddiVersion;
    }

    public void setUddiVersion(String uddiVer) {
        this.uddiVersion = uddiVer;
    }

    public RegistryObject execute(RegistryObject uddiRequest) throws RegistryException {
        URL endPointURL = null;
        if (uddiRequest instanceof Inquiry) {
            endPointURL = this.getInquiryURL();
        } else if (uddiRequest instanceof Publish || uddiRequest instanceof SecurityPolicy) {
            endPointURL = this.getPublishURL();
        } else if (uddiRequest instanceof Admin) {
            endPointURL = this.getAdminURL();
        } else {
            throw new RegistryException("Unsupported Request: The request '" + uddiRequest.getClass().getName() + "' is an " + "invalid or unknown request type.");
        }
        Document document = XMLUtils.createDocument();
        Element temp = document.createElement("temp");
        String requestName = uddiRequest.getClass().getName();
        AbstractHandler requestHandler = maker.lookup(requestName);
        requestHandler.marshal(uddiRequest, temp);
        Element request = (Element)temp.getFirstChild();
        request.setAttribute("generic", this.getUddiVersion());
        request.setAttribute("xmlns", this.getUddiNamespace());
        Element response = this.send(request, endPointURL);
        String responseName = response.getLocalName();
        if (responseName == null) {
            throw new RegistryException("Unsupported response from registry. A value was not present.");
        }
        AbstractHandler handler = maker.lookup(responseName.toLowerCase());
        if (handler == null) {
            throw new RegistryException("Unsupported response from registry. Response type '" + responseName + "' is unknown.");
        }
        RegistryObject uddiResponse = handler.unmarshal(response);
        if (uddiResponse instanceof RegistryException) {
            throw (RegistryException)uddiResponse;
        }
        return uddiResponse;
    }

    public Element send(Element request, URL endpointURL) throws RegistryException {
        Service service = null;
        Call call = null;
        SOAPBodyElement response = null;
        log.debug((Object)("\nRequest message:\n" + XMLUtils.toString(request)));
        try {
            ServiceFactory sf = ServiceFactory.newInstance();
            service = sf.createService(endpointURL, new QName("Dummy"));
            call = service.createCall();
            call.setTargetEndpointAddress(endpointURL.toExternalForm());
            String requestString = XMLUtils.toString(request);
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage msg = mf.createMessage();
            SOAPFactory sfact = SOAPFactory.newInstance();
            SOAPBody body = msg.getSOAPBody();
            Node node = request.getFirstChild();
            String uddifn = node.getNodeName();
            Name name = sfact.createName(uddifn, "", DEFAULT_UDDI_NAMESPACE);
            SOAPBodyElement bodyel = body.addBodyElement(name);
            body.addChildElement(node.getFirstChild().toString());
            Object[] soapBodies = new Object[]{bodyel};
            Vector result = (Vector)call.invoke(soapBodies);
            response = (SOAPBodyElement)result.elementAt(0);
        }
        catch (Exception ex) {
            throw new RegistryException(ex);
        }
        log.debug((Object)("\nResponse message:\n" + XMLUtils.toString((Element)response)));
        return response;
    }

    public String send(String request, URL endpointURL) throws RegistryException {
        Service service = null;
        Call call = null;
        String response = null;
        log.debug((Object)("\nRequest message:\n" + request));
        try {
            ServiceFactory sf = ServiceFactory.newInstance();
            service = sf.createService(endpointURL, new QName("Dummy"));
            call = service.createCall();
            call.setTargetEndpointAddress(endpointURL.toExternalForm());
            MessageFactory mf = MessageFactory.newInstance();
            SOAPMessage msg = mf.createMessage();
            SOAPFactory sfact = SOAPFactory.newInstance();
            SOAPBody body = msg.getSOAPBody();
            SOAPBodyElement el = (SOAPBodyElement)body.addChildElement(request);
            Object[] soapBodies = new Object[]{el};
            Vector result = (Vector)call.invoke(soapBodies);
            response = (String)result.elementAt(0);
        }
        catch (Exception ex) {
            throw new RegistryException(ex);
        }
        log.debug((Object)("\nResponse message:\n" + response));
        return response;
    }

    public static void main(String[] args) throws RegistryException {
        Properties props = new Properties();
        props.setProperty(ADMIN_ENDPOINT_PROPERTY_NAME, "http://localhost:8080/juddi/v2/admin");
        props.setProperty(INQUIRY_ENDPOINT_PROPERTY_NAME, "http://localhost:8080/juddi/v2/inquiry");
        props.setProperty(PUBLISH_ENDPOINT_PROPERTY_NAME, "http://localhost:8080/juddi/v2/publish");
        props.setProperty(SECURITY_PROVIDER_PROPERTY_NAME, DEFAULT_SECURITY_PROVIDER);
        props.setProperty(PROTOCOL_HANDLER_PROPERTY_NAME, DEFAULT_PROTOCOL_HANDLER);
        RegistryProxy registry = new RegistryProxy(props);
        AuthToken authToken = registry.getAuthToken("sviens", "password");
        AuthInfo authInfo = authToken.getAuthInfo();
        System.out.println(authInfo.getValue());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

