/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.error;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.response.DispositionReport;
import org.apache.juddi.datatype.response.ErrInfo;
import org.apache.juddi.datatype.response.Result;
import org.apache.juddi.error.UnsupportedException;

public class RegistryException
extends Exception
implements RegistryObject {
    private String faultActor;
    private String faultCode;
    private String faultString;
    private DispositionReport dispReport;

    public RegistryException() {
    }

    public RegistryException(String msg) {
        super(msg);
        this.setFaultActor(null);
        this.setFaultCode(null);
        this.setFaultString(msg);
    }

    public RegistryException(Exception ex) {
        super(ex.getMessage());
        this.setFaultActor(null);
        this.setFaultCode(null);
        this.setFaultString(ex.getMessage());
    }

    public void setFaultActor(String actor) {
        this.faultActor = actor;
    }

    public String getFaultActor() {
        return this.faultActor;
    }

    public void setFaultCode(String code) {
        this.faultCode = code;
    }

    public String getFaultCode() {
        return this.faultCode;
    }

    public void setFaultString(String value) {
        this.faultString = value;
    }

    public String getFaultString() {
        return this.faultString;
    }

    public void setDispositionReport(DispositionReport dispRpt) {
        this.dispReport = dispRpt;
    }

    public DispositionReport getDispositionReport() {
        return this.dispReport;
    }

    public void addResult(Result result) {
        if (this.dispReport == null) {
            this.dispReport = new DispositionReport();
        }
        this.dispReport.addResult(result);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer(100);
        buff.append("RegistryException: " + this.getMessage() + "\n");
        buff.append(" SOAPFault Actor: " + this.getFaultActor() + "\n");
        buff.append(" SOAPFault Code: " + this.getFaultCode() + "\n");
        buff.append(" SOAPFault String: " + this.getFaultString() + "\n");
        DispositionReport dispRpt = this.getDispositionReport();
        if (dispRpt != null) {
            buff.append(" Operator: " + dispRpt.getOperator() + "\n");
            Vector results = dispRpt.getResultVector();
            if (results != null && results.size() > 0) {
                for (int i = 0; i < results.size(); ++i) {
                    Result result = (Result)results.elementAt(i);
                    buff.append(" >Errno: " + result.getErrno() + "\n");
                    ErrInfo errInfo = result.getErrInfo();
                    buff.append(" >Error Code: " + errInfo.getErrCode() + "\n");
                    buff.append(" >Error Info Text: " + errInfo.getErrMsg() + "\n");
                }
            } else {
                buff.append("\n >[No Results were present]");
            }
        } else {
            buff.append("\n [A DispositionReport was not present]");
        }
        return buff.toString();
    }

    public static void main(String[] args) throws RegistryException {
        throw new UnsupportedException("Additional error information.");
    }
}

