/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datastore.jdbc.BusinessEntityTable;
import org.apache.juddi.datastore.jdbc.BusinessServiceTable;
import org.apache.juddi.datatype.KeyedReference;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.Transaction;
import org.apache.juddi.uuidgen.UUIDGen;
import org.apache.juddi.uuidgen.UUIDGenFactory;

class ServiceCategoryTable {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$ServiceCategoryTable == null ? (class$org$apache$juddi$datastore$jdbc$ServiceCategoryTable = ServiceCategoryTable.class$("org.apache.juddi.datastore.jdbc.ServiceCategoryTable")) : class$org$apache$juddi$datastore$jdbc$ServiceCategoryTable));
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$ServiceCategoryTable;

    ServiceCategoryTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String serviceKey, Vector keyRefs, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, serviceKey.toString());
            int listSize = keyRefs.size();
            for (int categoryID = 0; categoryID < listSize; ++categoryID) {
                KeyedReference keyRef = (KeyedReference)keyRefs.elementAt(categoryID);
                String tModelKeyValue = null;
                if (keyRef.getTModelKey() != null) {
                    tModelKeyValue = keyRef.getTModelKey().toString();
                }
                statement.setInt(2, categoryID);
                statement.setString(3, tModelKeyValue);
                statement.setString(4, keyRef.getKeyName());
                statement.setString(5, keyRef.getKeyValue());
                log.debug((Object)("insert into SERVICE_CATEGORY table:\n\n\t" + insertSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n\t CATEGORY_ID=" + categoryID + "\n\t TMODEL_KEY_REF=" + tModelKeyValue + "\n\t KEY_NAME=" + keyRef.getKeyName() + "\n\t KEY_VALUE=" + keyRef.getKeyValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String serviceKey, Connection connection) throws SQLException {
        Vector<KeyedReference> keyRefList = new Vector<KeyedReference>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, serviceKey.toString());
            log.debug((Object)("select from SERVICE_CATEGORY table:\n\n\t" + selectSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                KeyedReference keyRef = new KeyedReference();
                keyRef.setTModelKey(resultSet.getString(1));
                keyRef.setKeyName(resultSet.getString(2));
                keyRef.setKeyValue(resultSet.getString(3));
                keyRefList.add(keyRef);
            }
            Vector<KeyedReference> vector = keyRefList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String serviceKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, serviceKey.toString());
            log.debug((Object)("delete from SERVICE_CATEGORY table:\n\n\t" + deleteSQL + "\n\t SERVICE_KEY=" + serviceKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            ServiceCategoryTable.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        Transaction txn = new Transaction();
        UUIDGen uuidgen = UUIDGenFactory.getUUIDGen();
        if (connection != null) {
            try {
                String businessKey = uuidgen.uuidgen();
                BusinessEntity business = new BusinessEntity();
                business.setBusinessKey(businessKey);
                business.setAuthorizedName("sviens");
                business.setOperator("WebServiceRegistry.com");
                String serviceKey = uuidgen.uuidgen();
                BusinessService service = new BusinessService();
                service.setServiceKey(serviceKey);
                service.setBusinessKey(businessKey);
                Vector keyRefs = new Vector();
                keyRefs.add(new KeyedReference(uuidgen.uuidgen(), "blah, blah, blah"));
                keyRefs.add(new KeyedReference(uuidgen.uuidgen(), "Yadda, Yadda, Yadda"));
                keyRefs.add(new KeyedReference(uuidgen.uuidgen(), "WhoobWhoobWhoobWhoob"));
                String authorizedUserID = "sviens";
                txn.begin(connection);
                BusinessEntityTable.insert(business, authorizedUserID, connection);
                BusinessServiceTable.insert(service, connection);
                ServiceCategoryTable.insert(serviceKey, keyRefs, connection);
                service.setServiceKey(uuidgen.uuidgen());
                BusinessServiceTable.insert(service, connection);
                ServiceCategoryTable.insert(service.getServiceKey(), keyRefs, connection);
                keyRefs = ServiceCategoryTable.select(serviceKey, connection);
                ServiceCategoryTable.delete(serviceKey, connection);
                keyRefs = ServiceCategoryTable.select(serviceKey, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO SERVICE_CATEGORY (");
        sql.append("SERVICE_KEY,");
        sql.append("CATEGORY_ID,");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE) ");
        sql.append("VALUES (?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("TMODEL_KEY_REF,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE, ");
        sql.append("CATEGORY_ID ");
        sql.append("FROM SERVICE_CATEGORY ");
        sql.append("WHERE SERVICE_KEY=? ");
        sql.append("ORDER BY CATEGORY_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM SERVICE_CATEGORY ");
        sql.append("WHERE SERVICE_KEY=?");
        deleteSQL = sql.toString();
    }
}

