/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.Config;
import org.apache.juddi.util.jdbc.ConnectionManager;
import org.apache.juddi.util.jdbc.DynamicQuery;
import org.apache.juddi.util.jdbc.Transaction;

class FindBusinessByDiscoveryURLQuery {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$juddi$datastore$jdbc$FindBusinessByDiscoveryURLQuery == null ? (class$org$apache$juddi$datastore$jdbc$FindBusinessByDiscoveryURLQuery = FindBusinessByDiscoveryURLQuery.class$("org.apache.juddi.datastore.jdbc.FindBusinessByDiscoveryURLQuery")) : class$org$apache$juddi$datastore$jdbc$FindBusinessByDiscoveryURLQuery));
    static String selectSQL;
    static /* synthetic */ Class class$org$apache$juddi$datastore$jdbc$FindBusinessByDiscoveryURLQuery;

    FindBusinessByDiscoveryURLQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(DiscoveryURLs discoveryURLs, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        Vector<String> vector;
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindBusinessByDiscoveryURLQuery.appendWhere(sql, discoveryURLs, qualifiers);
        FindBusinessByDiscoveryURLQuery.appendIn(sql, keysIn);
        FindBusinessByDiscoveryURLQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            vector = keysOut;
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
            }
            throw throwable;
        }
        try {
            resultSet.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
        }
        try {
            statement.close();
        }
        catch (Exception e) {
            log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
        }
        return vector;
    }

    private static void appendWhere(DynamicQuery sql, DiscoveryURLs discoveryURLs, FindQualifiers qualifiers) {
        sql.append("WHERE B.BUSINESS_KEY = U.BUSINESS_KEY ");
        Vector urlVector = discoveryURLs.getDiscoveryURLVector();
        int vectorSize = urlVector.size();
        if (vectorSize > 0) {
            sql.append("AND (");
            for (int i = 0; i < vectorSize; ++i) {
                DiscoveryURL discoveryURL = (DiscoveryURL)urlVector.elementAt(i);
                String url = discoveryURL.getValue();
                String useType = discoveryURL.getUseType();
                if (url == null || url.length() <= 0) continue;
                sql.append("(U.URL = ?");
                sql.addValue(url);
                if (useType != null && useType.length() > 0) {
                    sql.append(" AND U.USE_TYPE = ?");
                    sql.addValue(useType);
                }
                sql.append(")");
                if (i + 1 >= vectorSize) continue;
                sql.append(" OR ");
            }
            sql.append(") ");
        }
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND B.BUSINESS_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null) {
            sql.append("B.LAST_UPDATE DESC");
        } else if (qualifiers.sortByDateAsc) {
            sql.append("B.LAST_UPDATE ASC");
        } else {
            sql.append("B.LAST_UPDATE DESC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        Config.setStringProperty("juddi.useConnectionPool", "true");
        Connection conn = null;
        try {
            conn = ConnectionManager.aquireConnection();
            FindBusinessByDiscoveryURLQuery.test(conn);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    public static void test(Connection connection) throws Exception {
        DiscoveryURLs discoveryURLs = new DiscoveryURLs();
        Vector<DiscoveryURL> urls = new Vector<DiscoveryURL>();
        urls.add(new DiscoveryURL("http://www.uddi.org/", "wsdl"));
        urls.add(new DiscoveryURL("http://www.sviens.com/", "soap"));
        urls.add(new DiscoveryURL("http://www.juddi.org/", "wsdl"));
        discoveryURLs.setDiscoveryURLVector(urls);
        Vector<String> keysIn = new Vector<String>();
        keysIn.add("d77170a5-cf1e-45e8-bbf3-5b0756b29199");
        keysIn.add("c311085b-3277-470d-8ce9-07b81c484e4b");
        keysIn.add("e2805dbe-3957-4490-9230-5f06d85fd50d");
        keysIn.add("45994713-d3c3-40d6-87b5-6ce51f36001c");
        keysIn.add("901b15c5-799c-4387-8337-a1a35fceb791");
        keysIn.add("80fdae14-0e5d-4ea6-8eb8-50fde422056d");
        keysIn.add("e1996c33-c436-4004-9e3e-14de191bcc6b");
        keysIn.add("36f5d745-3be5-4e8f-8c1a-5f59a4c69070");
        Transaction txn = new Transaction();
        if (connection != null) {
            try {
                txn.begin(connection);
                FindBusinessByDiscoveryURLQuery.select(discoveryURLs, keysIn, null, connection);
                FindBusinessByDiscoveryURLQuery.select(discoveryURLs, null, null, connection);
                txn.commit();
            }
            catch (Exception ex) {
                try {
                    txn.rollback();
                }
                catch (SQLException sqlex) {
                    sqlex.printStackTrace();
                }
                throw ex;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT B.BUSINESS_KEY,B.LAST_UPDATE ");
        sql.append("FROM BUSINESS_ENTITY B,DISCOVERY_URL U ");
        selectSQL = sql.toString();
    }
}

