/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.security;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import java.util.Set;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.resource.security.AbstractPasswordCredentialLoginModule;
import org.jboss.resource.security.GetPrincipalInfoAction;
import org.jboss.resource.security.SubjectActions;
import org.jboss.security.RunAsIdentity;
import org.jboss.security.SimplePrincipal;

public class CallerIdentityLoginModule
extends AbstractPasswordCredentialLoginModule {
    private static final Logger log = Logger.getLogger((Class)(class$org$jboss$resource$security$CallerIdentityLoginModule == null ? (class$org$jboss$resource$security$CallerIdentityLoginModule = CallerIdentityLoginModule.class$("org.jboss.resource.security.CallerIdentityLoginModule")) : class$org$jboss$resource$security$CallerIdentityLoginModule));
    private String userName;
    private char[] password;
    private boolean addRunAsRoles;
    private Set runAsRoles;
    static /* synthetic */ Class class$org$jboss$resource$security$CallerIdentityLoginModule;

    public void initialize(Subject subject, CallbackHandler handler, Map sharedState, Map options) {
        String pass;
        super.initialize(subject, handler, sharedState, options);
        this.userName = (String)options.get("userName");
        if (this.userName == null) {
            log.debug((Object)"No default username supplied.");
        }
        if ((pass = (String)options.get("password")) == null) {
            log.debug((Object)"No default password supplied.");
        } else {
            this.password = pass.toCharArray();
        }
        String flag = (String)options.get("addRunAsRoles");
        this.addRunAsRoles = Boolean.valueOf(flag);
        log.debug((Object)("got default principal: " + this.userName + ", username: " + this.userName + ", password: " + (this.password == null ? "null" : "****") + " addRunAsRoles: " + this.addRunAsRoles));
    }

    public boolean login() throws LoginException {
        log.trace((Object)"Caller Association login called");
        String username = this.userName;
        try {
            Principal user = GetPrincipalInfoAction.getPrincipal();
            char[] userPassword = GetPrincipalInfoAction.getCredential();
            if (userPassword != null) {
                this.password = userPassword;
            }
            if (user != null) {
                username = user.getName();
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Current Calling principal is: " + username + " ThreadName: " + Thread.currentThread().getName()));
                }
                if (user instanceof RunAsIdentity) {
                    RunAsIdentity runAs = (RunAsIdentity)user;
                    this.runAsRoles = runAs.getRunAsRoles();
                }
            }
        }
        catch (Throwable e) {
            throw new LoginException("Unable to get the calling principal or its credentials for resource association");
        }
        this.userName = username;
        if (super.login()) {
            return true;
        }
        this.sharedState.put("javax.security.auth.login.name", username);
        this.loginOk = true;
        return true;
    }

    public boolean commit() throws LoginException {
        this.sharedState.put("javax.security.auth.login.name", this.userName);
        if (this.addRunAsRoles && this.runAsRoles != null) {
            SubjectActions.addRoles(this.subject, this.runAsRoles);
        }
        PasswordCredential cred = new PasswordCredential(this.userName, this.password);
        cred.setManagedConnectionFactory(this.getMcf());
        SubjectActions.addCredentials(this.subject, cred);
        return super.commit();
    }

    protected Principal getIdentity() {
        log.trace((Object)"getIdentity called");
        SimplePrincipal principal = new SimplePrincipal(this.userName);
        return principal;
    }

    protected Group[] getRoleSets() throws LoginException {
        log.trace((Object)"getRoleSets called");
        return new Group[0];
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

