/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc.local;

import java.sql.Connection;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.security.auth.Subject;
import org.jboss.resource.JBossResourceException;
import org.jboss.resource.adapter.jdbc.local.LocalManagedConnection;
import org.jboss.resource.adapter.jdbc.local.LocalManagedConnectionFactory;

public class HALocalManagedConnectionFactory
extends LocalManagedConnectionFactory {
    private URLSelector urlSelector;
    private String urlDelimeter;

    public String getURLDelimeter() {
        return this.urlDelimeter;
    }

    public void setURLDelimeter(String urlDelimeter) {
        this.urlDelimeter = urlDelimeter;
        if (this.getConnectionURL() != null) {
            this.initUrlSelector();
        }
    }

    public void setConnectionURL(String connectionURL) {
        super.setConnectionURL(connectionURL);
        if (this.urlDelimeter != null) {
            this.initUrlSelector();
        }
    }

    public ManagedConnection createManagedConnection(Subject subject, ConnectionRequestInfo cri) throws ResourceException {
        Properties props = this.getConnectionProperties(subject, cri);
        Properties copy = (Properties)props.clone();
        if (this.log.isDebugEnabled()) {
            Properties logCopy = copy;
            if (copy.getProperty("password") != null) {
                logCopy = (Properties)props.clone();
                logCopy.setProperty("password", "--hidden--");
            }
            this.log.debug((Object)("Using properties: " + logCopy));
        }
        return this.doCreateManagedConnection(copy, props);
    }

    private ManagedConnection doCreateManagedConnection(Properties copy, Properties props) throws JBossResourceException {
        for (int i = 0; i < this.urlSelector.getUrlList().size(); ++i) {
            String url = this.urlSelector.getUrl();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Trying to create a connection to " + url));
            }
            try {
                Driver d = this.getDriver(url);
                Connection con = d.connect(url, copy);
                if (con != null) {
                    return new LocalManagedConnection((LocalManagedConnectionFactory)this, con, props, this.transactionIsolation, this.preparedStatementCacheSize);
                }
                this.log.warn((Object)("Wrong driver class for this connection URL: " + url));
                this.urlSelector.failedUrl(url);
                continue;
            }
            catch (Exception e) {
                this.log.warn((Object)("Failed to create connection for " + url + ": " + e.getMessage()));
                this.urlSelector.failedUrl(url);
            }
        }
        throw new JBossResourceException("Could not create connection using any of the URLs: " + this.urlSelector.getUrlList());
    }

    private void initUrlSelector() {
        String url;
        ArrayList<String> urlsList = new ArrayList<String>();
        String urlsStr = this.getConnectionURL();
        int urlStart = 0;
        int urlEnd = urlsStr.indexOf(this.urlDelimeter);
        while (urlEnd > 0) {
            url = urlsStr.substring(urlStart, urlEnd);
            urlsList.add(url);
            urlStart = ++urlEnd;
            urlEnd = urlsStr.indexOf(this.urlDelimeter, urlEnd);
            this.log.debug((Object)("added HA connection url: " + url));
        }
        if (urlStart != urlsStr.length()) {
            url = urlsStr.substring(urlStart, urlsStr.length());
            urlsList.add(url);
            this.log.debug((Object)("added HA connection url: " + url));
        }
        this.urlSelector = new URLSelector(urlsList);
    }

    public static class URLSelector {
        private final List urls;
        private int urlIndex;
        private String url;

        public URLSelector(List urls) {
            if (urls == null || urls.size() == 0) {
                throw new IllegalStateException("Expected non-empty list of connection URLs but got: " + urls);
            }
            this.urls = Collections.unmodifiableList(urls);
        }

        public synchronized String getUrl() {
            if (this.url == null) {
                if (this.urlIndex == this.urls.size()) {
                    this.urlIndex = 0;
                }
                this.url = (String)this.urls.get(this.urlIndex++);
            }
            return this.url;
        }

        public synchronized void failedUrl(String url) {
            if (url.equals(this.url)) {
                this.url = null;
            }
        }

        public List getUrlList() {
            return this.urls;
        }
    }
}

