/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import java.util.Set;
import javax.transaction.NotSupportedException;
import javax.transaction.RollbackException;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.cache.TreeCache;
import org.jboss.cache.transaction.DummyTransactionManager;
import org.jgroups.util.Util;

public class TxCacheLoaderTest
extends TestCase {
    TreeCache cache1;
    TreeCache cache2;
    static /* synthetic */ Class class$org$jboss$cache$tests$TxCacheLoaderTest;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache1 = new TreeCache();
        this.cache1.setCacheMode("repl_sync");
        this.cache1.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache1.createService();
        this.cache1.startService();
        this.cache2 = new TreeCache();
        this.cache2.setCacheMode("repl_sync");
        this.cache2.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache2.setLockAcquisitionTimeout(2000L);
        this.cache2.createService();
        this.cache2.startService();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.cache1.stopService();
        this.cache1.destroyService();
        this.cache2.stopService();
        this.cache2.destroyService();
    }

    public void testTxPutCommit() throws Exception, NotSupportedException {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache1.put("/one/two/three", (Object)"key1", (Object)"val1");
        this.cache1.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        TxCacheLoaderTest.assertNull((Object)this.cache2.get("/one/two/three", (Object)"key1"));
        TxCacheLoaderTest.assertNull((Object)this.cache2.get("/one/two/three/four", (Object)"key2"));
        tx.commit();
        TxCacheLoaderTest.assertNotNull((Object)this.cache1.getKeys("/one/two/three"));
        Set children = this.cache1.getChildrenNames("/one");
        TxCacheLoaderTest.assertEquals((int)1, (int)children.size());
        Util.sleep((long)100L);
        TxCacheLoaderTest.assertEquals((Object)"val1", (Object)this.cache2.get("/one/two/three", (Object)"key1"));
        TxCacheLoaderTest.assertEquals((Object)"val2", (Object)this.cache2.get("/one/two/three/four", (Object)"key2"));
    }

    public void testTxPrepareAndRollback() throws Exception, NotSupportedException {
        final DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx1 = mgr.getTransaction();
        this.cache1.setLockAcquisitionTimeout(1500L);
        this.cache2.setLockAcquisitionTimeout(1500L);
        Thread locker = new Thread(){
            Transaction tx2 = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    mgr.begin();
                    this.tx2 = mgr.getTransaction();
                    TxCacheLoaderTest.this.cache2.put("/one/two/three", (Object)"block-key1", (Object)"block-val1");
                    Util.sleep((long)5000L);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    if (this.tx2 != null) {
                        try {
                            this.tx2.rollback();
                        }
                        catch (SystemException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }
        };
        locker.start();
        Util.sleep((long)1000L);
        this.cache1.put("/one/two/three", (Object)"key1", (Object)"val1");
        this.cache1.put("/one/two/three/four", (Object)"key2", (Object)"val2");
        try {
            tx1.commit();
            TxCacheLoaderTest.fail((String)"commit() should fail because we cannot acquire the lock on cache2");
        }
        catch (RollbackException rollback) {
            System.out.println("--- TX was rolled back (as expected)");
            TxCacheLoaderTest.assertTrue((boolean)true);
        }
        TxCacheLoaderTest.assertNull((Object)this.cache1.get("/one/two/three", (Object)"key1"));
        TxCacheLoaderTest.assertNull((Object)this.cache1.get("/one/two/three/four", (Object)"key1"));
    }

    public void testPutAfterTxCommit() throws Exception, NotSupportedException {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache1.put("/one/two/three", (Object)"key1", (Object)"val1");
        TxCacheLoaderTest.assertTrue((boolean)this.cache1.exists("/one/two/three"));
        tx.commit();
        TxCacheLoaderTest.assertTrue((boolean)this.cache1.exists("/one/two/three"));
        this.cache1.put("/a/b/c", null);
        TxCacheLoaderTest.assertTrue((boolean)this.cache1.exists("/a/b/c"));
    }

    public void testPutAfterTxRollback() throws Exception, NotSupportedException {
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache1.put("/one/two/three", (Object)"key1", (Object)"val1");
        TxCacheLoaderTest.assertTrue((boolean)this.cache1.exists("/one/two/three"));
        tx.rollback();
        TxCacheLoaderTest.assertFalse((boolean)this.cache1.exists("/one/two/three"));
        this.cache1.put("/a/b/c", null);
        TxCacheLoaderTest.assertTrue((boolean)this.cache1.exists("/a/b/c"));
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$TxCacheLoaderTest == null ? (class$org$jboss$cache$tests$TxCacheLoaderTest = TxCacheLoaderTest.class$("org.jboss.cache.tests.TxCacheLoaderTest")) : class$org$jboss$cache$tests$TxCacheLoaderTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)TxCacheLoaderTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

