/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.tests;

import javax.transaction.NotSupportedException;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.jboss.cache.CacheException;
import org.jboss.cache.TransactionTable;
import org.jboss.cache.TreeCache;
import org.jboss.cache.transaction.DummyTransactionManager;

public class PrepareTxTest
extends TestCase {
    TreeCache cache;
    static /* synthetic */ Class class$org$jboss$cache$tests$PrepareTxTest;

    protected void setUp() throws Exception {
        super.setUp();
        this.cache = new TreeCache();
        this.cache.setCacheMode("local");
        this.cache.setTransactionManagerLookupClass("org.jboss.cache.DummyTransactionManagerLookup");
        this.cache.createService();
        this.cache.startService();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.cache.stopService();
        this.cache.destroyService();
    }

    public void testCacheModificationInBeforeCompletionPhase() throws Exception, NotSupportedException {
        int numLocks = 0;
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        System.out.println("before commit:\n" + this.cache.printLockInfo());
        numLocks = this.cache.getNumberOfLocksHeld();
        PrepareTxTest.assertEquals((int)3, (int)numLocks);
        tx.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
                try {
                    PrepareTxTest.this.cache.put("/a/b/c", null);
                    System.out.println("before commit:\n" + PrepareTxTest.this.cache.printLockInfo());
                }
                catch (CacheException e) {
                    e.printStackTrace();
                }
            }

            public void afterCompletion(int status) {
            }
        });
        tx.commit();
        System.out.println("after commit:\n" + this.cache.printLockInfo());
        numLocks = this.cache.getNumberOfLocksHeld();
        PrepareTxTest.assertEquals((int)0, (int)numLocks);
        TransactionTable tx_table = this.cache.getTransactionTable();
        int num_local_txs = tx_table.getNumLocalTransactions();
        int num_global_txs = tx_table.getNumGlobalTransactions();
        System.out.println("Number of Transactions: " + num_local_txs + "\nNumber of GlobalTransactions: " + num_global_txs + "\nTransactionTable:\n " + tx_table.toString(true));
        PrepareTxTest.assertEquals((int)num_local_txs, (int)num_global_txs);
        PrepareTxTest.assertEquals((int)0, (int)num_local_txs);
    }

    public void testCacheModificationInAfterCompletionPhase() throws Exception, NotSupportedException {
        int numLocks = 0;
        DummyTransactionManager mgr = DummyTransactionManager.getInstance();
        mgr.begin();
        Transaction tx = mgr.getTransaction();
        this.cache.put("/one/two/three", (Object)"key1", (Object)"val1");
        System.out.println("before commit:\n" + this.cache.printLockInfo());
        numLocks = this.cache.getNumberOfLocksHeld();
        PrepareTxTest.assertEquals((int)3, (int)numLocks);
        tx.registerSynchronization(new Synchronization(){

            public void beforeCompletion() {
            }

            public void afterCompletion(int status) {
                try {
                    PrepareTxTest.this.cache.put("/a/b/c", null);
                    System.out.println("before commit:\n" + PrepareTxTest.this.cache.printLockInfo());
                }
                catch (CacheException e) {
                    e.printStackTrace();
                }
            }
        });
        tx.commit();
        System.out.println("after commit:\n" + this.cache.printLockInfo());
        numLocks = this.cache.getNumberOfLocksHeld();
        PrepareTxTest.assertEquals((int)0, (int)numLocks);
        TransactionTable tx_table = this.cache.getTransactionTable();
        int num_local_txs = tx_table.getNumLocalTransactions();
        int num_global_txs = tx_table.getNumGlobalTransactions();
        System.out.println("Number of Transactions: " + num_local_txs + "\nNumber of GlobalTransactions: " + num_global_txs + "\nTransactionTable:\n " + tx_table.toString(true));
        PrepareTxTest.assertEquals((int)num_local_txs, (int)num_global_txs);
        PrepareTxTest.assertEquals((int)0, (int)num_local_txs);
    }

    public static Test suite() {
        return new TestSuite(class$org$jboss$cache$tests$PrepareTxTest == null ? (class$org$jboss$cache$tests$PrepareTxTest = PrepareTxTest.class$("org.jboss.cache.tests.PrepareTxTest")) : class$org$jboss$cache$tests$PrepareTxTest);
    }

    public static void main(String[] args) {
        TestRunner.run((Test)PrepareTxTest.suite());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

