/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cache.interceptors;

import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.jboss.cache.TreeCache;
import org.jboss.cache.interceptors.Interceptor;
import org.jboss.cache.lock.IdentityLock;
import org.jgroups.blocks.MethodCall;

public class UnlockInterceptor
extends Interceptor {
    HashMap lock_table = null;
    TransactionManager tx_mgr = null;

    public void setCache(TreeCache cache) {
        super.setCache(cache);
        this.tx_mgr = cache.getTransactionManager();
        this.lock_table = cache.getLockTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodCall m) throws Throwable {
        try {
            Object object = super.invoke(m);
            return object;
        }
        finally {
            List locks;
            Transaction tx;
            if (!(this.tx_mgr != null && (tx = this.tx_mgr.getTransaction()) != null && this.isValid(tx) || (locks = (List)this.lock_table.get(Thread.currentThread())) == null)) {
                this.releaseLocks(locks);
                this.lock_table.remove(Thread.currentThread());
            }
        }
    }

    private void releaseLocks(List locks) {
        if (locks != null) {
            ListIterator it = locks.listIterator(locks.size());
            while (it.hasPrevious()) {
                IdentityLock lock = (IdentityLock)it.previous();
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("releasing lock for " + lock.getFqn() + ": " + lock));
                }
                lock.release(Thread.currentThread());
            }
            locks.clear();
        }
    }
}

