/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.trading.constraint.Constraint;
import org.jacorb.trading.constraint.ParseException;
import org.jacorb.trading.constraint.Preference;
import org.jacorb.trading.db.OfferDatabase;
import org.jacorb.trading.impl.ImportAttrib;
import org.jacorb.trading.impl.LinkImpl;
import org.jacorb.trading.impl.OfferEvaluator;
import org.jacorb.trading.impl.OfferIteratorImpl;
import org.jacorb.trading.impl.ProxySourceAdapter;
import org.jacorb.trading.impl.SchemaAdapter;
import org.jacorb.trading.impl.SourceAdapter;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.jacorb.trading.util.PropUtil;
import org.jacorb.trading.util.QueryContainer;
import org.jacorb.trading.util.QueryPropagator;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.Object;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.DuplicatePolicyName;
import org.omg.CosTrading.DuplicatePropertyName;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.FollowOptionHelper;
import org.omg.CosTrading.IllegalConstraint;
import org.omg.CosTrading.IllegalPropertyName;
import org.omg.CosTrading.IllegalServiceType;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.LinkPackage.LinkInfo;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.LookupPOA;
import org.omg.CosTrading.LookupPackage.IllegalPolicyName;
import org.omg.CosTrading.LookupPackage.IllegalPreference;
import org.omg.CosTrading.LookupPackage.InvalidPolicyValue;
import org.omg.CosTrading.LookupPackage.PolicyTypeMismatch;
import org.omg.CosTrading.LookupPackage.SpecifiedProps;
import org.omg.CosTrading.Offer;
import org.omg.CosTrading.OfferIterator;
import org.omg.CosTrading.OfferIteratorHolder;
import org.omg.CosTrading.OfferSeqHolder;
import org.omg.CosTrading.Policy;
import org.omg.CosTrading.PolicyNameSeqHolder;
import org.omg.CosTrading.Property;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.ProxyPackage.ProxyInfo;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterPackage.OfferInfo;
import org.omg.CosTrading.UnknownServiceType;
import org.omg.CosTradingRepos.ServiceTypeRepository;
import org.omg.CosTradingRepos.ServiceTypeRepositoryHelper;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.PropertyMode;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.SpecifiedServiceTypes;
import org.omg.CosTradingRepos.ServiceTypeRepositoryPackage.TypeStruct;

public class LookupImpl
extends LookupPOA {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private ImportAttrib m_import;
    private OfferDatabase m_db;
    private ServiceTypeRepository m_repos;
    private LinkImpl m_link_if;
    private static int m_query_counter;
    private Hashtable m_query_cache_lookup;
    private Vector m_query_cache_queue;
    private int m_query_cache_max = 100;
    private QueryPropagator m_query_distrib;
    private LinkInfo[] m_links_cache;
    private static int count;
    private Logger logger;

    private LookupImpl() {
    }

    public LookupImpl(TraderComp traderComp, SupportAttrib supportAttrib, ImportAttrib importAttrib, OfferDatabase db, LinkImpl link, org.jacorb.config.Configuration config) {
        this.m_traderComp = traderComp;
        this.m_support = supportAttrib;
        this.m_import = importAttrib;
        this.m_db = db;
        Object obj = supportAttrib.getTypeRepos();
        this.m_repos = ServiceTypeRepositoryHelper.narrow(obj);
        this.logger = config.getNamedLogger("jacorb.trading");
        this.m_query_cache_max = config.getAttributeAsInteger("jtrader.impl.cache_max", 100);
        this.m_link_if = link;
        this.m_query_cache_lookup = new Hashtable((int)(1.3333333333333333 * (double)this.m_query_cache_max) + 10);
        this.m_query_cache_queue = new Vector(this.m_query_cache_max + 2);
        this.m_query_distrib = new QueryPropagator();
        try {
            this.m_query_distrib.configure((Configuration)config);
        }
        catch (ConfigurationException ce) {
            this.logger.error("ConfigurationException", (Throwable)ce);
            throw new INITIALIZE(ce.getMessage());
        }
    }

    public String _object_name() {
        return "TradingService";
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    public int def_search_card() {
        return this.m_import.getDefSearchCard();
    }

    public int max_search_card() {
        return this.m_import.getMaxSearchCard();
    }

    public int def_match_card() {
        return this.m_import.getDefMatchCard();
    }

    public int max_match_card() {
        return this.m_import.getMaxMatchCard();
    }

    public int def_return_card() {
        return this.m_import.getDefReturnCard();
    }

    public int max_return_card() {
        return this.m_import.getMaxReturnCard();
    }

    public int max_list() {
        return this.m_import.getMaxList();
    }

    public int def_hop_count() {
        return this.m_import.getDefHopCount();
    }

    public int max_hop_count() {
        return this.m_import.getMaxHopCount();
    }

    public FollowOption def_follow_policy() {
        return this.m_import.getDefFollowPolicy();
    }

    public FollowOption max_follow_policy() {
        return this.m_import.getMaxFollowPolicy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void query(String type, String constr, String pref, Policy[] policies, SpecifiedProps desired_props, int how_many, OfferSeqHolder offers, OfferIteratorHolder offer_itr, PolicyNameSeqHolder limits_applied) throws IllegalServiceType, UnknownServiceType, IllegalConstraint, IllegalPreference, IllegalPolicyName, PolicyTypeMismatch, InvalidPolicyValue, IllegalPropertyName, DuplicatePropertyName, DuplicatePolicyName {
        int no = count++;
        TypeStruct ts = this.m_repos.fully_describe_type(type);
        Hashtable<String, Any> policyTable = new Hashtable<String, Any>();
        for (int i = 0; i < policies.length; ++i) {
            if (policyTable.containsKey(policies[i].name)) {
                throw new DuplicatePolicyName(policies[i].name);
            }
            policyTable.put(policies[i].name, policies[i].value);
        }
        String _id = this.getPolicyValue(policyTable, "request_id", new String());
        Vector<Policy> _generated_policies = new Vector<Policy>();
        if (_id.length() == 0) {
            StringBuffer _new_id = new StringBuffer(new String(this.admin_if().request_id_stem()));
            _new_id.append(m_query_counter++);
            Policy _id_policy = new Policy();
            _id_policy.name = "request_id";
            _id_policy.value = this._orb().create_any();
            _id_policy.value.insert_string(_new_id.toString());
            _generated_policies.addElement(_id_policy);
            _id = _new_id.toString();
        }
        if (this.queryAlreadyEncountered(_id)) {
            offers.value = new Offer[0];
            limits_applied.value = new String[0];
            return;
        }
        if (!policyTable.containsKey("hop_count")) {
            Policy _hop_policy = new Policy();
            _hop_policy.name = "hop_count";
            _hop_policy.value = this._orb().create_any();
            _hop_policy.value.insert_ulong(this.def_hop_count());
            _generated_policies.addElement(_hop_policy);
            policyTable.put("hop_count", _hop_policy.value);
        }
        if (_generated_policies.size() > 0) {
            Policy[] _new_policies = new Policy[policies.length + _generated_policies.size()];
            System.arraycopy(policies, 0, _new_policies, 0, policies.length);
            Enumeration _gen_polic_enum = _generated_policies.elements();
            int _j = policies.length;
            while (_gen_polic_enum.hasMoreElements()) {
                _new_policies[_j++] = (Policy)_gen_polic_enum.nextElement();
            }
            policies = _new_policies;
        }
        int searchCard = this.getPolicyValue(policyTable, "search_card", this.def_search_card(), this.max_search_card());
        int matchCard = this.getPolicyValue(policyTable, "match_card", this.def_match_card(), this.max_match_card());
        int returnCard = this.getPolicyValue(policyTable, "return_card", this.def_return_card(), this.max_return_card());
        boolean exactType = this.getPolicyValue(policyTable, "exact_type_match", false);
        boolean useDynamic = !this.supports_dynamic_properties() ? false : this.getPolicyValue(policyTable, "use_dynamic_properties", true);
        boolean useModifiable = !this.supports_modifiable_properties() ? false : this.getPolicyValue(policyTable, "use_modifiable_properties", true);
        boolean useProxyOffers = !this.supports_proxy_offers() ? false : this.getPolicyValue(policyTable, "use_proxy_offers", true);
        FollowOption link_follow_rule = this.getPolicyValue(policyTable, "link_follow_rule", this.def_follow_policy(), this.max_follow_policy());
        int hop_count = this.getPolicyValue(policyTable, "hop_count", this.def_hop_count(), this.max_hop_count());
        Any _hop = (Any)policyTable.get("hop_count");
        _hop.insert_ulong(_hop.extract_ulong() - 1);
        QueryContainer _templ = new QueryContainer(type, constr, pref, policies, desired_props, how_many, null);
        Vector _queries = new Vector();
        Hashtable _used_links = new Hashtable();
        if (hop_count > 0 && link_follow_rule.value() == FollowOption.always.value()) {
            this.distributeQuery(_queries, _templ, link_follow_rule, _used_links);
        }
        if (pref == null || pref.trim().length() == 0) {
            pref = "first";
        }
        SchemaAdapter schema = new SchemaAdapter(ts);
        Constraint constraint = new Constraint(schema);
        Preference preference = new Preference(schema);
        try {
            constraint.parse(constr);
        }
        catch (ParseException ex) {
            System.out.println("Illegal constraint '" + constr + "'");
            System.out.println(ex.getMessage());
            throw new IllegalConstraint(constr);
        }
        try {
            preference.parse(pref);
        }
        catch (ParseException ex) {
            System.out.println("Illegal preference '" + pref + "'");
            System.out.println(ex.getMessage());
            throw new IllegalPreference(pref);
        }
        Vector<String> types = new Vector<String>();
        types.addElement(type);
        if (!exactType) {
            this.findCompatibleTypes(type, types);
        }
        try {
            OfferEvaluator eval;
            Vector matchingOffers;
            SourceAdapter source;
            IDLEntity info;
            Enumeration o;
            Hashtable table;
            String typeName;
            this.m_db.begin(0);
            int searchCount = 0;
            Vector<SourceAdapter> potentialOffers = new Vector<SourceAdapter>();
            Enumeration e = types.elements();
            while (e.hasMoreElements() && searchCount < searchCard) {
                typeName = (String)e.nextElement();
                table = this.m_db.getOffers(typeName);
                if (table == null) continue;
                o = table.elements();
                while (o.hasMoreElements() && searchCount < searchCard) {
                    info = (OfferInfo)o.nextElement();
                    source = new SourceAdapter(info.reference, info.properties);
                    if (!this.considerOffer(source, useDynamic, useModifiable, ts)) continue;
                    potentialOffers.addElement(source);
                    ++searchCount;
                }
            }
            if (useProxyOffers) {
                e = types.elements();
                while (e.hasMoreElements() && searchCount < searchCard) {
                    typeName = (String)e.nextElement();
                    table = this.m_db.getProxyOffers(typeName);
                    if (table == null) continue;
                    o = table.elements();
                    while (o.hasMoreElements() && searchCount < searchCard) {
                        info = (ProxyInfo)o.nextElement();
                        source = new ProxySourceAdapter((ProxyInfo)info);
                        if (!this.considerOffer(source, useDynamic, useModifiable, ts)) continue;
                        potentialOffers.addElement(source);
                        ++searchCount;
                    }
                }
            }
            if ((matchingOffers = (eval = new OfferEvaluator(type, constraint, pref, policies, desired_props, potentialOffers, matchCard)).getResults()).size() == 0 && hop_count > 0 && link_follow_rule.value() >= FollowOption.if_no_local.value()) {
                this.distributeQuery(_queries, _templ, link_follow_rule, _used_links);
            }
            Enumeration _results = _queries.elements();
            Vector<QueryContainer> _dropped = new Vector<QueryContainer>();
            Vector<String> _applied_policies = new Vector<String>();
            while (_results.hasMoreElements()) {
                QueryContainer _distrib_query = (QueryContainer)_results.nextElement();
                try {
                    _distrib_query.resultReady();
                }
                catch (Exception _e) {
                    _e.printStackTrace();
                    continue;
                }
                UserException _query_exception = _distrib_query.getException();
                if (_query_exception != null) {
                    _dropped.addElement(_distrib_query);
                    continue;
                }
                OfferSeqHolder _offers = _distrib_query.getOffers();
                if (_offers.value == null || _offers.value.length == 0) {
                    _dropped.addElement(_distrib_query);
                    continue;
                }
                for (int i = 0; i < _offers.value.length; ++i) {
                    matchingOffers.addElement(_offers.value[i]);
                }
                PolicyNameSeqHolder _policy_holder = _distrib_query.getLimits();
                if (_policy_holder.value == null) continue;
                for (int i = 0; i < _policy_holder.value.length; ++i) {
                    _applied_policies.addElement(_policy_holder.value[i]);
                }
            }
            for (int _i = 0; _i < _dropped.size(); ++_i) {
                _queries.removeElement(_dropped.elementAt(_i));
            }
            int matchCount = matchingOffers.size();
            Vector orderedOffers = preference.order(matchingOffers);
            int returnCount = Math.min(matchCount, returnCard);
            int seqCount = Math.min(returnCount, how_many);
            offers.value = new Offer[seqCount];
            e = orderedOffers.elements();
            for (int count = 0; e.hasMoreElements() && count < seqCount; ++count) {
                java.lang.Object _element = e.nextElement();
                if (_element instanceof Offer) {
                    offers.value[count] = (Offer)_element;
                    continue;
                }
                SourceAdapter src = (SourceAdapter)_element;
                offers.value[count] = new Offer();
                offers.value[count].reference = src.getObject();
                offers.value[count].properties = src.getProperties(desired_props);
            }
            if (seqCount < returnCount) {
                int pos;
                int restCount = returnCount - seqCount;
                Vector rest = new Vector(restCount);
                for (pos = 0; e.hasMoreElements() && pos < restCount; ++pos) {
                    java.lang.Object _element = e.nextElement();
                    if (_element instanceof Offer) {
                        rest.addElement(_element);
                        continue;
                    }
                    SourceAdapter src = (SourceAdapter)_element;
                    Offer _off = new Offer();
                    _off.reference = src.getObject();
                    _off.properties = src.getProperties(desired_props);
                    rest.addElement(_off);
                }
                _results = _queries.elements();
                while (pos < restCount && _results.hasMoreElements()) {
                    ++pos;
                    QueryContainer _distrib_query = (QueryContainer)_results.nextElement();
                    OfferIteratorHolder _itr_holder = _distrib_query.getItr();
                    if (_itr_holder.value == null) continue;
                    Offer[] _offers = null;
                    try {
                        _offers = ((OfferIteratorImpl)((java.lang.Object)_itr_holder.value)).getOffers();
                    }
                    catch (Exception _e) {
                        // empty catch block
                    }
                    if (_offers == null) {
                        OfferIterator _itr = _itr_holder.value;
                        OfferSeqHolder _seq = new OfferSeqHolder();
                        _itr.next_n(restCount - pos, _seq);
                        _offers = _seq.value;
                    }
                    int _i = 0;
                    while (_i < _offers.length && pos < restCount) {
                        ++pos;
                        rest.addElement(_offers[_i++]);
                    }
                }
                Enumeration _offer_enum = rest.elements();
                Offer[] _offer_array = new Offer[rest.size()];
                int _i = 0;
                while (_offer_enum.hasMoreElements()) {
                    _offer_array[_i++] = (Offer)_offer_enum.nextElement();
                }
                OfferIteratorImpl iter = new OfferIteratorImpl(_offer_array, 0);
                iter._this_object(this._orb());
                offer_itr.value = iter._this();
            }
            Enumeration _applied_limits = _applied_policies.elements();
            limits_applied.value = new String[_applied_policies.size()];
            int _i = 0;
            while (_applied_limits.hasMoreElements()) {
                limits_applied.value[_i++] = (String)_applied_limits.nextElement();
            }
        }
        finally {
            this.m_db.end();
        }
    }

    private boolean queryAlreadyEncountered(String id) {
        boolean _id_known = this.m_query_cache_lookup.containsKey(id);
        if (!_id_known) {
            this.m_query_cache_lookup.put(id, id);
            this.m_query_cache_queue.addElement(id);
            if (this.m_query_cache_queue.size() > this.m_query_cache_max) {
                java.lang.Object _old = this.m_query_cache_queue.firstElement();
                this.m_query_cache_queue.removeElementAt(0);
                this.m_query_cache_lookup.remove(_old);
            }
        }
        return _id_known;
    }

    protected FollowOption getPolicyValue(Hashtable policies, String name, FollowOption defaultValue, FollowOption maxValue) throws PolicyTypeMismatch, InvalidPolicyValue {
        FollowOption result = defaultValue;
        Any value = (Any)policies.get(name);
        if (value != null) {
            try {
                TypeCode _type = FollowOptionHelper.type();
                if (!_type.equal(value.type())) {
                    throw new PolicyTypeMismatch(new Policy(name, value));
                }
                result = FollowOptionHelper.extract(value);
            }
            catch (BAD_OPERATION e) {
                throw new InvalidPolicyValue(new Policy(name, value));
            }
        }
        return FollowOption.from_int(Math.min(result.value(), maxValue.value()));
    }

    private void updateLinks() {
        if (this.m_link_if.linksChanged()) {
            this.m_links_cache = this.m_link_if.getLinks();
        }
    }

    private void distributeQuery(Vector queries, QueryContainer template, FollowOption link_follow_rule, Hashtable used_links) {
        this.updateLinks();
        LinkInfo[] _links = this.m_links_cache;
        for (int i = 0; i < _links.length; ++i) {
            if (_links[i].limiting_follow_rule.value() < link_follow_rule.value() || used_links.containsKey(_links[i].target)) continue;
            QueryContainer _query = new QueryContainer(template, _links[i].target);
            queries.addElement(_query);
            this.m_query_distrib.putWork(_query);
            used_links.put(_links[i].target, _links[i].target);
        }
    }

    protected int getPolicyValue(Hashtable policies, String name, int defaultValue, int maxValue) throws PolicyTypeMismatch, InvalidPolicyValue {
        int result = defaultValue;
        Any value = (Any)policies.get(name);
        if (value != null) {
            try {
                if (value.type().kind() != TCKind.tk_ulong) {
                    throw new PolicyTypeMismatch(new Policy(name, value));
                }
                result = value.extract_ulong();
            }
            catch (BAD_OPERATION e) {
                throw new InvalidPolicyValue(new Policy(name, value));
            }
        }
        result = Math.min(result, maxValue);
        return result;
    }

    protected boolean getPolicyValue(Hashtable policies, String name, boolean defaultValue) throws PolicyTypeMismatch, InvalidPolicyValue {
        boolean result = defaultValue;
        Any value = (Any)policies.get(name);
        if (value != null) {
            try {
                if (value.type().kind() != TCKind.tk_boolean) {
                    throw new PolicyTypeMismatch(new Policy(name, value));
                }
                result = value.extract_boolean();
            }
            catch (BAD_OPERATION e) {
                throw new InvalidPolicyValue(new Policy(name, value));
            }
        }
        return result;
    }

    protected String getPolicyValue(Hashtable policies, String name, String defaultValue) throws PolicyTypeMismatch, InvalidPolicyValue {
        String result = defaultValue;
        Any value = (Any)policies.get(name);
        if (value != null) {
            try {
                if (value.type().kind() != TCKind.tk_string) {
                    throw new PolicyTypeMismatch(new Policy(name, value));
                }
                result = value.extract_string();
            }
            catch (BAD_OPERATION e) {
                throw new InvalidPolicyValue(new Policy(name, value));
            }
        }
        return result;
    }

    protected void findCompatibleTypes(String type, Vector types) {
        SpecifiedServiceTypes whichTypes = new SpecifiedServiceTypes();
        whichTypes.__default();
        String[] allNames = this.m_repos.list_types(whichTypes);
        block3: for (int i = 0; i < allNames.length; ++i) {
            try {
                TypeStruct ts = this.m_repos.fully_describe_type(allNames[i]);
                for (int n = 0; n < ts.super_types.length; ++n) {
                    if (!type.equals(ts.super_types[n])) continue;
                    if (types.contains(allNames[i])) continue block3;
                    types.addElement(allNames[i]);
                    continue block3;
                }
                continue;
            }
            catch (IllegalServiceType e) {
                continue;
            }
            catch (UnknownServiceType e) {
                // empty catch block
            }
        }
    }

    protected boolean considerOffer(SourceAdapter source, boolean useDynamic, boolean useModifiable, TypeStruct ts) {
        Property[] props;
        if (!useDynamic && PropUtil.hasDynamicProperties(props = source.getProperties())) {
            return false;
        }
        if (!useModifiable) {
            for (int i = 0; i < ts.props.length; ++i) {
                if (ts.props[i].mode != PropertyMode.PROP_NORMAL && ts.props[i].mode != PropertyMode.PROP_MANDATORY || !source.exists(ts.props[i].name)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        count = 0;
    }
}

