/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.impl;

import java.util.Enumeration;
import java.util.Hashtable;
import org.jacorb.trading.impl.LinkAttrib;
import org.jacorb.trading.impl.SupportAttrib;
import org.jacorb.trading.impl.TraderComp;
import org.omg.CORBA.Object;
import org.omg.CosTrading.Admin;
import org.omg.CosTrading.FollowOption;
import org.omg.CosTrading.InvalidLookupRef;
import org.omg.CosTrading.Link;
import org.omg.CosTrading.LinkOperations;
import org.omg.CosTrading.LinkPOA;
import org.omg.CosTrading.LinkPackage.DefaultFollowTooPermissive;
import org.omg.CosTrading.LinkPackage.DuplicateLinkName;
import org.omg.CosTrading.LinkPackage.IllegalLinkName;
import org.omg.CosTrading.LinkPackage.LimitingFollowTooPermissive;
import org.omg.CosTrading.LinkPackage.LinkInfo;
import org.omg.CosTrading.LinkPackage.UnknownLinkName;
import org.omg.CosTrading.Lookup;
import org.omg.CosTrading.Proxy;
import org.omg.CosTrading.Register;
import org.omg.CosTrading.RegisterHelper;

public class LinkImpl
extends LinkPOA
implements LinkOperations {
    private TraderComp m_traderComp;
    private SupportAttrib m_support;
    private LinkAttrib m_link;
    private Hashtable m_current_links;
    private boolean m_links_changed = true;

    public LinkImpl(TraderComp trader_comp, SupportAttrib support, LinkAttrib link) {
        this.m_traderComp = trader_comp;
        this.m_support = support;
        this.m_link = link;
        this.m_current_links = new Hashtable();
    }

    public Lookup lookup_if() {
        return this.m_traderComp.getLookupInterface();
    }

    public Register register_if() {
        return this.m_traderComp.getRegisterInterface();
    }

    public Link link_if() {
        return this.m_traderComp.getLinkInterface();
    }

    public Proxy proxy_if() {
        return this.m_traderComp.getProxyInterface();
    }

    public Admin admin_if() {
        return this.m_traderComp.getAdminInterface();
    }

    public boolean supports_modifiable_properties() {
        return this.m_support.getModifiableProperties();
    }

    public boolean supports_dynamic_properties() {
        return this.m_support.getDynamicProperties();
    }

    public boolean supports_proxy_offers() {
        return this.m_support.getProxyOffers();
    }

    public Object type_repos() {
        return this.m_support.getTypeRepos();
    }

    public FollowOption max_link_follow_policy() {
        return this.m_link.getMaxLinkFollowPolicy();
    }

    public void add_link(String name, Lookup target, FollowOption default_follow_rule, FollowOption limiting_follow_rule) throws IllegalLinkName, DuplicateLinkName, InvalidLookupRef, DefaultFollowTooPermissive, LimitingFollowTooPermissive {
        if (name == null || name.length() == 0) {
            throw new IllegalLinkName(name);
        }
        if (this.m_current_links.containsKey(name)) {
            throw new DuplicateLinkName(name);
        }
        Register _reg = null;
        try {
            Register _obj = target.register_if();
            _reg = RegisterHelper.narrow(_obj);
        }
        catch (Exception e) {
            throw new InvalidLookupRef(target);
        }
        if (default_follow_rule.value() > limiting_follow_rule.value()) {
            throw new DefaultFollowTooPermissive(default_follow_rule, limiting_follow_rule);
        }
        if (limiting_follow_rule.value() > this.max_link_follow_policy().value()) {
            throw new LimitingFollowTooPermissive(default_follow_rule, limiting_follow_rule);
        }
        LinkInfo _info = new LinkInfo(target, _reg, default_follow_rule, limiting_follow_rule);
        this.m_current_links.put(name, _info);
        this.m_links_changed = true;
    }

    public LinkInfo describe_link(String name) throws IllegalLinkName, UnknownLinkName {
        if (name == null || name.length() == 0) {
            throw new IllegalLinkName(name);
        }
        LinkInfo _result = (LinkInfo)this.m_current_links.get(name);
        if (_result == null) {
            throw new UnknownLinkName(name);
        }
        return _result;
    }

    public String[] list_links() {
        String[] _links_array = new String[this.m_current_links.size()];
        Enumeration _links = this.m_current_links.keys();
        int _i = 0;
        while (_links.hasMoreElements()) {
            _links_array[_i++] = (String)_links.nextElement();
        }
        return _links_array;
    }

    public void modify_link(String name, FollowOption default_follow_rule, FollowOption limiting_follow_rule) throws IllegalLinkName, UnknownLinkName, DefaultFollowTooPermissive, LimitingFollowTooPermissive {
        if (name == null || name.length() == 0) {
            throw new IllegalLinkName(name);
        }
        if (!this.m_current_links.containsKey(name)) {
            throw new UnknownLinkName(name);
        }
        if (default_follow_rule.value() > limiting_follow_rule.value()) {
            throw new DefaultFollowTooPermissive(default_follow_rule, limiting_follow_rule);
        }
        if (limiting_follow_rule.value() > this.max_link_follow_policy().value()) {
            throw new LimitingFollowTooPermissive(default_follow_rule, limiting_follow_rule);
        }
        LinkInfo _link = (LinkInfo)this.m_current_links.get(name);
        _link.def_pass_on_follow_rule = default_follow_rule;
        _link.limiting_follow_rule = limiting_follow_rule;
        this.m_links_changed = true;
    }

    public void remove_link(String name) throws IllegalLinkName, UnknownLinkName {
        if (name == null || name.length() == 0) {
            throw new IllegalLinkName(name);
        }
        if (!this.m_current_links.containsKey(name)) {
            throw new UnknownLinkName(name);
        }
        this.m_current_links.remove(name);
        this.m_links_changed = true;
    }

    public boolean linksChanged() {
        return this.m_links_changed;
    }

    public LinkInfo[] getLinks() {
        LinkInfo[] _links_array = new LinkInfo[this.m_current_links.size()];
        Enumeration _links = this.m_current_links.elements();
        int _i = 0;
        while (_links.hasMoreElements()) {
            _links_array[_i++] = (LinkInfo)_links.nextElement();
        }
        this.m_links_changed = false;
        return _links_array;
    }
}

