/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.db.simple.offers;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import org.jacorb.trading.TradingService;
import org.jacorb.trading.db.simple.offers.TypeCodeValue;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_OPERATION;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;

public class AnyValue
implements Serializable {
    private TypeCodeValue m_type;
    private Object m_value;
    static final long serialVersionUID = 3945922728443512828L;
    private transient DynAnyFactory factory;
    private transient ORB orb;
    private transient boolean initialized = false;

    private AnyValue() {
    }

    public AnyValue(ORB orb, Any any) {
        this.init(orb);
        this.setValue(any);
    }

    public void init(ORB orb) {
        this.orb = orb;
        try {
            this.factory = DynAnyFactoryHelper.narrow(orb.resolve_initial_references("DynAnyFactory"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initialized = true;
    }

    public static boolean isTypeSupported(TypeCode type) {
        boolean result = false;
        try {
            TypeCode tc = type;
            while (tc.kind() == TCKind.tk_alias) {
                tc = tc.content_type();
            }
            TCKind kind = tc.kind();
            if (kind == TCKind.tk_null || kind == TCKind.tk_void) {
                result = true;
            } else {
                if (kind == TCKind.tk_sequence) {
                    TypeCode contentType = tc.content_type();
                    kind = contentType.kind();
                }
                switch (kind.value()) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 18: {
                        result = true;
                    }
                }
            }
        }
        catch (BadKind e) {
        }
        catch (BAD_OPERATION bAD_OPERATION) {
            // empty catch block
        }
        return result;
    }

    public Any getValue() {
        if (!this.initialized) {
            throw new RuntimeException("AnyVale not initialized!");
        }
        Any result = null;
        TypeCode origType = this.m_type.getValue();
        boolean isSequence = false;
        try {
            TypeCode tc = origType;
            while (tc.kind() == TCKind.tk_alias) {
                tc = tc.content_type();
            }
            TCKind kind = tc.kind();
            if (kind == TCKind.tk_sequence) {
                TypeCode content = tc.content_type();
                kind = content.kind();
                isSequence = true;
            }
            switch (kind.value()) {
                case 0: 
                case 1: {
                    result = this.orb.create_any();
                    result.type(origType);
                    break;
                }
                case 2: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (short[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_short(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Short)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_short((Short)val);
                    result = da.to_any();
                    break;
                }
                case 3: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (int[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_long(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Integer)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_long((Integer)val);
                    result = da.to_any();
                    break;
                }
                case 4: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (short[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_ushort(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Short)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_ushort((Short)val);
                    result = da.to_any();
                    break;
                }
                case 5: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (int[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_ulong(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Integer)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_ulong((Integer)val);
                    result = da.to_any();
                    break;
                }
                case 6: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (float[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_float(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Float)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_float(((Float)val).floatValue());
                    result = da.to_any();
                    break;
                }
                case 7: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (double[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_double(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Double)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_double((Double)val);
                    result = da.to_any();
                    break;
                }
                case 8: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (boolean[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_boolean(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Boolean)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_boolean((Boolean)val);
                    result = da.to_any();
                    break;
                }
                case 9: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (char[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_char(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Character)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_char(((Character)val).charValue());
                    result = da.to_any();
                    break;
                }
                case 18: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (String[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_string((String)arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (String)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_string((String)val);
                    result = da.to_any();
                    break;
                }
                case 10: {
                    Object[] arr;
                    if (isSequence) {
                        arr = (byte[])this.m_value;
                        DynSequence ds = (DynSequence)this.factory.create_dyn_any_from_type_code(origType);
                        ds.set_length(arr.length);
                        ds.rewind();
                        for (int i = 0; i < arr.length; ++i) {
                            ds.current_component().insert_octet(arr[i]);
                            ds.next();
                        }
                        result = ds.to_any();
                        break;
                    }
                    Object val = (Byte)this.m_value;
                    DynAny da = this.factory.create_dyn_any_from_type_code(origType);
                    da.insert_octet((Byte)val);
                    result = da.to_any();
                }
            }
        }
        catch (BadKind e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InvalidValue e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (TypeMismatch e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InconsistentTypeCode e) {
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }

    protected void setValue(Any val) {
        if (!this.initialized) {
            throw new RuntimeException("AnyVale not initialized!");
        }
        TypeCode origType = val.type();
        this.m_type = new TypeCodeValue(origType);
        boolean isSequence = false;
        try {
            TypeCode tc = origType;
            while (tc.kind() == TCKind.tk_alias) {
                tc = tc.content_type();
            }
            TCKind kind = tc.kind();
            if (kind == TCKind.tk_sequence) {
                TypeCode content = tc.content_type();
                kind = content.kind();
                isSequence = true;
            }
            DynAny da = this.factory.create_dyn_any(val);
            switch (kind.value()) {
                case 0: {
                    this.m_value = null;
                    break;
                }
                case 1: {
                    this.m_value = null;
                    break;
                }
                case 2: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        short[] arr = new short[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_short();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Short(da.get_short());
                    break;
                }
                case 3: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        int[] arr = new int[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_long();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Integer(da.get_long());
                    break;
                }
                case 4: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        short[] arr = new short[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_ushort();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Short(da.get_ushort());
                    break;
                }
                case 5: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        int[] arr = new int[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_ulong();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Integer(da.get_ulong());
                    break;
                }
                case 6: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        float[] arr = new float[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_float();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Float(da.get_float());
                    break;
                }
                case 7: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        double[] arr = new double[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_double();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Double(da.get_double());
                    break;
                }
                case 8: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        boolean[] arr = new boolean[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_boolean();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Boolean(da.get_boolean());
                    break;
                }
                case 9: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        char[] arr = new char[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_char();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Character(da.get_char());
                    break;
                }
                case 18: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        String[] arr = new String[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_string();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = da.get_string();
                    break;
                }
                case 10: {
                    if (isSequence) {
                        DynSequence ds = DynSequenceHelper.narrow(da);
                        int len = ds.get_length();
                        byte[] arr = new byte[len];
                        for (int i = 0; i < len; ++i) {
                            arr[i] = ds.current_component().get_octet();
                            ds.next();
                        }
                        this.m_value = arr;
                        break;
                    }
                    this.m_value = new Byte(da.get_octet());
                    break;
                }
                default: {
                    throw new RuntimeException("Unsupported type");
                }
            }
            da.destroy();
        }
        catch (BadKind e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (TypeMismatch e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InconsistentTypeCode e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (InvalidValue e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (BAD_OPERATION e) {
            throw new RuntimeException();
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init(TradingService.getORB());
    }
}

