/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import org.jacorb.trading.constraint.Value;

public class StringValue
implements Value {
    private String m_value;

    public StringValue() {
        this(null);
    }

    public StringValue(String value) {
        this.m_value = value;
    }

    public StringValue(Object value) {
        this.m_value = (String)value;
    }

    public void setValue(Object value) {
        this.m_value = (String)value;
    }

    public int getTypeId() {
        return 8;
    }

    public Object getValue() {
        return this.m_value;
    }

    public boolean equals(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 8) {
            throw new IllegalArgumentException();
        }
        result = this.m_value.equals(nv.getValue());
        return result;
    }

    public boolean lessThan(Value nv) {
        boolean result = false;
        if (nv.getTypeId() != 8) {
            throw new IllegalArgumentException();
        }
        String s = (String)nv.getValue();
        result = this.m_value.compareTo(s) < 0;
        return result;
    }

    public boolean lessThanEqual(Value nv) {
        return this.lessThan(nv) || this.equals(nv);
    }

    public boolean greaterThan(Value nv) {
        return !this.lessThan(nv) && !this.equals(nv);
    }

    public boolean greaterThanEqual(Value nv) {
        return !this.lessThan(nv);
    }

    public Value plus(Value nv) {
        throw new ArithmeticException();
    }

    public Value minus(Value nv) {
        throw new ArithmeticException();
    }

    public Value multiply(Value nv) {
        throw new ArithmeticException();
    }

    public Value divide(Value nv) {
        throw new ArithmeticException();
    }

    public Value negate() {
        throw new ArithmeticException();
    }

    public Value convert(int typeId) {
        StringValue result = null;
        if (typeId != 8) {
            throw new IllegalArgumentException();
        }
        result = new StringValue(this.m_value);
        return result;
    }

    public String toString() {
        return this.m_value;
    }
}

