/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.trading.constraint;

import java.io.PrintStream;
import org.jacorb.trading.constraint.ExprNode;
import org.jacorb.trading.constraint.MissingPropertyException;
import org.jacorb.trading.constraint.PropertySource;
import org.jacorb.trading.constraint.Value;
import org.jacorb.trading.constraint.ValueType;

public class PropertyNode
extends ExprNode {
    private String m_name;

    private PropertyNode() {
    }

    public PropertyNode(String name, ValueType type) {
        this.m_name = name;
        this.setType(type);
    }

    public void print(PrintStream ps) {
        ps.println("PropertyNode: name = " + this.m_name + " type = " + this.getType());
    }

    public Value evaluate(PropertySource source) throws MissingPropertyException {
        Value result = source.getValue(this.m_name);
        if (result == null) {
            throw new MissingPropertyException(this.m_name);
        }
        return result;
    }

    public boolean exists(PropertySource source) {
        boolean result = source.exists(this.m_name) && source.getValue(this.m_name) != null;
        return result;
    }

    public boolean inSequence(Value value, PropertySource source) {
        boolean result = false;
        int id = ValueType.promote(this.getType().getId(), value.getTypeId());
        Value v = value.convert(id);
        Value[] seq = source.getSequenceValues(this.m_name);
        for (int i = 0; i < seq.length; ++i) {
            Value nv = seq[i].convert(id);
            if (!v.equals(nv)) continue;
            result = true;
            break;
        }
        return result;
    }
}

