/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import com.sun.net.ssl.internal.ssl.Provider;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Security;
import java.util.StringTokenizer;
import javax.net.ServerSocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;

public class SSLServerSocketFactory
implements org.jacorb.orb.factory.SSLServerSocketFactory,
Configurable {
    private ServerSocketFactory factory = null;
    private boolean require_mutual_auth = false;
    private boolean request_mutual_auth = false;
    private boolean trusteesFromKS = false;
    private String[] cipher_suites = null;
    private String[] enabledProtocols = null;
    private TrustManager trustManager = null;
    private short serverSupportedOptions = 0;
    private short serverRequiredOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private Logger logger;

    public SSLServerSocketFactory(ORB orb) {
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        StringTokenizer tokenizer;
        int tokens;
        block15: {
            block14: {
                this.logger = ((org.jacorb.config.Configuration)configuration).getNamedLogger("jacorb.security.jsse");
                this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
                this.serverSupportedOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.supported_options", "20"), 16);
                this.serverRequiredOptions = Short.parseShort(configuration.getAttribute("jacorb.security.ssl.server.required_options", "0"), 16);
                if ((this.serverSupportedOptions & 0x40) != 0) {
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Will create SSL sockets that request client authentication");
                    }
                    this.request_mutual_auth = true;
                }
                if ((this.serverRequiredOptions & 0x40) != 0) {
                    this.require_mutual_auth = true;
                    this.request_mutual_auth = false;
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Will create SSL sockets that require client authentication");
                    }
                }
                this.keystore_location = configuration.getAttribute("jacorb.security.keystore", "UNSET");
                this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password", "UNSET");
                try {
                    this.trustManager = (TrustManager)((org.jacorb.config.Configuration)configuration).getAttributeAsObject("jacorb.security.ssl.server.trust_manager");
                }
                catch (ConfigurationException ce) {
                    if (!this.logger.isErrorEnabled()) break block14;
                    this.logger.error("TrustManager object creation failed. Please check value of property 'jacorb.security.ssl.server.trust_manager'. Current value: " + configuration.getAttribute("jacorb.security.ssl.server.trust_manager", ""), (Throwable)ce);
                }
            }
            if (configuration.getAttribute("jacorb.security.ssl.server.protocols", null) != null) {
                this.enabledProtocols = (String[])((org.jacorb.config.Configuration)configuration).getAttributeList("jacorb.security.ssl.server.protocols").toArray();
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Setting user specified server enabled protocols : " + configuration.getAttribute("jacorb.security.ssl.server.protocols", ""));
                }
            }
            try {
                this.factory = this.createServerSocketFactory();
            }
            catch (Exception e) {
                if (!this.logger.isWarnEnabled()) break block15;
                this.logger.warn("Exception", (Throwable)e);
            }
        }
        if (this.factory == null) {
            if (this.logger.isErrorEnabled()) {
                this.logger.error("Unable to create ServerSocketFactory!");
            }
            throw new ConfigurationException("Unable to create ServerSocketFactory!");
        }
        String cipher_suite_list = configuration.getAttribute("jacorb.security.ssl.server.cipher_suites", null);
        if (cipher_suite_list != null && (tokens = (tokenizer = new StringTokenizer(cipher_suite_list, ",")).countTokens()) > 0) {
            this.cipher_suites = new String[tokens];
            while (tokenizer.hasMoreElements()) {
                this.cipher_suites[--tokens] = tokenizer.nextToken();
            }
        }
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port);
        if (this.request_mutual_auth) {
            s.setNeedClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s.setEnabledProtocols(this.enabledProtocols);
        }
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port, backlog);
        if (this.request_mutual_auth) {
            s.setNeedClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s.setEnabledProtocols(this.enabledProtocols);
        }
        return s;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket s = (SSLServerSocket)this.factory.createServerSocket(port, backlog, ifAddress);
        if (this.request_mutual_auth) {
            s.setNeedClientAuth(this.request_mutual_auth);
        } else if (this.require_mutual_auth) {
            s.setNeedClientAuth(this.require_mutual_auth);
        }
        if (this.cipher_suites != null) {
            s.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            s.setEnabledProtocols(this.enabledProtocols);
        }
        return s;
    }

    public boolean isSSL(ServerSocket s) {
        return s instanceof SSLServerSocket;
    }

    private ServerSocketFactory createServerSocketFactory() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        Security.addProvider((java.security.Provider)new Provider());
        KeyStore key_store = KeyStoreUtil.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(key_store, this.keystore_passphrase.toCharArray());
        TrustManagerFactory tmf = null;
        if ((this.serverRequiredOptions & 0x40) != 0 || (this.serverSupportedOptions & 0x40) != 0) {
            tmf = TrustManagerFactory.getInstance("SunX509");
            if (this.trusteesFromKS) {
                tmf.init(key_store);
            } else {
                tmf.init((KeyStore)null);
            }
        }
        if (this.trustManager == null) {
            trustManagers = tmf == null ? null : tmf.getTrustManagers();
        } else {
            trustManagers = new TrustManager[]{this.trustManager};
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified server TrustManger : " + this.trustManager.getClass().toString());
            }
        }
        SSLContext ctx = SSLContext.getInstance("TLS");
        ctx.init(kmf.getKeyManagers(), trustManagers, null);
        return ctx.getServerSocketFactory();
    }
}

