/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jacorb.notification.util.PropertySetListener;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.PropertyError;
import org.omg.CosNotification.PropertyRange;
import org.omg.CosNotification.QoSError_code;

public abstract class PropertySet {
    protected static final ORB sORB = ORB.init();
    protected static final PropertyError[] PROPERTY_ERROR_ARRAY_TEMPLATE = new PropertyError[0];
    protected static final PropertyRange EMPTY_PROPERTY_RANGE = new PropertyRange(sORB.create_any(), sORB.create_any());
    private Map listeners_ = new HashMap();
    private boolean modified_ = true;
    private Map properties_ = new HashMap();
    private Property[] arrayView_ = null;
    private HashSet ignoredNames_ = new HashSet();

    protected PropertySet() {
    }

    protected PropertySet(Property[] ps) {
        this.properties_ = PropertySet.getUniqueSet(ps);
    }

    protected void addToIgnoredProps(String propertyName) {
        this.ignoredNames_.add(propertyName);
    }

    protected boolean removeFromIgnoredProps(String propertyName) {
        return this.ignoredNames_.remove(propertyName);
    }

    public void addPropertySetListener(String[] props, PropertySetListener listener) {
        for (int x = 0; x < props.length; ++x) {
            this.addPropertySetListener(props[x], listener);
        }
    }

    public void addPropertySetListener(String property, PropertySetListener listener) {
        List<PropertySetListener> _list;
        if (!this.listeners_.containsKey(property)) {
            _list = new ArrayList();
            this.listeners_.put(property, _list);
        } else {
            _list = (List)this.listeners_.get(property);
        }
        _list.add(listener);
    }

    public synchronized Property[] toArray() {
        if (this.arrayView_ == null || this.modified_) {
            Property[] _props = new Property[this.properties_.size()];
            Iterator i = this.properties_.keySet().iterator();
            int x = 0;
            while (i.hasNext()) {
                String _key = (String)i.next();
                _props[x++] = new Property(_key, (Any)this.properties_.get(_key));
            }
            this.arrayView_ = _props;
            this.modified_ = false;
        }
        return this.arrayView_;
    }

    public Map toMap() {
        return Collections.unmodifiableMap(this.properties_);
    }

    public String toString() {
        return this.properties_.toString();
    }

    public boolean containsKey(String propertyName) {
        return this.properties_.containsKey(propertyName);
    }

    public Any get(String propertyName) {
        return (Any)this.properties_.get(propertyName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void set_properties(Property[] props) {
        HashSet _toBeNotified = new HashSet();
        for (int x = 0; x < props.length; ++x) {
            if (this.ignoredNames_.contains(props[x].name)) continue;
            Any _oldValue = null;
            if (this.properties_.containsKey(props[x].name)) {
                _oldValue = (Any)this.properties_.get(props[x].name);
            }
            this.properties_.put(props[x].name, props[x].value);
            if (!this.listeners_.containsKey(props[x].name) || props[x].value.equals(_oldValue)) continue;
            _toBeNotified.addAll((List)this.listeners_.get(props[x].name));
        }
        PropertySet x = this;
        synchronized (x) {
            this.modified_ = true;
        }
        Iterator i = _toBeNotified.iterator();
        while (i.hasNext()) {
            try {
                ((PropertySetListener)i.next()).actionPropertySetChanged(this);
            }
            catch (Exception e) {}
        }
    }

    abstract HashSet getValidNames();

    protected void checkPropertyExistence(Property[] props, List errorList) {
        for (int x = 0; x < props.length; ++x) {
            if (this.getValidNames().contains(props[x].name)) continue;
            errorList.add(this.badProperty(props[x].name));
        }
    }

    protected PropertyError badProperty(String name) {
        return new PropertyError(QoSError_code.BAD_PROPERTY, name, EMPTY_PROPERTY_RANGE);
    }

    protected PropertyError badType(String name) {
        return new PropertyError(QoSError_code.BAD_TYPE, name, EMPTY_PROPERTY_RANGE);
    }

    private static Map getUniqueSet(Property[] p) {
        HashMap<String, Any> _map = new HashMap<String, Any>();
        for (int x = 0; x < p.length; ++x) {
            _map.put(p[x].name, p[x].value);
        }
        return _map;
    }

    public static Property[] map2Props(Map props) {
        Property[] _ps = new Property[props.size()];
        Iterator i = props.keySet().iterator();
        int x = 0;
        while (i.hasNext()) {
            String _key = (String)i.next();
            _ps[x++] = new Property(_key, (Any)props.get(_key));
        }
        return _ps;
    }
}

