/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.util;

import org.jacorb.notification.util.WildcardMap;

public class CachingWildcardMap
extends WildcardMap {
    private Object[] cachedKeys_;
    private Object[] cachedValues_;
    private int cacheSize_;

    public CachingWildcardMap(int cacheSize) {
        this.cachedValues_ = new Object[cacheSize];
        this.cachedKeys_ = new Object[cacheSize];
        this.cacheSize_ = cacheSize;
    }

    private int calcPosition(String key) {
        return key.charAt(0) % this.cacheSize_;
    }

    private void invalidateCache() {
        for (int x = 0; x < this.cacheSize_; ++x) {
            this.cachedKeys_[x] = null;
            this.cachedValues_[x] = null;
        }
    }

    public Object remove(Object key) {
        this.invalidateCache();
        return super.remove(key);
    }

    public Object put(Object key, Object value) {
        this.invalidateCache();
        return super.put(key, value);
    }

    public Object[] getWithExpansion(Object key) {
        Object[] _ret;
        int _pos;
        String _key = key.toString();
        if (_key.equals(this.cachedKeys_[_pos = this.calcPosition(_key)])) {
            _ret = (Object[])this.cachedValues_[_pos];
        } else {
            _ret = super.getWithExpansion(key);
            this.cachedKeys_[_pos] = _key;
            this.cachedValues_[_pos] = _ret;
        }
        return _ret;
    }
}

