/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.HashMap;
import java.util.Map;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.omg.CORBA.Any;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;
import org.omg.CORBA.InterfaceDefPackage.FullInterfaceDescription;
import org.omg.CORBA.NVList;
import org.omg.CORBA.Object;
import org.omg.CORBA.OperationDescription;
import org.omg.CORBA.Request;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventChannelAdmin.TypeError;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosTypedEventComm.TypedPullSupplier;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullConsumerHelper;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullConsumerOperations;
import org.omg.CosTypedNotifyChannelAdmin.TypedProxyPullConsumerPOATie;
import org.omg.PortableServer.Servant;

public class TypedProxyPullConsumerImpl
extends AbstractProxyConsumer
implements TypedProxyPullConsumerOperations,
MessageSupplier {
    private final java.lang.Object[] STRING_ARRAY_TEMPLATE = new String[0];
    private String expectedInterface_;
    private String[] tryPullOperations_;
    private Map operationDescriptions_ = new HashMap();
    private TypedPullSupplier pullSupplier_;
    private Object typedPullSupplier_;
    private InterfaceDef interfaceDef_;
    private Map fullQualifiedOperationNames_ = new HashMap();

    public TypedProxyPullConsumerImpl(String expectedInterface) {
        this.expectedInterface_ = expectedInterface;
    }

    public void connect_typed_pull_supplier(TypedPullSupplier typedPullSupplier) throws AlreadyConnected, TypeError {
        this.logger_.info("connect typed_pull_supplier");
        this.assertNotConnected();
        this.connectClient(typedPullSupplier);
        this.pullSupplier_ = typedPullSupplier;
        this.typedPullSupplier_ = this.pullSupplier_.get_typed_supplier();
        this.interfaceDef_ = InterfaceDefHelper.narrow(this.typedPullSupplier_._get_interface_def());
        if (!this.typedPullSupplier_._is_a(this.expectedInterface_)) {
            throw new TypeError();
        }
    }

    private String[] getTryPullOperations() {
        if (this.tryPullOperations_ == null) {
            FullInterfaceDescription _fullIfDescription = this.interfaceDef_.describe_interface();
            for (int x = 0; x < _fullIfDescription.operations.length; ++x) {
                if (!_fullIfDescription.operations[x].name.startsWith("try_")) continue;
                this.operationDescriptions_.put(_fullIfDescription.operations[x].name, _fullIfDescription.operations[x]);
            }
            this.tryPullOperations_ = (String[])this.operationDescriptions_.keySet().toArray(this.STRING_ARRAY_TEMPLATE);
        }
        return this.tryPullOperations_;
    }

    public void runPullMessage() {
        this.runPullMessageInternal();
    }

    private OperationDescription getOperationDescription(String operation) {
        return (OperationDescription)this.operationDescriptions_.get(operation);
    }

    private String getFullQualifiedName(String operation) {
        String _fullQualifiedName = (String)this.fullQualifiedOperationNames_.get(operation);
        if (_fullQualifiedName == null) {
            _fullQualifiedName = this.interfaceDef_.lookup(operation).absolute_name();
            this.fullQualifiedOperationNames_.put(operation, _fullQualifiedName);
        }
        return _fullQualifiedName;
    }

    private Request prepareRequest(String operation) {
        Request _request = this.typedPullSupplier_._request(operation);
        NVList _args = _request.arguments();
        OperationDescription _operationDescription = this.getOperationDescription(operation);
        for (int x = 0; x < _operationDescription.parameters.length; ++x) {
            Any _any = this.getORB().create_any();
            _any.type(_operationDescription.parameters[x].type);
            _args.add_value(_operationDescription.parameters[x].name, _any, 2);
        }
        _request.set_return_type(_operationDescription.result);
        return _request;
    }

    private void runPullMessageInternal() {
        String[] _tryPullOperations = this.getTryPullOperations();
        for (int x = 0; x < _tryPullOperations.length; ++x) {
            Request _request = this.prepareRequest(_tryPullOperations[x]);
            _request.invoke();
            Any _result = _request.result().value();
            boolean _success = _result.extract_boolean();
            if (!_success) continue;
            OperationDescription _operationDescription = this.getOperationDescription(_tryPullOperations[x]);
            String _operationNameWithoutTry = _tryPullOperations[x].substring(4);
            String _operationName = this.getFullQualifiedName(_operationNameWithoutTry);
            Message _mesg = this.getMessageFactory().newMessage(this.expectedInterface_, _operationName, _request.arguments(), this);
            this.checkMessageProperties(_mesg);
            this.getTaskProcessor().processMessage(_mesg);
        }
    }

    public void disconnect_pull_consumer() {
        this.dispose();
    }

    public ProxyType MyType() {
        return ProxyType.PULL_TYPED;
    }

    public Object activate() {
        return TypedProxyPullConsumerHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    public void disconnectClient() {
        if (this.pullSupplier_ != null) {
            this.pullSupplier_.disconnect_pull_supplier();
            this.pullSupplier_ = null;
        }
    }

    public Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new TypedProxyPullConsumerPOATie(this);
        }
        return this.thisServant_;
    }
}

