/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyChannelAdmin.ProxyConsumerHelper;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerOperations;
import org.omg.CosNotifyChannelAdmin.StructuredProxyPullConsumerPOATie;
import org.omg.CosNotifyComm.StructuredPullSupplier;
import org.omg.PortableServer.Servant;

public class StructuredProxyPullConsumerImpl
extends AbstractProxyConsumer
implements StructuredProxyPullConsumerOperations,
MessageSupplier {
    protected Sync pullSync_ = new Semaphore(1L);
    protected long pollInterval_;
    private StructuredPullSupplier pullSupplier_;
    private java.lang.Object taskId_;
    private Runnable runQueueThis_ = new Runnable(){

        public void run() {
            try {
                StructuredProxyPullConsumerImpl.this.getTaskProcessor().scheduleTimedPullTask(StructuredProxyPullConsumerImpl.this);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };

    public ProxyType MyType() {
        return ProxyType.PULL_STRUCTURED;
    }

    public void configure(Configuration conf) {
        super.configure(conf);
        this.pollInterval_ = conf.getAttributeAsLong("jacorb.notification.supplier.poll_intervall", 1000L);
    }

    public void disconnect_structured_pull_consumer() {
        this.dispose();
    }

    public synchronized void connect_structured_pull_supplier(StructuredPullSupplier pullSupplier) throws AlreadyConnected {
        this.assertNotConnected();
        this.pullSupplier_ = pullSupplier;
        this.connectClient(pullSupplier);
        this.startTask();
    }

    protected void connectionSuspended() {
        this.stopTask();
    }

    public void connectionResumed() {
        this.startTask();
    }

    public void runPullMessage() throws Disconnected {
        if (!this.isConnected() || this.isSuspended()) {
            return;
        }
        try {
            this.runPullEventInternal();
        }
        catch (InterruptedException e) {
            this.logger_.error("pull interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runPullEventInternal() throws InterruptedException, Disconnected {
        BooleanHolder _hasEvent = new BooleanHolder();
        _hasEvent.value = false;
        StructuredEvent _event = null;
        try {
            this.pullSync_.acquire();
            _event = this.pullSupplier_.try_pull_structured_event(_hasEvent);
        }
        finally {
            this.pullSync_.release();
        }
        if (_hasEvent.value) {
            Message _notifyEvent = this.getMessageFactory().newMessage(_event, (AbstractProxyConsumerI)this);
            this.getTaskProcessor().processMessage(_notifyEvent);
        }
    }

    protected void disconnectClient() {
        this.stopTask();
        this.pullSupplier_.disconnect_structured_pull_supplier();
        this.pullSupplier_ = null;
    }

    protected void startTask() {
        if (this.taskId_ == null) {
            this.taskId_ = this.getTaskProcessor().executeTaskPeriodically(this.pollInterval_, this.runQueueThis_, true);
        }
    }

    protected void stopTask() {
        if (this.taskId_ != null) {
            this.getTaskProcessor().cancelTask(this.taskId_);
            this.taskId_ = null;
        }
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new StructuredProxyPullConsumerPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxyConsumerHelper.narrow(this.getServant()._this_object(this.getORB()));
    }
}

