/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import EDU.oswego.cs.dl.util.concurrent.Semaphore;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.interfaces.MessageSupplier;
import org.jacorb.notification.servant.AbstractProxyConsumer;
import org.jacorb.notification.servant.AbstractProxyConsumerI;
import org.omg.CORBA.Any;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.Object;
import org.omg.CosEventChannelAdmin.AlreadyConnected;
import org.omg.CosEventComm.Disconnected;
import org.omg.CosEventComm.PullSupplier;
import org.omg.CosNotifyChannelAdmin.ProxyConsumerHelper;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerOperations;
import org.omg.CosNotifyChannelAdmin.ProxyPullConsumerPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyType;
import org.omg.PortableServer.Servant;

public class ProxyPullConsumerImpl
extends AbstractProxyConsumer
implements ProxyPullConsumerOperations,
MessageSupplier {
    private Sync pullSync_ = new Semaphore(1L);
    private PullSupplier pullSupplier_;
    private long pollInterval_;
    private java.lang.Object timerRegistration_;
    private Runnable runQueueThis_;
    private int pullCounter_;
    private long timeSpentInPull_;
    private int successfulPullCounter_;

    public ProxyPullConsumerImpl() {
        this.configureTimerCallback();
    }

    public ProxyType MyType() {
        return ProxyType.PULL_ANY;
    }

    public void configure(Configuration conf) {
        super.configure(conf);
        this.pollInterval_ = conf.getAttributeAsLong("jacorb.notification.supplier.poll_intervall", 1000L);
    }

    private void configureTimerCallback() {
        this.runQueueThis_ = new Runnable(){

            public void run() {
                ProxyPullConsumerImpl.this.schedulePullTask(ProxyPullConsumerImpl.this);
            }
        };
    }

    public void disconnect_pull_consumer() {
        this.dispose();
    }

    protected void disconnectClient() {
        this.stopTask();
        this.pullSupplier_.disconnect_pull_supplier();
        this.pullSupplier_ = null;
    }

    protected void connectionSuspended() {
        this.stopTask();
    }

    protected void connectionResumed() {
        this.startTask();
    }

    public void runPullMessage() throws Disconnected {
        if (!this.isConnected()) {
            return;
        }
        try {
            this.runPullEventInternal();
        }
        catch (InterruptedException e) {
            this.logger_.error("pull was interrupted", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runPullEventInternal() throws InterruptedException, Disconnected {
        BooleanHolder hasEvent = new BooleanHolder();
        Any event = null;
        try {
            this.pullSync_.acquire();
            ++this.pullCounter_;
            long _start = System.currentTimeMillis();
            event = this.pullSupplier_.try_pull(hasEvent);
            this.timeSpentInPull_ += System.currentTimeMillis() - _start;
        }
        finally {
            this.pullSync_.release();
        }
        if (hasEvent.value) {
            ++this.successfulPullCounter_;
            Message _message = this.getMessageFactory().newMessage(event, (AbstractProxyConsumerI)this);
            this.checkMessageProperties(_message);
            this.getTaskProcessor().processMessage(_message);
        }
    }

    public void connect_any_pull_supplier(PullSupplier pullSupplier) throws AlreadyConnected {
        this.assertNotConnected();
        this.pullSupplier_ = pullSupplier;
        this.connectClient(pullSupplier);
        this.startTask();
    }

    private synchronized void startTask() {
        if (this.timerRegistration_ == null) {
            this.timerRegistration_ = this.getTaskProcessor().executeTaskPeriodically(this.pollInterval_, this.runQueueThis_, true);
        }
    }

    private synchronized void stopTask() {
        if (this.timerRegistration_ != null) {
            this.getTaskProcessor().cancelTask(this.timerRegistration_);
            this.timerRegistration_ = null;
        }
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new ProxyPullConsumerPOATie(this);
        }
        return this.thisServant_;
    }

    public Object activate() {
        return ProxyConsumerHelper.narrow(this.getServant()._this_object(this.getORB()));
    }

    public long getPollInterval() {
        return this.pollInterval_;
    }

    public long getPullTimer() {
        return this.timeSpentInPull_;
    }

    public int getPullCounter() {
        return this.pullCounter_;
    }

    public int getSuccessfulPullCounter() {
        return this.successfulPullCounter_;
    }
}

