/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.servant;

import java.util.Iterator;
import java.util.List;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.engine.TaskProcessorDependency;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractProxy;
import org.jacorb.notification.servant.AbstractProxySupplier;
import org.jacorb.notification.servant.ECProxyPullSupplierImpl;
import org.jacorb.notification.servant.ECProxyPushSupplierImpl;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.servant.ProxyPullSupplierImpl;
import org.jacorb.notification.servant.ProxyPushSupplierImpl;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.Object;
import org.omg.CORBA.UNKNOWN;
import org.omg.CosEventChannelAdmin.ProxyPullSupplier;
import org.omg.CosEventChannelAdmin.ProxyPullSupplierHelper;
import org.omg.CosEventChannelAdmin.ProxyPushSupplier;
import org.omg.CosEventChannelAdmin.ProxyPushSupplierHelper;
import org.omg.CosNotification.EventType;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.ClientType;
import org.omg.CosNotifyChannelAdmin.ConsumerAdmin;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminHelper;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminOperations;
import org.omg.CosNotifyChannelAdmin.ConsumerAdminPOATie;
import org.omg.CosNotifyChannelAdmin.ProxyNotFound;
import org.omg.CosNotifyChannelAdmin.ProxySupplier;
import org.omg.CosNotifyChannelAdmin.ProxySupplierHelper;
import org.omg.CosNotifyComm.InvalidEventType;
import org.omg.CosNotifyFilter.MappingFilter;
import org.omg.CosNotifyFilter.MappingFilterHelper;
import org.omg.PortableServer.Servant;

public class ConsumerAdminImpl
extends AbstractAdmin
implements ConsumerAdminOperations,
Disposable,
ProxyEventListener,
TaskProcessorDependency {
    private ConsumerAdmin thisRef_;
    protected Servant thisServant_;
    private FilterStageListManager listManager_ = new FilterStageListManager(){

        public void fetchListData(FilterStageListManager.List listProxy) {
            Iterator i = ConsumerAdminImpl.this.pullServants_.entrySet().iterator();
            while (i.hasNext()) {
                listProxy.add((FilterStage)i.next().getValue());
            }
            i = ConsumerAdminImpl.this.pushServants_.entrySet().iterator();
            while (i.hasNext()) {
                listProxy.add((FilterStage)i.next().getValue());
            }
        }
    };
    private MappingFilter priorityFilter_;
    private MappingFilter lifetimeFilter_;
    private TaskProcessor taskProcessor_;

    public ConsumerAdminImpl() {
        this.addProxyEventListener(this);
    }

    public void setTaskProcessor(TaskProcessor taskProcessor) {
        this.taskProcessor_ = taskProcessor;
    }

    public TaskProcessor getTaskProcessor() {
        return this.taskProcessor_;
    }

    public synchronized Servant getServant() {
        if (this.thisServant_ == null) {
            this.thisServant_ = new ConsumerAdminPOATie(this);
        }
        return this.thisServant_;
    }

    public void preActivate() {
        this.lifetimeFilter_ = MappingFilterHelper.unchecked_narrow(this.getORB().string_to_object(this.getORB().object_to_string(null)));
        this.priorityFilter_ = MappingFilterHelper.unchecked_narrow(this.getORB().string_to_object(this.getORB().object_to_string(null)));
    }

    public Object activate() {
        if (this.thisRef_ == null) {
            this.thisRef_ = ConsumerAdminHelper.narrow(this.getServant()._this_object(this.getORB()));
        }
        return this.thisRef_;
    }

    public void subscription_change(EventType[] added, EventType[] removed) throws InvalidEventType {
        this.subscriptionManager_.subscription_change(added, removed);
    }

    public ProxySupplier get_proxy_supplier(int key) throws ProxyNotFound {
        return ProxySupplierHelper.narrow(this.getProxy(key).activate());
    }

    public void lifetime_filter(MappingFilter lifetimeFilter) {
        this.lifetimeFilter_ = lifetimeFilter;
    }

    public MappingFilter lifetime_filter() {
        return this.lifetimeFilter_;
    }

    public MappingFilter priority_filter() {
        return this.priorityFilter_;
    }

    public void priority_filter(MappingFilter priorityFilter) {
        this.priorityFilter_ = priorityFilter;
    }

    public ProxySupplier obtain_notification_pull_supplier(ClientType clientType, IntHolder intHolder) throws AdminLimitExceeded {
        this.fireCreateProxyRequestEvent();
        try {
            AbstractProxy _servant = this.obtain_notification_pull_supplier_servant(clientType);
            intHolder.value = _servant.getID();
            _servant.preActivate();
            return ProxySupplierHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.fatalError("obtain_notification_pull_supplier: unexpected error", (Throwable)e);
            throw new UNKNOWN();
        }
    }

    protected void configureMappingFilters(AbstractProxySupplier servant) {
        if (this.lifetimeFilter_ != null) {
            servant.lifetime_filter(this.lifetimeFilter_);
        }
        if (this.priorityFilter_ != null) {
            servant.priority_filter(this.priorityFilter_);
        }
    }

    private AbstractProxy obtain_notification_pull_supplier_servant(ClientType clientType) throws UnsupportedQoS {
        AbstractProxySupplier _servant = AbstractProxySupplier.newProxyPullSupplier(this, clientType);
        this.configureManagers(_servant);
        this.configureNotifyStyleID(_servant);
        this.configureMappingFilters(_servant);
        _servant.setTaskExecutor(TaskExecutor.getDefaultExecutor());
        this.configureQoS(_servant);
        this.configureInterFilterGroupOperator(_servant);
        this.addProxyToMap(_servant, this.pullServants_, this.modifyProxiesLock_);
        return _servant;
    }

    public int[] pull_suppliers() {
        return this.get_all_notify_proxies(this.pullServants_, this.modifyProxiesLock_);
    }

    public int[] push_suppliers() {
        return this.get_all_notify_proxies(this.pushServants_, this.modifyProxiesLock_);
    }

    public ProxySupplier obtain_notification_push_supplier(ClientType clientType, IntHolder intHolder) throws AdminLimitExceeded {
        this.fireCreateProxyRequestEvent();
        try {
            AbstractProxy _servant = this.obtain_notification_push_supplier_servant(clientType);
            intHolder.value = _servant.getID();
            _servant.preActivate();
            return ProxySupplierHelper.narrow(_servant.activate());
        }
        catch (Exception e) {
            this.logger_.fatalError("obtain_notification_push_supplier: unexpected error", (Throwable)e);
            throw new UNKNOWN();
        }
    }

    private AbstractProxy obtain_notification_push_supplier_servant(ClientType clientType) throws UnsupportedQoS {
        AbstractProxySupplier _servant = AbstractProxySupplier.newProxyPushSupplier(this, clientType);
        this.configureNotifyStyleID(_servant);
        this.configureManagers(_servant);
        this.configureMappingFilters(_servant);
        this.configureQoS(_servant);
        this.getTaskProcessor().configureTaskExecutor(_servant);
        this.configureInterFilterGroupOperator(_servant);
        this.addProxyToMap(_servant, this.pushServants_, this.modifyProxiesLock_);
        return _servant;
    }

    public ProxyPullSupplier obtain_pull_supplier() {
        try {
            ECProxyPullSupplierImpl _servant = new ECProxyPullSupplierImpl();
            this.configureEventStyleID(_servant);
            this.configureQoS(_servant);
            this.addProxyToMap(_servant, this.pullServants_, this.modifyProxiesLock_);
            _servant.setTaskExecutor(TaskExecutor.getDefaultExecutor());
            _servant.preActivate();
            return ProxyPullSupplierHelper.narrow(((ProxyPullSupplierImpl)_servant).activate());
        }
        catch (Exception e) {
            this.logger_.fatalError("obtain_pull_supplier: exception", (Throwable)e);
            throw new UNKNOWN();
        }
    }

    public ProxyPushSupplier obtain_push_supplier() {
        try {
            ECProxyPushSupplierImpl _servant = new ECProxyPushSupplierImpl();
            this.configureEventStyleID(_servant);
            this.configureQoS(_servant);
            this.getTaskProcessor().configureTaskExecutor(_servant);
            this.addProxyToMap(_servant, this.pushServants_, this.modifyProxiesLock_);
            _servant.preActivate();
            return ProxyPushSupplierHelper.narrow(((ProxyPushSupplierImpl)_servant).activate());
        }
        catch (Exception e) {
            this.logger_.fatalError("obtain_push_supplier: exception", (Throwable)e);
            throw new UNKNOWN();
        }
    }

    public List getSubsequentFilterStages() {
        return this.listManager_.getList();
    }

    public MessageConsumer getMessageConsumer() {
        return null;
    }

    public boolean hasMessageConsumer() {
        return false;
    }

    public void actionProxyCreationRequest(ProxyEvent event) {
    }

    public void actionProxyDisposed(ProxyEvent event) {
        this.listManager_.actionSourceModified();
    }

    public void actionProxyCreated(ProxyEvent event) {
        this.listManager_.actionSourceModified();
    }
}

