/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.collections.AST;
import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.ETCLComponentName;
import org.jacorb.notification.filter.etcl.NumberValue;
import org.jacorb.notification.filter.etcl.TCLParserTokenTypes;
import org.jacorb.notification.filter.etcl.UnionPositionOperator;
import org.jacorb.notification.filter.etcl.VisitorException;

public class TCLCleanUp
extends AbstractTCLVisitor
implements TCLParserTokenTypes {
    public void fix(AbstractTCLNode node) {
        try {
            node.acceptPostOrder(this);
        }
        catch (VisitorException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void visitComponent(ETCLComponentName component) throws VisitorException {
        this.insertComponentName(component);
    }

    public void visitUnionPosition(UnionPositionOperator op) throws VisitorException {
        this.fixUnionPosition(op);
    }

    void insertComponentName(ETCLComponentName comp) {
        StringBuffer _name = new StringBuffer(comp.toString());
        for (AbstractTCLNode _cursor = comp.left(); _cursor != null; _cursor = (AbstractTCLNode)_cursor.getNextSibling()) {
            _name.append(_cursor.toString());
        }
        comp.setComponentName(_name.toString());
    }

    void fixUnionPosition(UnionPositionOperator node) {
        AST _nextSibling = node.getNextSibling();
        if (_nextSibling == null) {
            node.setDefault();
        } else {
            switch (_nextSibling.getType()) {
                case 21: {
                    Double _position = ((NumberValue)_nextSibling).getNumber();
                    node.setPosition(_position);
                    node.setNextSibling(_nextSibling.getNextSibling());
                }
                case 12: 
                case 15: 
                case 16: {
                    break;
                }
                default: {
                    node.setDefault();
                }
            }
        }
    }
}

