/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.BinaryOperator;
import org.jacorb.notification.filter.etcl.VisitorException;

public class SubstrOperator
extends BinaryOperator {
    static final String NAME = "SubstrOperator";

    public String getName() {
        return NAME;
    }

    public SubstrOperator(Token tok) {
        super(tok);
    }

    public String toString() {
        return " ~";
    }

    public EvaluationResult evaluate(EvaluationContext context, EvaluationResult left, EvaluationResult right) throws EvaluationException {
        String _l = left.getString();
        String _r = right.getString();
        int _idx = _r.indexOf(_l);
        EvaluationResult _res = _idx == -1 ? EvaluationResult.BOOL_FALSE : EvaluationResult.BOOL_TRUE;
        return _res;
    }

    public boolean isStatic() {
        return this.left().isStatic() && this.right().isStatic();
    }

    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptInOrder(visitor);
        visitor.visitSubstr(this);
        this.right().acceptInOrder(visitor);
    }

    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptPostOrder(visitor);
        this.right().acceptPostOrder(visitor);
        visitor.visitSubstr(this);
    }

    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitSubstr(this);
        this.left().acceptPreOrder(visitor);
        this.right().acceptPreOrder(visitor);
    }
}

