/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import org.jacorb.notification.filter.etcl.AbstractTCLNode;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.AndOperator;
import org.jacorb.notification.filter.etcl.DivOperator;
import org.jacorb.notification.filter.etcl.GtOperator;
import org.jacorb.notification.filter.etcl.MinusOperator;
import org.jacorb.notification.filter.etcl.MultOperator;
import org.jacorb.notification.filter.etcl.PlusOperator;
import org.jacorb.notification.filter.etcl.StaticTypeException;
import org.jacorb.notification.filter.etcl.SubstrOperator;
import org.jacorb.notification.filter.etcl.TCLParserTokenTypes;
import org.jacorb.notification.filter.etcl.VisitorException;

public class StaticTypeChecker
extends AbstractTCLVisitor
implements TCLParserTokenTypes {
    public void check(AbstractTCLNode rootNode) throws StaticTypeException {
        try {
            rootNode.acceptPostOrder(this);
        }
        catch (VisitorException e) {
            throw new StaticTypeException(e.getMessage());
        }
    }

    static void checkBinaryNumaryOperatorNode(AbstractTCLNode node) throws StaticTypeException {
        if (node.isStatic()) {
            if (node.left().isNumber() && node.right().isNumber()) {
                return;
            }
            throw new StaticTypeException("num or float or identifier (or bool) excepted)");
        }
    }

    static void checkCMPNode(AbstractTCLNode node) throws StaticTypeException {
    }

    public void visitGt(GtOperator n) throws VisitorException {
        StaticTypeChecker.checkCMPNode(n);
    }

    public void visitPlus(PlusOperator n) throws VisitorException {
        StaticTypeChecker.checkBinaryNumaryOperatorNode(n);
    }

    public void visitMinus(MinusOperator node) throws VisitorException {
        StaticTypeChecker.checkBinaryNumaryOperatorNode(node);
    }

    public void visitDiv(DivOperator node) throws VisitorException {
        StaticTypeChecker.checkBinaryNumaryOperatorNode(node);
    }

    public void visitMult(MultOperator node) throws VisitorException {
        StaticTypeChecker.checkBinaryNumaryOperatorNode(node);
    }

    public void visitSubstr(SubstrOperator node) throws VisitorException {
        if (node.isStatic()) {
            if (node.left().isString() && node.right().isString()) {
                return;
            }
            throw new StaticTypeException("~ Operator expects 2 Strings");
        }
    }

    public void visitAnd(AndOperator and) throws VisitorException {
        if (and.isStatic()) {
            if (and.left().isBoolean() && and.right().isBoolean()) {
                return;
            }
            throw new StaticTypeException("bool value expected");
        }
    }
}

