/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.UnaryOperator;
import org.jacorb.notification.filter.etcl.VisitorException;
import org.omg.CORBA.TCKind;

public class OrOperator
extends UnaryOperator {
    private static final String NAME = "OrOperator";
    private static final String OR = "or";

    public OrOperator(Token tok) {
        super(tok);
        this.setKind(TCKind.tk_boolean);
    }

    public String toString() {
        return OR;
    }

    public EvaluationResult evaluate(EvaluationContext context, EvaluationResult left) throws EvaluationException {
        if (left.getBool()) {
            return EvaluationResult.BOOL_TRUE;
        }
        if (this.right().evaluate(context).getBool()) {
            return EvaluationResult.BOOL_TRUE;
        }
        return EvaluationResult.BOOL_FALSE;
    }

    public String getName() {
        return NAME;
    }

    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptInOrder(visitor);
        visitor.visitOr(this);
        this.right().acceptInOrder(visitor);
    }

    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitOr(this);
        this.left().acceptPreOrder(visitor);
        this.right().acceptPreOrder(visitor);
    }

    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptPostOrder(visitor);
        this.right().acceptPostOrder(visitor);
        visitor.visitOr(this);
    }
}

