/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter.etcl;

import antlr.Token;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.jacorb.notification.filter.etcl.AbstractTCLVisitor;
import org.jacorb.notification.filter.etcl.BinaryOperator;
import org.jacorb.notification.filter.etcl.VisitorException;

public class LtOperator
extends BinaryOperator {
    public LtOperator(Token tok) {
        super(tok);
    }

    public EvaluationResult evaluate(EvaluationContext context, EvaluationResult left, EvaluationResult right) throws EvaluationException {
        int _comp = left.compareTo(right);
        if (_comp == 1 || _comp == 0) {
            return EvaluationResult.BOOL_FALSE;
        }
        return EvaluationResult.BOOL_TRUE;
    }

    public String toString() {
        return "<";
    }

    public String getName() {
        return this.getClass().getName();
    }

    public void acceptInOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptInOrder(visitor);
        visitor.visitLt(this);
        this.right().acceptInOrder(visitor);
    }

    public void acceptPreOrder(AbstractTCLVisitor visitor) throws VisitorException {
        visitor.visitLt(this);
        this.left().acceptPreOrder(visitor);
        this.right().acceptPreOrder(visitor);
    }

    public void acceptPostOrder(AbstractTCLVisitor visitor) throws VisitorException {
        this.left().acceptPostOrder(visitor);
        this.right().acceptPostOrder(visitor);
        visitor.visitLt(this);
    }
}

