/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.filter;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.EvaluationResult;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CosNotification.Property;
import org.omg.DynamicAny.DynAny;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryPackage.InconsistentTypeCode;
import org.omg.DynamicAny.DynAnyPackage.InvalidValue;
import org.omg.DynamicAny.DynAnyPackage.TypeMismatch;
import org.omg.DynamicAny.DynSequence;
import org.omg.DynamicAny.DynSequenceHelper;
import org.omg.DynamicAny.DynStruct;
import org.omg.DynamicAny.DynStructHelper;
import org.omg.DynamicAny.DynUnion;
import org.omg.DynamicAny.DynUnionHelper;

public class DynamicEvaluator
implements Configurable {
    private static final String NAME = "name";
    private static final String VALUE = "value";
    private Logger logger_ = null;
    private DynAnyFactory dynAnyFactory_;
    private static final ORB orb_ = ORB.init();
    private static final Any TRUE_ANY = orb_.create_any();
    private static final Any FALSE_ANY = orb_.create_any();

    public DynamicEvaluator(DynAnyFactory dynAnyFactory) {
        this.dynAnyFactory_ = dynAnyFactory;
    }

    public void configure(Configuration conf) {
        this.logger_ = ((org.jacorb.config.Configuration)conf).getNamedLogger(this.getClass().getName());
    }

    public boolean hasDefaultDiscriminator(Any any) throws EvaluationException {
        try {
            return any.type().default_index() != -1;
        }
        catch (BadKind e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    public Any evaluateExistIdentifier(Any value, String identifier) throws EvaluationException {
        try {
            this.evaluateIdentifier(value, identifier);
            return TRUE_ANY;
        }
        catch (EvaluationException e) {
            return FALSE_ANY;
        }
    }

    public Any evaluateTypeName(Any value) throws EvaluationException {
        try {
            TypeCode _tc = value.type();
            Any _ret = orb_.create_any();
            _ret.insert_string(_tc.name());
            return _ret;
        }
        catch (BadKind e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    public Any evaluateRepositoryId(Any value) throws EvaluationException {
        try {
            TypeCode _tc = value.type();
            Any _ret = orb_.create_any();
            _ret.insert_string(_tc.id());
            return _ret;
        }
        catch (BadKind e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Any evaluateListLength(Any value) throws EvaluationException {
        void var2_3;
        switch (value.type().kind().value()) {
            case 20: {
                DynAny _dynAny = this.toDynAny(value);
                int _length = _dynAny.component_count();
                break;
            }
            case 19: {
                DynSequence _dynSequence = this.toDynSequence(value);
                int _length = _dynSequence.get_length();
                break;
            }
            default: {
                throw new EvaluationException("Neither array nor sequence");
            }
        }
        Any _any = orb_.create_any();
        _any.insert_long((int)var2_3);
        return _any;
    }

    String getDefaultUnionMemberName(TypeCode unionTypeCode) throws EvaluationException {
        try {
            int _defaultIndex = unionTypeCode.default_index();
            if (_defaultIndex != -1) {
                return unionTypeCode.member_name(_defaultIndex);
            }
        }
        catch (BadKind e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
        catch (Bounds e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
        throw new EvaluationException();
    }

    String getUnionMemberNameFromDiscriminator(TypeCode unionTypeCode, int discriminator) throws EvaluationException {
        try {
            Any _any = orb_.create_any();
            switch (unionTypeCode.discriminator_type().kind().value()) {
                case 3: {
                    _any.insert_long(discriminator);
                    break;
                }
                case 5: {
                    _any.insert_ulong(discriminator);
                    break;
                }
                case 2: {
                    _any.insert_short((short)discriminator);
                    break;
                }
                case 7: {
                    _any.insert_double(discriminator);
                    break;
                }
                case 4: {
                    _any.insert_ushort((short)discriminator);
                }
            }
            int _memberCount = unionTypeCode.member_count();
            Object _discrimName = null;
            try {
                for (int _x = 0; _x < _memberCount; ++_x) {
                    if (!_any.equal(unionTypeCode.member_label(_x))) continue;
                    return unionTypeCode.member_name(_x);
                }
            }
            catch (Bounds b) {
            }
        }
        catch (BadKind e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
        throw new EvaluationException();
    }

    public Any evaluateUnion(Any value) throws EvaluationException {
        String _defaultMemberName = this.getDefaultUnionMemberName(value.type());
        return this.evaluateIdentifier(value, _defaultMemberName);
    }

    public Any evaluateUnion(Any value, int position) throws EvaluationException {
        Any _ret = null;
        DynUnion _dynUnion = this.toDynUnion(value);
        _dynUnion.seek(0);
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("extract idx: " + position + " from Union " + _dynUnion.type());
        }
        String _discrimName = this.getUnionMemberNameFromDiscriminator(value.type(), position);
        _ret = this.evaluateIdentifier((DynAny)_dynUnion, _discrimName);
        return _ret;
    }

    public Any evaluatePropertyList(Property[] list, String name) {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluatePropertyList " + list);
            this.logger_.debug("list length: " + list.length);
        }
        for (int x = 0; x < list.length; ++x) {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug(x + ": " + list[x].name + " => " + list[x].value);
            }
            if (!name.equals(list[x].name)) continue;
            return list[x].value;
        }
        return null;
    }

    public Any evaluateNamedValueList(Any any, String name) throws EvaluationException {
        try {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluateNamedValueList(" + any + ", " + name + ")");
            }
            Any _ret = null;
            DynAny _dynAny = this.toDynAny(any);
            int _count = _dynAny.component_count();
            _dynAny.rewind();
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("Entries: " + _count);
            }
            for (int _x = 0; _x < _count; ++_x) {
                _dynAny.seek(_x);
                DynAny _cursor = _dynAny.current_component();
                _ret = this.evaluateNamedValue(_cursor, name);
                if (_ret != null) break;
            }
            return _ret;
        }
        catch (TypeMismatch e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    protected Any evaluateNamedValue(DynAny any, String name) throws EvaluationException {
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluate assoc " + name + " on a Any of type: " + any.type());
        }
        Any _ret = null;
        String _anyName = this.evaluateIdentifier(any, NAME).extract_string();
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("test if " + name + " == " + _anyName);
        }
        if (name.equals(_anyName)) {
            this.logger_.debug("YES");
            _ret = this.evaluateIdentifier(any, VALUE);
        }
        return _ret;
    }

    public Any evaluateArrayIndex(Any any, int index) throws EvaluationException {
        try {
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluate array idx " + index + " on a Any of type: " + any.type());
            }
            Object _ret = null;
            DynAny _dynAny = this.toDynAny(any);
            _dynAny.rewind();
            _dynAny.seek(index);
            DynAny _cursor = _dynAny.current_component();
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluation result is of type: " + _cursor.type());
            }
            return _cursor.to_any();
        }
        catch (TypeMismatch e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    Any evaluateIdentifier(DynAny any, int position) throws EvaluationException {
        try {
            DynAny _cursor;
            Object _ret = null;
            switch (any.type().kind().value()) {
                case 15: {
                    any.seek(position);
                    _cursor = any.current_component();
                    break;
                }
                default: {
                    throw new EvaluationException("attempt to access member on non-struct");
                }
            }
            return _cursor.to_any();
        }
        catch (TypeMismatch e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    public Any evaluateIdentifier(Any any, int position) throws EvaluationException {
        Object _ret = null;
        if (this.logger_.isDebugEnabled()) {
            this.logger_.debug("evaluate idx " + position + " on Any");
        }
        DynAny _dynAny = this.toDynAny(any);
        return this.evaluateIdentifier(_dynAny, position);
    }

    public Any evaluateDiscriminator(Any any) throws EvaluationException {
        switch (any.type().kind().value()) {
            case 16: {
                DynUnion _dynUnion = this.toDynUnion(any);
                return _dynUnion.get_discriminator().to_any();
            }
        }
        throw new EvaluationException("any does not contain member _d");
    }

    public EvaluationResult evaluateElementInSequence(EvaluationContext context, EvaluationResult element, Any sequence) throws EvaluationException {
        try {
            DynSequence _dynSequence = DynSequenceHelper.narrow(this.toDynAny(sequence));
            _dynSequence.rewind();
            do {
                DynAny _currentComponent;
                EvaluationResult _r;
                if (element.compareTo(_r = EvaluationResult.fromAny((_currentComponent = _dynSequence.current_component()).to_any())) != 0) continue;
                return EvaluationResult.BOOL_TRUE;
            } while (_dynSequence.next());
            return EvaluationResult.BOOL_FALSE;
        }
        catch (TypeMismatch e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    public Any evaluateIdentifier(Any any, String identifier) throws EvaluationException {
        DynAny _dynAny = this.toDynAny(any);
        return this.evaluateIdentifier(_dynAny, identifier);
    }

    Any evaluateIdentifier(DynAny any, String identifier) throws EvaluationException {
        try {
            Any _ret = null;
            String _strippedIdentifier = DynamicEvaluator.stripBackslash(identifier);
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluate " + _strippedIdentifier + " on Any");
            }
            DynAny _cursor = any;
            block1 : switch (any.type().kind().value()) {
                case 15: {
                    boolean _hasNext;
                    this.logger_.debug("Any is a struct");
                    DynStruct _dynStruct = DynStructHelper.narrow(any);
                    _dynStruct.rewind();
                    do {
                        String _currentName = _dynStruct.current_member_name();
                        if (this.logger_.isDebugEnabled()) {
                            this.logger_.debug(" => " + _currentName);
                        }
                        if (!_currentName.equals(_strippedIdentifier)) continue;
                        _cursor = _dynStruct.current_component();
                        break block1;
                    } while (_hasNext = _dynStruct.next());
                    throw new EvaluationException("struct has no member " + _strippedIdentifier);
                }
                case 16: {
                    DynUnion _dynUnion;
                    if (this.logger_.isDebugEnabled()) {
                        this.logger_.debug("Any is a Union");
                    }
                    if ((_dynUnion = this.toDynUnion(any)).member_name().equals(_strippedIdentifier)) {
                        _cursor = _dynUnion.member();
                        break;
                    }
                    if (this.logger_.isDebugEnabled()) {
                        this.logger_.debug(_dynUnion.member_name() + " != " + _strippedIdentifier);
                    }
                    throw new EvaluationException("member " + _strippedIdentifier + " is not active on struct");
                }
                case 11: {
                    this.logger_.debug("encapsulated any");
                    return this.evaluateIdentifier(any.get_any(), _strippedIdentifier);
                }
                default: {
                    this.logger_.debug("unknown " + any.type());
                    return null;
                }
            }
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("Result: " + _cursor);
            }
            if (_cursor != null && this.logger_.isDebugEnabled()) {
                this.logger_.debug("evaluation result is of type: " + _cursor.type());
            }
            if (_cursor == null) {
                this.logger_.debug("Member not found");
                throw new EvaluationException("member not found");
            }
            _ret = _cursor.to_any();
            return _ret;
        }
        catch (InvalidValue e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
        catch (TypeMismatch e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    DynAny toDynAny(Any any) throws EvaluationException {
        try {
            return this.dynAnyFactory_.create_dyn_any(any);
        }
        catch (InconsistentTypeCode e) {
            throw DynamicEvaluator.getEvaluationException(e);
        }
    }

    DynUnion toDynUnion(Any any) throws EvaluationException {
        return DynUnionHelper.narrow(this.toDynAny(any));
    }

    DynUnion toDynUnion(DynAny dynAny) {
        return DynUnionHelper.narrow(dynAny);
    }

    DynStruct toDynStruct(DynAny dynAny) throws EvaluationException {
        return DynStructHelper.narrow(dynAny);
    }

    DynStruct toDynStruct(Any any) throws EvaluationException {
        return DynStructHelper.narrow(this.toDynAny(any));
    }

    DynSequence toDynSequence(Any any) throws EvaluationException {
        return DynSequenceHelper.narrow(this.toDynAny(any));
    }

    static String stripBackslash(String identifier) {
        StringBuffer _buffer = new StringBuffer();
        int _length = identifier.length();
        for (int _x = 0; _x < _length; ++_x) {
            if (identifier.charAt(_x) == '\\') continue;
            _buffer.append(identifier.charAt(_x));
        }
        return _buffer.toString();
    }

    static EvaluationException getEvaluationException(Exception e) {
        return new EvaluationException(e.getMessage());
    }

    static {
        TRUE_ANY.insert_boolean(true);
        FALSE_ANY.insert_boolean(false);
    }
}

