/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.engine.RetryStrategy;
import org.jacorb.notification.interfaces.MessageConsumer;

public class WaitRetryStrategy
extends RetryStrategy {
    public static final long WAIT_TIME_DEFAULT = 1000L;
    public static final long WAIT_INCREMENT_DEFAULT = 3000L;
    private long currentTimeToWait_;
    private long waitTimeIncrement_;

    public WaitRetryStrategy(MessageConsumer messageConsumer, PushOperation pushOperation) {
        this(messageConsumer, pushOperation, 1000L, 3000L);
    }

    public WaitRetryStrategy(MessageConsumer messageConsumer, PushOperation pushOperation, long startingWaitTime, long waitTimeIncrement) {
        super(messageConsumer, pushOperation);
        this.currentTimeToWait_ = startingWaitTime;
        this.waitTimeIncrement_ = waitTimeIncrement;
    }

    protected long getTimeToWait() {
        long _timeToWait = this.currentTimeToWait_;
        this.currentTimeToWait_ += this.waitTimeIncrement_;
        return _timeToWait;
    }

    protected void retryInternal() throws RetryException {
        while (this.isRetryAllowed()) {
            try {
                this.pushOperation_.invokePush();
                return;
            }
            catch (Throwable error) {
                this.remoteExceptionOccured(error);
            }
        }
    }
}

