/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import org.jacorb.notification.engine.PushOperation;
import org.jacorb.notification.engine.RetryException;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.MessageConsumer;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CosEventComm.Disconnected;

public abstract class RetryStrategy
implements Disposable {
    protected final PushOperation pushOperation_;
    protected final MessageConsumer messageConsumer_;

    public RetryStrategy(MessageConsumer mc, PushOperation operation) {
        this.messageConsumer_ = mc;
        this.pushOperation_ = operation;
    }

    public void dispose() {
        this.pushOperation_.dispose();
    }

    protected boolean isRetryAllowed() {
        return this.messageConsumer_.isRetryAllowed();
    }

    protected void remoteExceptionOccured(Throwable error) throws RetryException {
        if (RetryStrategy.isFatalException(error)) {
            this.messageConsumer_.dispose();
            this.dispose();
            throw new RetryException("fatal exception while retrying push");
        }
        this.messageConsumer_.incErrorCounter();
        if (!this.isRetryAllowed()) {
            this.messageConsumer_.dispose();
            this.dispose();
            throw new RetryException("no more retries. giving up.");
        }
        this.waitUntilNextTry();
    }

    public static boolean isFatalException(Throwable error) {
        if (error instanceof OBJECT_NOT_EXIST) {
            return true;
        }
        return error instanceof Disconnected;
    }

    protected abstract long getTimeToWait();

    public final void retry() throws RetryException {
        if (this.isRetryAllowed()) {
            this.waitUntilNextTry();
            this.retryInternal();
        }
    }

    protected abstract void retryInternal() throws RetryException;

    private void waitUntilNextTry() {
        long timeToWait = this.getTimeToWait();
        try {
            Thread.sleep(timeToWait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

