/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification.engine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jacorb.notification.engine.AbstractDeliverTask;
import org.jacorb.notification.engine.AbstractFilterTask;
import org.jacorb.notification.engine.TaskExecutor;
import org.jacorb.notification.engine.TaskFactory;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.Message;
import org.omg.CORBA.AnyHolder;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class FilterProxySupplierTask
extends AbstractFilterTask {
    public static final AlternateMessageMap EMPTY_MAP = new AlternateMessageMap(Collections.EMPTY_MAP){

        public void clear() {
        }
    };
    AlternateMessageMap changedMessages_ = new AlternateMessageMap();
    private static int sCount = 0;
    private int id_ = ++sCount;

    FilterProxySupplierTask(TaskExecutor te, TaskProcessor tp, TaskFactory tc) {
        super(te, tp, tc);
    }

    public String toString() {
        return "[FilterProxySupplierTask#" + this.id_ + "]";
    }

    public void setFilterStage(AbstractFilterTask task) {
        this.arrayCurrentFilterStage_ = task.getFilterStageToBeProcessed();
    }

    public void reset() {
        super.reset();
        this.arrayCurrentFilterStage_ = null;
        this.changedMessages_.clear();
    }

    public void doWork() throws InterruptedException {
        if (this.arrayCurrentFilterStage_.length > 0) {
            this.filter();
            AbstractDeliverTask.scheduleTasks(this.getTaskFactory().newPushToConsumerTask(this));
        } else {
            this.logger_.debug("No Consumer connected");
            this.message_.dispose();
        }
        this.dispose();
    }

    private Message updatePriority(int indexOfCurrentEvent, Message m) {
        AnyHolder _priorityFilterResult = new AnyHolder();
        Message _currentMessage = m;
        try {
            boolean priorityMatch = m.match(this.arrayCurrentFilterStage_[indexOfCurrentEvent].getPriorityFilter(), _priorityFilterResult);
            if (priorityMatch) {
                _currentMessage = (Message)this.message_.clone();
                _currentMessage.setPriority(_priorityFilterResult.value.extract_long());
            }
        }
        catch (UnsupportedFilterableData e) {
            // empty catch block
        }
        return _currentMessage;
    }

    private Message updateTimeout(int indexOfCurrentFilterStage, Message event) {
        AnyHolder _lifetimeFilterResult = new AnyHolder();
        Message _currentEvent = event;
        try {
            boolean lifetimeMatch = _currentEvent.match(this.arrayCurrentFilterStage_[indexOfCurrentFilterStage].getLifetimeFilter(), _lifetimeFilterResult);
            if (lifetimeMatch && _currentEvent == this.message_) {
                _currentEvent = (Message)this.message_.clone();
                _currentEvent.setTimeout(_lifetimeFilterResult.value.extract_long());
            }
        }
        catch (UnsupportedFilterableData e) {
            // empty catch block
        }
        return _currentEvent;
    }

    private void filter() {
        for (int x = 0; x < this.arrayCurrentFilterStage_.length; ++x) {
            boolean _forward = false;
            if (!this.arrayCurrentFilterStage_[x].isDisposed()) {
                Message _currentMessage = this.message_;
                if (this.arrayCurrentFilterStage_[x].hasPriorityFilter()) {
                    _currentMessage = this.updatePriority(x, _currentMessage);
                }
                if (this.arrayCurrentFilterStage_[x].hasLifetimeFilter()) {
                    _currentMessage = this.updateTimeout(x, _currentMessage);
                }
                if (_currentMessage != this.message_) {
                    this.changedMessages_.putAlternateMessage(this.arrayCurrentFilterStage_[x], _currentMessage);
                }
                _forward = _currentMessage.match(this.arrayCurrentFilterStage_[x]);
            }
            if (!_forward) continue;
            this.addFilterStage(this.arrayCurrentFilterStage_[x].getSubsequentFilterStages());
        }
    }

    static class AlternateMessageMap {
        private Map alternateMessages_;

        public AlternateMessageMap() {
            this(new HashMap());
        }

        AlternateMessageMap(Map m) {
            this.alternateMessages_ = m;
        }

        public Message getAlternateMessage(FilterStage s) {
            if (this.alternateMessages_.containsKey(s)) {
                return (Message)this.alternateMessages_.get(s);
            }
            return null;
        }

        public void putAlternateMessage(FilterStage s, Message e) {
            this.alternateMessages_.put(s, e);
        }

        public void clear() {
            this.alternateMessages_.clear();
        }
    }
}

