/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import java.util.Hashtable;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.AbstractFilter;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.interfaces.Disposable;
import org.omg.CORBA.Any;
import org.omg.CORBA.AnyHolder;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.TypeCode;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.InvalidValue;
import org.omg.CosNotifyFilter.MappingConstraintInfo;
import org.omg.CosNotifyFilter.MappingConstraintPair;
import org.omg.CosNotifyFilter.MappingFilterPOA;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;

public class MappingFilterImpl
extends MappingFilterPOA
implements Disposable {
    private AbstractFilter filterImpl_;
    private Any defaultValue_;
    private ValueMap valueMap_ = new ValueMap();
    private Logger logger_ = null;
    private org.jacorb.config.Configuration config_ = null;

    public MappingFilterImpl(ApplicationContext context, AbstractFilter filterImpl, Any defaultValue) {
        this.filterImpl_ = filterImpl;
        this.defaultValue_ = defaultValue;
    }

    public void configure(Configuration conf) {
        this.config_ = (org.jacorb.config.Configuration)conf;
        this.logger_ = this.config_.getNamedLogger(this.getClass().getName());
    }

    public void destroy() {
        this.dispose();
    }

    public void dispose() {
        this.filterImpl_.dispose();
        this.valueMap_.dispose();
        this.defaultValue_ = null;
    }

    public String constraint_grammar() {
        return this.filterImpl_.constraint_grammar();
    }

    public TypeCode value_type() {
        return this.defaultValue_.type();
    }

    public Any default_value() {
        return this.defaultValue_;
    }

    public MappingConstraintInfo[] add_mapping_constraints(MappingConstraintPair[] mcp) throws InvalidValue, InvalidConstraint {
        ConstraintExp[] _constraintExpArray = new ConstraintExp[mcp.length];
        for (int x = 0; x < mcp.length; ++x) {
            _constraintExpArray[x] = mcp[x].constraint_expression;
        }
        ConstraintInfo[] _constraintInfo = this.filterImpl_.add_constraints(_constraintExpArray);
        MappingConstraintInfo[] _mappingConstraintInfo = new MappingConstraintInfo[_constraintInfo.length];
        for (int x = 0; x < _constraintInfo.length; ++x) {
            _mappingConstraintInfo[x] = new MappingConstraintInfo(_constraintInfo[x].constraint_expression, _constraintInfo[x].constraint_id, mcp[x].result_to_set);
            this.valueMap_.put(_constraintInfo[x].constraint_id, mcp[x].result_to_set);
        }
        return _mappingConstraintInfo;
    }

    public void modify_mapping_constraints(int[] intArray, MappingConstraintInfo[] mappingConstraintInfos) throws ConstraintNotFound, InvalidValue, InvalidConstraint {
        int x;
        ConstraintInfo[] _constraintInfo = new ConstraintInfo[mappingConstraintInfos.length];
        for (x = 0; x < _constraintInfo.length; ++x) {
            _constraintInfo[x] = new ConstraintInfo(mappingConstraintInfos[x].constraint_expression, mappingConstraintInfos[x].constraint_id);
            this.valueMap_.remove(mappingConstraintInfos[x].constraint_id);
        }
        this.filterImpl_.modify_constraints(intArray, _constraintInfo);
        for (x = 0; x < mappingConstraintInfos.length; ++x) {
            this.valueMap_.put(mappingConstraintInfos[x].constraint_id, mappingConstraintInfos[x].value);
        }
    }

    public MappingConstraintInfo[] get_mapping_constraints(int[] constraintIds) throws ConstraintNotFound {
        ConstraintInfo[] _constraintInfo = this.filterImpl_.get_constraints(constraintIds);
        MappingConstraintInfo[] _mappingConstraintInfo = new MappingConstraintInfo[_constraintInfo.length];
        for (int x = 0; x < _constraintInfo.length; ++x) {
            _mappingConstraintInfo[x] = new MappingConstraintInfo(_constraintInfo[x].constraint_expression, _constraintInfo[x].constraint_id, this.valueMap_.get(_constraintInfo[x].constraint_id));
        }
        return _mappingConstraintInfo;
    }

    public MappingConstraintInfo[] get_all_mapping_constraints() {
        ConstraintInfo[] _constraintInfo = this.filterImpl_.get_all_constraints();
        MappingConstraintInfo[] _mappingConstraintInfo = new MappingConstraintInfo[_constraintInfo.length];
        for (int x = 0; x < _constraintInfo.length; ++x) {
            _mappingConstraintInfo[x] = new MappingConstraintInfo(_constraintInfo[x].constraint_expression, _constraintInfo[x].constraint_id, this.valueMap_.get(_constraintInfo[x].constraint_id));
        }
        return _mappingConstraintInfo;
    }

    public void remove_all_mapping_constraints() {
        this.filterImpl_.remove_all_constraints();
        this.valueMap_.dispose();
    }

    public boolean match(Any any, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int _filterId = this.filterImpl_.match_internal(any);
        if (_filterId >= 0) {
            anyHolder.value = this.valueMap_.get(_filterId);
            return true;
        }
        return false;
    }

    public boolean match_structured(StructuredEvent structuredEvent, AnyHolder anyHolder) throws UnsupportedFilterableData {
        int _filterId = this.filterImpl_.match_structured_internal(structuredEvent);
        if (_filterId >= 0) {
            anyHolder.value = this.valueMap_.get(_filterId);
            return true;
        }
        return false;
    }

    public boolean match_typed(Property[] propertyArray, AnyHolder anyHolder) throws UnsupportedFilterableData {
        throw new NO_IMPLEMENT();
    }

    private static class ValueMap {
        private Map valueMap_ = new Hashtable();

        private ValueMap() {
        }

        public void put(int key, Any value) {
            this.valueMap_.put(new Integer(key), value);
        }

        public Any get(int key) {
            return (Any)this.valueMap_.get(new Integer(key));
        }

        public Any remove(int key) {
            return (Any)this.valueMap_.remove(new Integer(key));
        }

        public void dispose() {
            this.valueMap_.clear();
        }
    }
}

