/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.FIFOReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.omg.CosNotification.EventType;
import org.omg.CosNotifyComm.InvalidEventType;

abstract class EventTypeSet
implements Configurable {
    private static final EventTypeWrapper[] EVENT_TYPE_WRAPPER_TEMPLATE = new EventTypeWrapper[0];
    protected Logger logger_ = null;
    private Set eventTypeSet_ = new TreeSet();
    private ReadWriteLock readWriteLock_ = new FIFOReadWriteLock();
    private EventType[] arrayView_;
    private boolean setModified_;

    EventTypeSet() {
    }

    public void configure(Configuration conf) {
        this.logger_ = ((org.jacorb.config.Configuration)conf).getNamedLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void changeSet(EventType[] added, EventType[] removed) throws InvalidEventType, InterruptedException {
        this.logger_.debug("changeSet");
        ArrayList _addedList = new ArrayList();
        ArrayList _removedList = new ArrayList();
        try {
            Object _eventType;
            EventTypeWrapper event;
            int x;
            this.readWriteLock_.writeLock().acquire();
            TreeSet<EventTypeWrapper> _changedEventTypeSet = new TreeSet<EventTypeWrapper>(this.eventTypeSet_);
            for (x = 0; x < added.length; ++x) {
                event = new EventTypeWrapper(added[x]);
                _changedEventTypeSet.add(event);
            }
            for (x = 0; x < removed.length; ++x) {
                event = new EventTypeWrapper(removed[x]);
                _changedEventTypeSet.remove(event);
            }
            Iterator _i = _changedEventTypeSet.iterator();
            while (_i.hasNext()) {
                _eventType = _i.next();
                if (this.eventTypeSet_.contains(_eventType)) continue;
                _addedList.add(_eventType);
            }
            _i = this.eventTypeSet_.iterator();
            while (_i.hasNext()) {
                _eventType = _i.next();
                if (_changedEventTypeSet.contains(_eventType)) continue;
                _removedList.add(_eventType);
            }
            if (this.logger_.isDebugEnabled()) {
                this.logger_.debug("added: " + _addedList);
                this.logger_.debug("removed: " + _removedList);
            }
            this.eventTypeSet_ = _changedEventTypeSet;
            this.setModified_ = true;
        }
        finally {
            this.readWriteLock_.writeLock().release();
        }
        if (!_addedList.isEmpty() || !_removedList.isEmpty()) {
            this.fireSetChanged(_addedList, _removedList);
        }
    }

    private void fireSetChanged(List added, List removed) {
        EventType[] _addedArray = new EventType[added.size()];
        for (int x = 0; x < _addedArray.length; ++x) {
            _addedArray[x] = ((EventTypeWrapper)added.get(x)).getEventType();
        }
        EventType[] _removedArray = new EventType[removed.size()];
        for (int x = 0; x < _removedArray.length; ++x) {
            _removedArray[x] = ((EventTypeWrapper)removed.get(x)).getEventType();
        }
        this.actionSetChanged(_addedArray, _removedArray);
    }

    abstract void actionSetChanged(EventType[] var1, EventType[] var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected EventType[] getAllTypes() throws InterruptedException {
        try {
            this.readWriteLock_.readLock().acquire();
            EventTypeSet eventTypeSet = this;
            synchronized (eventTypeSet) {
                if (this.setModified_ || this.arrayView_ == null) {
                    EventTypeWrapper[] _allWrapped = this.eventTypeSet_.toArray(EVENT_TYPE_WRAPPER_TEMPLATE);
                    EventType[] _all = new EventType[_allWrapped.length];
                    for (int x = 0; x < _allWrapped.length; ++x) {
                        _all[x] = _allWrapped[x].getEventType();
                    }
                    this.setModified_ = false;
                    this.arrayView_ = _all;
                }
                EventType[] eventTypeArray = this.arrayView_;
                return eventTypeArray;
            }
        }
        finally {
            this.readWriteLock_.readLock().release();
        }
    }

    private static class EventTypeWrapper
    implements Comparable {
        private EventType wrappedEventType_;

        EventTypeWrapper(EventType wrappee) {
            this.wrappedEventType_ = wrappee;
        }

        public EventType getEventType() {
            return this.wrappedEventType_;
        }

        public String toString() {
            return "<EventType domain_name='" + this.wrappedEventType_.domain_name + "' type_name='" + this.wrappedEventType_.type_name + "'>";
        }

        public int hashCode() {
            return this.wrappedEventType_.hashCode();
        }

        public boolean equals(Object o) {
            try {
                EventTypeWrapper _other = (EventTypeWrapper)o;
                return _other.wrappedEventType_.domain_name.equals(this.wrappedEventType_.domain_name) && _other.wrappedEventType_.type_name.equals(this.wrappedEventType_.type_name);
            }
            catch (ClassCastException e) {
                return super.equals(o);
            }
        }

        public int compareTo(Object o) {
            try {
                EventTypeWrapper _other = (EventTypeWrapper)o;
                int _compare = this.wrappedEventType_.domain_name.compareTo(_other.wrappedEventType_.domain_name);
                if (_compare == 0) {
                    _compare = this.wrappedEventType_.type_name.compareTo(_other.wrappedEventType_.type_name);
                }
                return _compare;
            }
            catch (ClassCastException e) {
                throw new IllegalArgumentException();
            }
        }
    }
}

