/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.engine.DefaultTaskProcessor;
import org.jacorb.notification.engine.TaskProcessor;
import org.jacorb.notification.filter.DynamicEvaluator;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.interfaces.AbstractPoolable;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.util.AbstractObjectPool;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.DynamicAny.DynAnyFactoryHelper;
import org.omg.PortableServer.POA;

public class ApplicationContext
implements Disposable,
Configurable {
    private Configuration configuration_;
    private ORB orb_;
    private POA poa_;
    private TaskProcessor taskProcessor_;
    private AbstractObjectPool evaluationContextPool_;
    private MessageFactory notificationEventFactory_;
    private DynAnyFactory dynAnyFactory_;
    private DynamicEvaluator dynamicEvaluator_;

    private void setup(ORB orb, POA poa) throws InvalidName {
        this.orb_ = orb;
        this.poa_ = poa;
        this.dynAnyFactory_ = DynAnyFactoryHelper.narrow(this.orb_.resolve_initial_references("DynAnyFactory"));
        this.dynamicEvaluator_ = new DynamicEvaluator(this.dynAnyFactory_);
        this.evaluationContextPool_ = new AbstractObjectPool("EvaluationContextPool"){

            public Object newInstance() {
                EvaluationContext _e = new EvaluationContext();
                _e.setDynamicEvaluator(ApplicationContext.this.dynamicEvaluator_);
                return _e;
            }

            public void activateObject(Object o) {
                AbstractPoolable obj = (AbstractPoolable)o;
                obj.configure(ApplicationContext.this.configuration_);
                obj.reset();
                obj.setObjectPool(this);
            }
        };
        this.notificationEventFactory_ = new MessageFactory();
        this.taskProcessor_ = new DefaultTaskProcessor();
    }

    public ApplicationContext(ORB orb, POA poa) throws InvalidName {
        this.setup(orb, poa);
    }

    public void configure(Configuration conf) {
        this.configuration_ = conf;
        this.dynamicEvaluator_.configure(conf);
        this.evaluationContextPool_.configure(conf);
        this.notificationEventFactory_.configure(conf);
        ((DefaultTaskProcessor)this.taskProcessor_).configure(conf);
    }

    public void dispose() {
        if (this.taskProcessor_ != null) {
            ((DefaultTaskProcessor)this.taskProcessor_).dispose();
            this.taskProcessor_ = null;
        }
        this.evaluationContextPool_.dispose();
        this.notificationEventFactory_.dispose();
        this.orb_.shutdown(true);
    }

    public ORB getOrb() {
        return this.orb_;
    }

    public void setOrb(ORB newOrb) {
        this.orb_ = newOrb;
    }

    public POA getPoa() {
        return this.poa_;
    }

    public void setPoa(POA newPoa) {
        this.poa_ = newPoa;
    }

    public EvaluationContext newEvaluationContext() {
        return (EvaluationContext)this.evaluationContextPool_.lendObject();
    }

    public MessageFactory getMessageFactory() {
        return this.notificationEventFactory_;
    }

    public DynAnyFactory getDynAnyFactory() {
        return this.dynAnyFactory_;
    }

    public DynamicEvaluator getDynamicEvaluator() {
        return this.dynamicEvaluator_;
    }

    public TaskProcessor getTaskProcessor() {
        return this.taskProcessor_;
    }
}

