/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import EDU.oswego.cs.dl.util.concurrent.WriterPreferenceReadWriteLock;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ApplicationContext;
import org.jacorb.notification.ConstraintEntry;
import org.jacorb.notification.EventTypeIdentifier;
import org.jacorb.notification.MessageFactory;
import org.jacorb.notification.filter.DynamicEvaluator;
import org.jacorb.notification.filter.EvaluationContext;
import org.jacorb.notification.filter.EvaluationException;
import org.jacorb.notification.filter.FilterConstraint;
import org.jacorb.notification.filter.FilterUtils;
import org.jacorb.notification.filter.PropertyDoesNotExistException;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.Message;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.CachingWildcardMap;
import org.jacorb.notification.util.WildcardMap;
import org.omg.CORBA.Any;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.StructuredEvent;
import org.omg.CosNotifyComm.NotifySubscribe;
import org.omg.CosNotifyFilter.ConstraintExp;
import org.omg.CosNotifyFilter.ConstraintInfo;
import org.omg.CosNotifyFilter.ConstraintNotFound;
import org.omg.CosNotifyFilter.Filter;
import org.omg.CosNotifyFilter.FilterPOA;
import org.omg.CosNotifyFilter.InvalidConstraint;
import org.omg.CosNotifyFilter.UnsupportedFilterableData;
import org.omg.DynamicAny.DynAnyFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantNotActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public abstract class AbstractFilter
extends FilterPOA
implements Disposable,
ManageableServant,
Configurable {
    static final RuntimeException NOT_SUPPORTED = new UnsupportedOperationException("this operation is not implemented yet");
    public static final int NO_CONSTRAINTS_MATCH = -2;
    public static final int CONSTRAINTS_EMPTY = -1;
    private static final String EMPTY_EVENT_TYPE_CONSTRAINT_KEY = FilterUtils.calcConstraintKey("*", "*");
    protected Map callbacks_;
    protected Map constraints_;
    protected WildcardMap wildcardMap_;
    protected ReadWriteLock constraintsLock_;
    private Runnable disposeHook_;
    private String constraintGrammar_;
    private SynchronizedInt constraintIdPool_ = new SynchronizedInt(0);
    protected DynamicEvaluator dynamicEvaluator_;
    protected DynAnyFactory dynAnyFactory_;
    protected MessageFactory messageFactory_;
    private long matchCalled_ = 0L;
    private long matchStructuredCalled_ = 0L;
    private POA poa_;
    private ORB orb_;
    private Filter thisRef_;
    private ApplicationContext applicationContext_;
    private static Logger logger_ = null;
    private org.jacorb.config.Configuration config_ = null;

    public AbstractFilter(ApplicationContext applicationContext, String constraintGrammar) {
        this.constraintGrammar_ = constraintGrammar;
        this.applicationContext_ = applicationContext;
        this.messageFactory_ = applicationContext.getMessageFactory();
        this.dynAnyFactory_ = applicationContext.getDynAnyFactory();
        this.dynamicEvaluator_ = applicationContext.getDynamicEvaluator();
        this.constraints_ = new HashMap();
        this.constraintsLock_ = new WriterPreferenceReadWriteLock();
        this.wildcardMap_ = new CachingWildcardMap(4);
    }

    public void configure(Configuration conf) {
        this.config_ = (org.jacorb.config.Configuration)conf;
        logger_ = this.config_.getNamedLogger(this.getClass().getName());
        if (logger_.isInfoEnabled()) {
            logger_.info("Created filter for Grammar: " + this.constraintGrammar_);
        }
    }

    public void setORB(ORB orb) {
        this.orb_ = orb;
    }

    public void setPOA(POA poa) {
        this.poa_ = poa;
    }

    public void preActivate() {
    }

    public Object activate() {
        if (this.thisRef_ == null) {
            this.thisRef_ = this._this(this.orb_);
        }
        return this.thisRef_;
    }

    public void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this));
        }
        catch (WrongPolicy e) {
            logger_.fatalError("error deactivating object", (Throwable)e);
        }
        catch (ObjectNotActive e) {
            logger_.fatalError("error deactivating object", (Throwable)e);
        }
        catch (ServantNotActive e) {
            logger_.fatalError("error deactivating object", (Throwable)e);
        }
    }

    protected int getConstraintId() {
        return this.constraintIdPool_.increment();
    }

    public String constraint_grammar() {
        return this.constraintGrammar_;
    }

    private void addConstraintEntryToWildcardMap(String constraintKey, ConstraintEntry constraintEntry) {
        LinkedList<ConstraintEntry> _listOfConstraintEntry = (LinkedList<ConstraintEntry>)this.wildcardMap_.getNoExpansion(constraintKey);
        if (_listOfConstraintEntry == null) {
            _listOfConstraintEntry = new LinkedList<ConstraintEntry>();
            this.wildcardMap_.put(constraintKey, _listOfConstraintEntry);
        }
        _listOfConstraintEntry.add(constraintEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] add_constraints(ConstraintExp[] constraintExp) throws InvalidConstraint {
        ConstraintInfo[] _x3;
        FilterConstraint[] _arrayFilterConstraint = new FilterConstraint[constraintExp.length];
        for (int _x2 = 0; _x2 < constraintExp.length; ++_x2) {
            _arrayFilterConstraint[_x2] = this.newFilterConstraint(constraintExp[_x2]);
        }
        ConstraintInfo[] _arrayConstraintInfo = new ConstraintInfo[constraintExp.length];
        this.constraintsLock_.writeLock().acquire();
        try {
            for (int _x3 = 0; _x3 < constraintExp.length; ++_x3) {
                int _constraintId = this.getConstraintId();
                _arrayConstraintInfo[_x3] = new ConstraintInfo(constraintExp[_x3], _constraintId);
                ConstraintEntry _entry = new ConstraintEntry(_constraintId, _arrayFilterConstraint[_x3], _arrayConstraintInfo[_x3]);
                int _eventTypeCount = _entry.getEventTypeCount();
                if (_eventTypeCount == 0) {
                    this.addConstraintEntryToWildcardMap(EMPTY_EVENT_TYPE_CONSTRAINT_KEY, _entry);
                } else {
                    for (int _y = 0; _y < _eventTypeCount; ++_y) {
                        EventTypeIdentifier _eventTypeIdentifier = _entry.getEventTypeIdentifier(_y);
                        this.addConstraintEntryToWildcardMap(_eventTypeIdentifier.getConstraintKey(), _entry);
                    }
                }
                this.constraints_.put(new Integer(_constraintId), _entry);
            }
            _x3 = _arrayConstraintInfo;
        }
        catch (Throwable throwable) {
            try {
                this.constraintsLock_.writeLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        this.constraintsLock_.writeLock().release();
        return _x3;
    }

    protected abstract FilterConstraint newFilterConstraint(ConstraintExp var1) throws InvalidConstraint;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void modify_constraints(int[] deleteIds, ConstraintInfo[] constraintInfo) throws ConstraintNotFound, InvalidConstraint {
        try {
            this.constraintsLock_.writeLock().acquire();
            try {
                List _listOfConstraintEvaluator;
                EventTypeIdentifier _eventTypeIdentifier;
                int _y;
                int _eventTypeCount;
                int _x;
                Integer[] _deleteKeys = new Integer[deleteIds.length];
                for (int _x2 = 0; _x2 < deleteIds.length; ++_x2) {
                    _deleteKeys[_x2] = new Integer(deleteIds[_x2]);
                    if (this.constraints_.containsKey(_deleteKeys[_x2])) continue;
                    throw new ConstraintNotFound(deleteIds[_x2]);
                }
                Integer[] _constraintKeys = new Integer[constraintInfo.length];
                FilterConstraint[] _arrayConstraintEvaluator = new FilterConstraint[constraintInfo.length];
                for (_x = 0; _x < constraintInfo.length; ++_x) {
                    _constraintKeys[_x] = new Integer(constraintInfo[_x].constraint_id);
                    if (!this.constraints_.containsKey(_constraintKeys[_x])) {
                        throw new ConstraintNotFound(constraintInfo[_x].constraint_id);
                    }
                    _arrayConstraintEvaluator[_x] = this.newFilterConstraint(constraintInfo[_x].constraint_expression);
                    int _length = constraintInfo[_x].constraint_expression.event_types.length;
                }
                for (_x = 0; _x < deleteIds.length; ++_x) {
                    ConstraintEntry _deletedEntry = (ConstraintEntry)this.constraints_.remove(_deleteKeys[_x]);
                    _eventTypeCount = _deletedEntry.getEventTypeCount();
                    block8: for (_y = 0; _y < _eventTypeCount; ++_y) {
                        _eventTypeIdentifier = _deletedEntry.getEventTypeIdentifier(_y);
                        _listOfConstraintEvaluator = (List)this.wildcardMap_.getNoExpansion(_eventTypeIdentifier.getConstraintKey());
                        Iterator _i = _listOfConstraintEvaluator.iterator();
                        while (_i.hasNext()) {
                            ConstraintEntry _c = (ConstraintEntry)_i.next();
                            if (_c.getConstraintId() != _deleteKeys[_x].intValue()) continue;
                            _i.remove();
                            continue block8;
                        }
                    }
                }
                for (_x = 0; _x < constraintInfo.length; ++_x) {
                    ConstraintEntry _entry = new ConstraintEntry(_constraintKeys[_x], _arrayConstraintEvaluator[_x], constraintInfo[_x]);
                    this.constraints_.put(_constraintKeys[_x], _entry);
                    _eventTypeCount = _entry.getEventTypeCount();
                    for (_y = 0; _y < _eventTypeCount; ++_y) {
                        _eventTypeIdentifier = _entry.getEventTypeIdentifier(_y);
                        _listOfConstraintEvaluator = (List)this.wildcardMap_.getNoExpansion(_eventTypeIdentifier.getConstraintKey());
                        _listOfConstraintEvaluator.add(_entry);
                    }
                }
                return;
            }
            finally {
                this.constraintsLock_.writeLock().release();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] get_constraints(int[] ids) throws ConstraintNotFound {
        ConstraintInfo[] _x2;
        ConstraintInfo[] _constraintInfo = new ConstraintInfo[ids.length];
        Sync _lock = this.constraintsLock_.readLock();
        _lock.acquire();
        try {
            for (int _x2 = 0; _x2 < ids.length; ++_x2) {
                Integer _key = new Integer(ids[_x2]);
                if (!this.constraints_.containsKey(_key)) {
                    throw new ConstraintNotFound(ids[_x2]);
                }
                _constraintInfo[_x2] = ((ConstraintEntry)this.constraints_.get(_key)).getConstraintInfo();
            }
            _x2 = _constraintInfo;
        }
        catch (Throwable throwable) {
            try {
                _lock.release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        _lock.release();
        return _x2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConstraintInfo[] get_all_constraints() {
        ConstraintInfo[] constraintInfoArray;
        this.constraintsLock_.readLock().acquire();
        try {
            ConstraintInfo[] _constraintInfo = new ConstraintInfo[this.constraints_.size()];
            Iterator _i = this.constraints_.values().iterator();
            int _x = -1;
            while (_i.hasNext()) {
                _constraintInfo[++_x] = ((ConstraintEntry)_i.next()).getConstraintInfo();
            }
            constraintInfoArray = _constraintInfo;
        }
        catch (Throwable throwable) {
            try {
                this.constraintsLock_.readLock().release();
                throw throwable;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        this.constraintsLock_.readLock().release();
        return constraintInfoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove_all_constraints() {
        try {
            this.constraintsLock_.writeLock().acquire();
            try {
                this.constraints_.clear();
                this.wildcardMap_.clear();
                return;
            }
            finally {
                this.constraintsLock_.writeLock().release();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return;
        }
    }

    public void destroy() {
        this.dispose();
    }

    Iterator getConstraintsForEvent(Message event) {
        String _key = event.getConstraintKey();
        return this.getIterator(_key);
    }

    public Iterator getIterator(java.lang.Object key) {
        java.lang.Object[] _entries = this.wildcardMap_.getWithExpansion(key);
        return new ConstraintIterator(_entries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int match(EvaluationContext evaluationContext, Message event) throws UnsupportedFilterableData {
        try {
            this.constraintsLock_.readLock().acquire();
            try {
                if (this.constraints_.isEmpty()) {
                    logger_.info("Filter has no Expressions");
                    int _entries22 = -1;
                    return _entries22;
                }
                Iterator _entries22 = this.getConstraintsForEvent(event);
                while (_entries22.hasNext()) {
                    ConstraintEntry _entry = (ConstraintEntry)_entries22.next();
                    try {
                        boolean _result = _entry.getFilterConstraint().evaluate(evaluationContext, event).getBool();
                        if (!_result) continue;
                        int n = _entry.getConstraintId();
                        return n;
                    }
                    catch (PropertyDoesNotExistException e) {
                        logger_.debug("tried to access non existing Property", (Throwable)e);
                    }
                    catch (EvaluationException e) {
                        logger_.fatalError("Error evaluating filter", (Throwable)e);
                        throw new UnsupportedFilterableData(e.getMessage());
                    }
                }
                int _entries22 = -2;
                return _entries22;
            }
            finally {
                this.constraintsLock_.readLock().release();
            }
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            return -2;
        }
    }

    public boolean match(Any anyEvent) throws UnsupportedFilterableData {
        ++this.matchCalled_;
        return this.match_internal(anyEvent) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_internal(Any anyEvent) throws UnsupportedFilterableData {
        int n;
        EvaluationContext _evaluationContext = null;
        Disposable _event = null;
        try {
            _evaluationContext = this.applicationContext_.newEvaluationContext();
            _event = this.messageFactory_.newMessage(anyEvent);
            n = this.match(_evaluationContext, (Message)_event);
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            try {
                _event.dispose();
            }
            catch (Exception e) {
                logger_.fatalError("Error disposing event", (Throwable)e);
            }
            try {
                _evaluationContext.dispose();
            }
            catch (Exception e) {
                logger_.fatalError("Error disposing EvaluationContext", (Throwable)e);
            }
            throw throwable;
        }
        try {
            _event.dispose();
        }
        catch (Exception e) {
            logger_.fatalError("Error disposing event", (Throwable)e);
        }
        try {
            _evaluationContext.dispose();
        }
        catch (Exception e) {
            logger_.fatalError("Error disposing EvaluationContext", (Throwable)e);
        }
        return n;
    }

    public boolean match_structured(StructuredEvent structuredevent) throws UnsupportedFilterableData {
        ++this.matchStructuredCalled_;
        return this.match_structured_internal(structuredevent) >= 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_structured_internal(StructuredEvent structuredEvent) throws UnsupportedFilterableData {
        int n;
        EvaluationContext _evaluationContext = null;
        Disposable _event = null;
        try {
            _evaluationContext = this.applicationContext_.newEvaluationContext();
            _event = this.messageFactory_.newMessage(structuredEvent);
            n = this.match(_evaluationContext, (Message)_event);
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            try {
                _event.dispose();
            }
            catch (Exception e) {
                logger_.fatalError("Error disposing event", (Throwable)e);
            }
            try {
                _evaluationContext.dispose();
            }
            catch (Exception e) {
                logger_.fatalError("Error releasing EvaluationContext", (Throwable)e);
            }
            throw throwable;
        }
        try {
            _event.dispose();
        }
        catch (Exception e) {
            logger_.fatalError("Error disposing event", (Throwable)e);
        }
        try {
            _evaluationContext.dispose();
        }
        catch (Exception e) {
            logger_.fatalError("Error releasing EvaluationContext", (Throwable)e);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int match_typed_internal(Property[] typedEvent) throws UnsupportedFilterableData {
        int n;
        EvaluationContext _evaluationContext = null;
        Disposable _event = null;
        try {
            _evaluationContext = this.applicationContext_.newEvaluationContext();
            _event = this.messageFactory_.newMessage(typedEvent);
            n = this.match(_evaluationContext, (Message)_event);
            java.lang.Object var6_5 = null;
        }
        catch (Throwable throwable) {
            java.lang.Object var6_6 = null;
            try {
                _event.dispose();
            }
            catch (Exception e) {
                logger_.fatalError("Error disposing event", (Throwable)e);
            }
            try {
                _evaluationContext.dispose();
            }
            catch (Exception e) {
                logger_.fatalError("Error releasing EvaluationContext", (Throwable)e);
            }
            throw throwable;
        }
        try {
            _event.dispose();
        }
        catch (Exception e) {
            logger_.fatalError("Error disposing event", (Throwable)e);
        }
        try {
            _evaluationContext.dispose();
        }
        catch (Exception e) {
            logger_.fatalError("Error releasing EvaluationContext", (Throwable)e);
        }
        return n;
    }

    public boolean match_typed(Property[] properties) throws UnsupportedFilterableData {
        return this.match_typed_internal(properties) >= 0;
    }

    public int attach_callback(NotifySubscribe notifySubscribe) {
        throw new NO_IMPLEMENT();
    }

    public void detach_callback(int id) {
        throw new NO_IMPLEMENT();
    }

    public int[] get_callbacks() {
        throw new NO_IMPLEMENT();
    }

    public POA _default_POA() {
        return this.applicationContext_.getPoa();
    }

    public void dispose() {
        this.deactivate();
        if (this.disposeHook_ != null) {
            this.disposeHook_.run();
        }
    }

    public void setDisposeHook(Runnable disposeHook) {
        this.disposeHook_ = disposeHook;
    }

    private static class ConstraintIterator
    implements Iterator {
        java.lang.Object[] arrayOfLists_;
        Iterator current_;
        int currentListIdx_ = 0;

        ConstraintIterator(java.lang.Object[] arrayOfLists) {
            this.arrayOfLists_ = arrayOfLists;
            if (logger_ != null && logger_.isDebugEnabled()) {
                for (int x = 0; x < this.arrayOfLists_.length; ++x) {
                    logger_.debug(x + ": " + this.arrayOfLists_[x]);
                }
            }
            this.current_ = this.arrayOfLists_.length == 0 ? null : ((List)this.arrayOfLists_[this.currentListIdx_]).iterator();
        }

        public boolean hasNext() {
            return this.current_ != null && this.current_.hasNext();
        }

        public java.lang.Object next() {
            if (this.current_ == null) {
                throw new NoSuchElementException();
            }
            java.lang.Object _ret = this.current_.next();
            if (!this.current_.hasNext() && this.currentListIdx_ < this.arrayOfLists_.length - 1) {
                this.current_ = ((List)this.arrayOfLists_[++this.currentListIdx_]).iterator();
            }
            return _ret;
        }

        public void remove() {
            throw NOT_SUPPORTED;
        }
    }
}

