/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.notification;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedInt;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.notification.ChannelContext;
import org.jacorb.notification.ChannelContextDependency;
import org.jacorb.notification.Dependant;
import org.jacorb.notification.EventChannelFactoryDependency;
import org.jacorb.notification.OfferManager;
import org.jacorb.notification.SubscriptionManager;
import org.jacorb.notification.interfaces.AdminEvent;
import org.jacorb.notification.interfaces.AdminEventListener;
import org.jacorb.notification.interfaces.Disposable;
import org.jacorb.notification.interfaces.FilterStage;
import org.jacorb.notification.interfaces.FilterStageSource;
import org.jacorb.notification.interfaces.ProxyEvent;
import org.jacorb.notification.interfaces.ProxyEventListener;
import org.jacorb.notification.servant.AbstractAdmin;
import org.jacorb.notification.servant.AbstractSupplierAdmin;
import org.jacorb.notification.servant.FilterStageListManager;
import org.jacorb.notification.servant.ManageableServant;
import org.jacorb.notification.util.AdminPropertySet;
import org.jacorb.notification.util.PropertySet;
import org.jacorb.notification.util.QoSPropertySet;
import org.omg.CORBA.Any;
import org.omg.CORBA.IntHolder;
import org.omg.CORBA.ORB;
import org.omg.CosNotification.NamedPropertyRangeSeqHolder;
import org.omg.CosNotification.Property;
import org.omg.CosNotification.UnsupportedAdmin;
import org.omg.CosNotification.UnsupportedQoS;
import org.omg.CosNotifyChannelAdmin.AdminLimit;
import org.omg.CosNotifyChannelAdmin.AdminLimitExceeded;
import org.omg.CosNotifyChannelAdmin.AdminNotFound;
import org.omg.CosNotifyChannelAdmin.InterFilterGroupOperator;
import org.omg.CosNotifyFilter.FilterFactory;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.Servant;

public abstract class AbstractEventChannel
implements Disposable,
ManageableServant,
Configurable,
ChannelContextDependency,
Dependant,
EventChannelFactoryDependency {
    protected Logger logger_ = null;
    protected Servant thisServant_;
    protected Configuration configuration_ = null;
    private ORB orb_;
    private POA poa_;
    private ChannelContext channelContext_;
    private FilterFactory defaultFilterFactory_;
    private String ior_;
    private int key_;
    private FilterStageListManager listManager_;
    private final Object modifyConsumerAdminsLock_ = new Object();
    private final Object modifySupplierAdminsLock_ = new Object();
    private final Map consumerAdminServants_ = new HashMap();
    private final Map supplierAdminServants_ = new HashMap();
    private final SynchronizedInt adminIdPool_ = new SynchronizedInt(1);
    public static final Integer DEFAULT_ADMIN_KEY = new Integer(0);
    private final SynchronizedInt numberOfConsumers_ = new SynchronizedInt(0);
    private final SynchronizedInt numberOfSuppliers_ = new SynchronizedInt(0);
    private int maxNumberOfConsumers_;
    private boolean lazyDefaultAdminInit_;
    private int maxNumberOfSuppliers_;
    private final SubscriptionManager subscriptionManager_ = new SubscriptionManager();
    private final OfferManager offerManager_ = new OfferManager();
    private AdminPropertySet adminSettings_;
    private QoSPropertySet qosSettings_;
    private List listAdminEventListeners_ = new ArrayList();
    private Runnable disposeHook_;
    private ProxyEventListener proxyConsumerEventListener_ = new ProxyEventListener(){

        public void actionProxyCreationRequest(ProxyEvent event) throws AdminLimitExceeded {
            AbstractEventChannel.this.addConsumer();
        }

        public void actionProxyCreated(ProxyEvent event) {
        }

        public void actionProxyDisposed(ProxyEvent event) {
            AbstractEventChannel.this.removeConsumer();
        }
    };
    private ProxyEventListener proxySupplierEventListener_ = new ProxyEventListener(){

        public void actionProxyCreationRequest(ProxyEvent event) throws AdminLimitExceeded {
            AbstractEventChannel.this.addSupplier();
        }

        public void actionProxyCreated(ProxyEvent event) {
        }

        public void actionProxyDisposed(ProxyEvent event) {
            AbstractEventChannel.this.removeSupplier();
        }
    };

    public final void setDefaultFilterFactory(FilterFactory filterFactory) {
        this.defaultFilterFactory_ = filterFactory;
    }

    public AbstractEventChannel() {
        this.listManager_ = new FilterStageListManager(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void fetchListData(FilterStageListManager.List list) {
                Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    Iterator i = AbstractEventChannel.this.consumerAdminServants_.keySet().iterator();
                    while (i.hasNext()) {
                        Integer _key = (Integer)i.next();
                        list.add((FilterStage)AbstractEventChannel.this.consumerAdminServants_.get(_key));
                    }
                }
            }
        };
    }

    public final void setChannelContext(ChannelContext context) {
        this.channelContext_ = context;
    }

    protected ChannelContext getChannelContext() {
        return this.channelContext_;
    }

    public void configure(Configuration conf) throws ConfigurationException {
        this.configuration_ = conf;
        this.logger_ = ((org.jacorb.config.Configuration)conf).getNamedLogger(this.getClass().getName());
        this.lazyDefaultAdminInit_ = conf.getAttribute("jacorb.notification.admin.lazy_initialization", "on").equals("on");
        this.subscriptionManager_.configure(conf);
        this.offerManager_.configure(conf);
        this.adminSettings_ = new AdminPropertySet(conf);
        this.qosSettings_ = new QoSPropertySet(conf, 0);
    }

    public void preActivate() {
    }

    public void setKey(int key) {
        this.key_ = key;
    }

    public void setORB(ORB orb) {
        this.orb_ = orb;
    }

    protected ORB getORB() {
        return this.orb_;
    }

    public void setPOA(POA poa) {
        this.poa_ = poa;
    }

    protected POA getPOA() {
        return this.poa_;
    }

    private void addConsumer() throws AdminLimitExceeded {
        if (this.maxNumberOfConsumers_ != 0 && this.numberOfConsumers_.compareTo(this.maxNumberOfConsumers_) >= 0) {
            Any _any = this.orb_.create_any();
            _any.insert_long(this.maxNumberOfConsumers_);
            AdminLimit _limit = new AdminLimit("consumer limit", _any);
            throw new AdminLimitExceeded("Consumer creation request exceeds AdminLimit.", _limit);
        }
        this.numberOfConsumers_.increment();
    }

    private void removeConsumer() {
        this.numberOfConsumers_.decrement();
    }

    private void addSupplier() throws AdminLimitExceeded {
        if (this.maxNumberOfSuppliers_ != 0 && this.numberOfSuppliers_.compareTo(this.maxNumberOfSuppliers_) >= 0) {
            Any _any = this.orb_.create_any();
            _any.insert_long(this.maxNumberOfSuppliers_);
            AdminLimit _limit = new AdminLimit("suppliers limit", _any);
            throw new AdminLimitExceeded("supplier creation request exceeds AdminLimit.", _limit);
        }
        this.numberOfSuppliers_.increment();
    }

    private void removeSupplier() {
        this.numberOfSuppliers_.decrement();
    }

    final int getAdminId() {
        return this.adminIdPool_.increment();
    }

    protected final void fireAdminCreatedEvent(AbstractAdmin admin) {
        Iterator i = this.listAdminEventListeners_.iterator();
        AdminEvent e = new AdminEvent(admin);
        while (i.hasNext()) {
            ((AdminEventListener)i.next()).actionAdminCreated(e);
        }
    }

    protected final void fireAdminDestroyedEvent(AbstractAdmin admin) {
        Iterator i = this.listAdminEventListeners_.iterator();
        AdminEvent e = new AdminEvent(admin);
        while (i.hasNext()) {
            ((AdminEventListener)i.next()).actionAdminDestroyed(e);
        }
    }

    public final void addAdminEventListener(AdminEventListener l) {
        this.listAdminEventListeners_.add(l);
    }

    public final void removeAdminEventListener(AdminEventListener l) {
        this.listAdminEventListeners_.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultConsumerAdminActive() {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            return this.consumerAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean isDefaultSupplierAdminActive() {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            return this.supplierAdminServants_.containsKey(DEFAULT_ADMIN_KEY);
        }
    }

    public final FilterFactory default_filter_factory() {
        return this.defaultFilterFactory_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_consumeradmins() {
        int[] _allKeys;
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            _allKeys = new int[this.consumerAdminServants_.size()];
            Iterator i = this.consumerAdminServants_.keySet().iterator();
            int x = 0;
            while (i.hasNext()) {
                _allKeys[x++] = (Integer)i.next();
            }
        }
        return _allKeys;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int[] get_all_supplieradmins() {
        int[] _allKeys;
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            _allKeys = new int[this.supplierAdminServants_.size()];
            Iterator i = this.supplierAdminServants_.keySet().iterator();
            int x = 0;
            while (i.hasNext()) {
                _allKeys[x++] = (Integer)i.next();
            }
        }
        return _allKeys;
    }

    public final Property[] get_admin() {
        return this.adminSettings_.toArray();
    }

    public final Property[] get_qos() {
        return this.qosSettings_.toArray();
    }

    public final void set_qos(Property[] props) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, new NamedPropertyRangeSeqHolder());
        this.qosSettings_.set_qos(props);
    }

    public final void validate_qos(Property[] props, NamedPropertyRangeSeqHolder namedPropertySeqHolder) throws UnsupportedQoS {
        this.qosSettings_.validate_qos(props, new NamedPropertyRangeSeqHolder());
    }

    public final void set_admin(Property[] adminProps) throws UnsupportedAdmin {
        this.adminSettings_.validate_admin(adminProps);
        this.adminSettings_.set_admin(adminProps);
        this.configureAdminLimits(this.adminSettings_);
    }

    private void configureAdminLimits(PropertySet adminProperties) {
        Any _maxConsumers = adminProperties.get("MaxConsumers");
        this.maxNumberOfConsumers_ = _maxConsumers.extract_long();
        Any _maxSuppliers = adminProperties.get("MaxSuppliers");
        this.maxNumberOfSuppliers_ = _maxSuppliers.extract_long();
        if (this.logger_.isInfoEnabled()) {
            this.logger_.info("set MaxNumberOfConsumers=" + this.maxNumberOfConsumers_);
            this.logger_.info("set MaxNumberOfSuppliers=" + this.maxNumberOfSuppliers_);
        }
    }

    public final void destroy() {
        this.dispose();
    }

    public void setDisposeHook(Runnable disposeHook) {
        this.disposeHook_ = disposeHook;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispose() {
        Disposable _d;
        Iterator _i;
        this.logger_.info("destroy channel");
        this.deactivate();
        this.disposeHook_.run();
        this.logger_.info("destroy ConsumerAdmins");
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            _i = this.consumerAdminServants_.values().iterator();
            while (_i.hasNext()) {
                _d = (Disposable)_i.next();
                _i.remove();
                _d.dispose();
            }
        }
        this.logger_.info("destroy SupplierAdmins");
        object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            _i = this.supplierAdminServants_.values().iterator();
            while (_i.hasNext()) {
                _d = (Disposable)_i.next();
                _i.remove();
                _d.dispose();
            }
        }
        this.listAdminEventListeners_.clear();
    }

    public final POA _default_POA() {
        return this.getPOA();
    }

    public int getKey() {
        return this.key_;
    }

    public String getIOR() {
        return this.ior_;
    }

    public boolean isPersistent() {
        return false;
    }

    public final int getNumberOfConnectedClients() {
        return this.numberOfConsumers_.get() + this.numberOfSuppliers_.get();
    }

    public final int getMaxNumberOfSuppliers() {
        return this.maxNumberOfSuppliers_;
    }

    public final int getMaxNumberOfConsumers() {
        return this.maxNumberOfConsumers_;
    }

    public final void deactivate() {
        try {
            this.poa_.deactivate_object(this.poa_.servant_to_id(this.thisServant_));
        }
        catch (Exception e) {
            this.logger_.error("Unable to deactivate EventChannel Object", (Throwable)e);
            throw new RuntimeException();
        }
    }

    private Property[] createQoSPropertiesForAdmin() {
        HashMap _copy = new HashMap(this.qosSettings_.toMap());
        _copy.remove("EventReliability");
        return PropertySet.map2Props(_copy);
    }

    private void configureAdmin(AbstractAdmin admin) {
        this.getChannelContext().resolveDependencies(admin);
        admin.configure(this.configuration_);
        admin.setSubscriptionManager(this.subscriptionManager_);
        admin.setOfferManager(this.offerManager_);
    }

    protected AbstractAdmin get_consumeradmin_internal(int identifier) throws AdminNotFound {
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            Integer _key = new Integer(identifier);
            if (this.consumerAdminServants_.containsKey(_key)) {
                AbstractAdmin _admin = (AbstractAdmin)this.consumerAdminServants_.get(_key);
                return _admin;
            }
            throw new AdminNotFound("ID " + identifier + " does not exist.");
        }
    }

    protected AbstractAdmin get_supplieradmin_internal(int identifier) throws AdminNotFound {
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            Integer _key = new Integer(identifier);
            if (this.supplierAdminServants_.containsKey(_key)) {
                AbstractAdmin _admin = (AbstractAdmin)this.supplierAdminServants_.get(_key);
                return _admin;
            }
            throw new AdminNotFound("ID " + identifier + " does not exist.");
        }
    }

    private List getAllConsumerAdmins() {
        return this.listManager_.getList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultConsumerAdminServant() {
        AbstractAdmin _admin;
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            _admin = (AbstractAdmin)this.consumerAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (_admin == null) {
                _admin = this.newConsumerAdminServant(DEFAULT_ADMIN_KEY);
                try {
                    _admin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS e) {
                    this.logger_.fatalError("unable to set qos", (Throwable)e);
                }
                this.addToConsumerAdmins(_admin);
                this.fireAdminCreatedEvent(_admin);
            }
        }
        return _admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToConsumerAdmins(AbstractAdmin admin) {
        final Integer _key = admin.getID();
        admin.setDisposeHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AbstractEventChannel.this.modifyConsumerAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.consumerAdminServants_.remove(_key);
                    AbstractEventChannel.this.listManager_.actionSourceModified();
                }
            }
        });
        Object object = this.modifyConsumerAdminsLock_;
        synchronized (object) {
            this.consumerAdminServants_.put(_key, admin);
            this.listManager_.actionSourceModified();
        }
    }

    protected AbstractAdmin new_for_consumers_servant(InterFilterGroupOperator filterGroupOperator, IntHolder intHolder) {
        AbstractAdmin _admin = this.newConsumerAdminServant();
        _admin.setInterFilterGroupOperator(filterGroupOperator);
        intHolder.value = _admin.getID();
        _admin.setIsIDPublic(true);
        try {
            _admin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS e) {
            this.logger_.error("unable to set QoS", (Throwable)e);
        }
        _admin.addProxyEventListener(this.proxySupplierEventListener_);
        this.addToConsumerAdmins(_admin);
        this.fireAdminCreatedEvent(_admin);
        return _admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToSupplierAdmins(AbstractAdmin admin) {
        final Integer _key = admin.getID();
        admin.setDisposeHook(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AbstractEventChannel.this.modifySupplierAdminsLock_;
                synchronized (object) {
                    AbstractEventChannel.this.supplierAdminServants_.remove(_key);
                }
            }
        });
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            this.supplierAdminServants_.put(_key, admin);
        }
    }

    protected AbstractAdmin new_for_suppliers_servant(InterFilterGroupOperator filterGroupOperator, IntHolder intHolder) {
        AbstractAdmin _admin = this.newSupplierAdminServant();
        intHolder.value = _admin.getID();
        _admin.setInterFilterGroupOperator(filterGroupOperator);
        _admin.setIsIDPublic(true);
        try {
            _admin.set_qos(this.createQoSPropertiesForAdmin());
        }
        catch (UnsupportedQoS e) {
            this.logger_.fatalError("error setting qos", (Throwable)e);
        }
        _admin.addProxyEventListener(this.proxyConsumerEventListener_);
        this.addToSupplierAdmins(_admin);
        this.fireAdminCreatedEvent(_admin);
        return _admin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected AbstractAdmin getDefaultSupplierAdminServant() {
        AbstractAdmin _admin;
        Object object = this.modifySupplierAdminsLock_;
        synchronized (object) {
            _admin = (AbstractAdmin)this.supplierAdminServants_.get(DEFAULT_ADMIN_KEY);
            if (_admin == null) {
                _admin = this.newSupplierAdminServant(DEFAULT_ADMIN_KEY);
                try {
                    _admin.set_qos(this.createQoSPropertiesForAdmin());
                }
                catch (UnsupportedQoS e) {
                    this.logger_.fatalError("unable to set qos", (Throwable)e);
                }
                this.addToSupplierAdmins(_admin);
                this.fireAdminCreatedEvent(_admin);
            }
        }
        return _admin;
    }

    private AbstractAdmin newConsumerAdminServant() {
        return this.newConsumerAdminServant(new Integer(this.adminIdPool_.increment()));
    }

    private AbstractAdmin newConsumerAdminServant(Integer key) {
        AbstractAdmin _admin = this.newConsumerAdmin();
        this.configureAdmin(_admin);
        _admin.setID(key);
        return _admin;
    }

    protected abstract AbstractAdmin newConsumerAdmin();

    private AbstractAdmin newSupplierAdminServant() {
        return this.newSupplierAdminServant(new Integer(this.adminIdPool_.increment()));
    }

    private AbstractAdmin newSupplierAdminServant(Integer key) {
        AbstractSupplierAdmin _admin = this.newSupplierAdmin();
        _admin.setSubsequentFilterStageSource(new FilterStageSource(){

            public List getSubsequentFilterStages() {
                return AbstractEventChannel.this.getAllConsumerAdmins();
            }
        });
        this.configureAdmin(_admin);
        _admin.setID(key);
        return _admin;
    }

    protected abstract AbstractSupplierAdmin newSupplierAdmin();
}

