/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.imr.AdminPackage.IllegalServerName;
import org.jacorb.imr.ImRPOAInfo;
import org.jacorb.imr.POAInfo;
import org.jacorb.imr.ResourceLock;
import org.jacorb.imr.ServerInfo;

public class ImRServerInfo
implements Serializable {
    protected String command;
    protected boolean holding = false;
    protected String host;
    protected String name;
    protected boolean active;
    protected boolean restarting = false;
    private Vector poas = null;
    private ResourceLock poas_lock = null;

    public ImRServerInfo(String name, String host, String command) throws IllegalServerName {
        if (name == null || name.length() == 0) {
            throw new IllegalServerName(name);
        }
        this.name = name;
        this.host = host;
        this.command = command;
        this.active = false;
        this.poas = new Vector();
        this.poas_lock = new ResourceLock();
    }

    public ServerInfo toServerInfo() {
        this.poas_lock.gainExclusiveLock();
        POAInfo[] _poas = new POAInfo[this.poas.size()];
        Enumeration _poa_enum = this.poas.elements();
        int _i = 0;
        while (_poa_enum.hasMoreElements()) {
            _poas[_i++] = ((ImRPOAInfo)_poa_enum.nextElement()).toPOAInfo();
        }
        this.poas_lock.releaseExclusiveLock();
        return new ServerInfo(this.name, this.command, _poas, this.host, this.active, this.holding);
    }

    public void addPOA(ImRPOAInfo poa) {
        if (!this.active) {
            this.active = true;
        }
        this.poas_lock.gainSharedLock();
        this.poas.addElement(poa);
        this.poas_lock.releaseSharedLock();
    }

    protected String[] getPOANames() {
        String[] _poa_names = new String[this.poas.size()];
        Enumeration _poa_enum = this.poas.elements();
        int _i = 0;
        while (_poa_enum.hasMoreElements()) {
            _poa_names[_i++] = ((ImRPOAInfo)_poa_enum.nextElement()).name;
        }
        return _poa_names;
    }

    public void setDown() {
        for (int _i = 0; _i < this.poas.size(); ++_i) {
            ((ImRPOAInfo)this.poas.elementAt((int)_i)).active = false;
        }
        this.active = false;
        this.restarting = false;
    }

    public synchronized void awaitRelease() {
        while (this.holding) {
            try {
                this.wait();
            }
            catch (Exception exception) {}
        }
    }

    public synchronized void release() {
        this.holding = false;
        this.notifyAll();
    }

    public synchronized boolean shouldBeRestarted() {
        boolean _restart;
        boolean bl = _restart = !this.active && !this.restarting;
        if (_restart) {
            this.restarting = true;
        }
        return _restart;
    }

    public void setNotRestarting() {
        this.restarting = false;
    }
}

