/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jacorb.imr.HostInfo;
import org.jacorb.imr.ServerStartupDaemon;
import org.jacorb.imr.ServerStartupDaemonHelper;
import org.jacorb.imr.ServerStartupFailed;
import org.omg.CORBA.ORB;

public class ImRHostInfo
implements Serializable {
    protected String host;
    private ServerStartupDaemon ssd_ref;
    private String object_string;
    private boolean reconnect = false;

    public ImRHostInfo(HostInfo host) {
        this.host = host.name;
        this.ssd_ref = host.ssd_ref;
        this.object_string = host.ior_string;
    }

    public HostInfo toHostInfo() {
        return new HostInfo(this.host, null, this.object_string);
    }

    public void startServer(String command, ORB orb) throws ServerStartupFailed {
        if (this.reconnect) {
            this.ssd_ref = ServerStartupDaemonHelper.narrow(orb.string_to_object(this.object_string));
        }
        this.ssd_ref.start_server(command);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.reconnect = true;
        out.defaultWriteObject();
    }
}

