/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.registry;

import java.util.Iterator;
import java.util.Map;
import javax.emb.FormatAlreadyBoundException;
import javax.emb.FormatNotFoundException;
import javax.emb.MediaFormat;
import org.jboss.media.util.registry.MapRegistry;
import org.jboss.media.util.registry.ObjectAlreadyBoundException;
import org.jboss.media.util.registry.ObjectNotBoundException;
import org.jboss.media.util.registry.Registry;

public class SimpleMediaFormatRegistry {
    private final Registry registry;

    public SimpleMediaFormatRegistry() {
        this.registry = new MapRegistry();
    }

    public SimpleMediaFormatRegistry(Map initialEntries) throws FormatAlreadyBoundException {
        try {
            this.registry = new MapRegistry(initialEntries);
        }
        catch (ObjectAlreadyBoundException e) {
            throw new FormatAlreadyBoundException();
        }
    }

    public void bind(String fileExtension, MediaFormat mediaFormat) throws FormatAlreadyBoundException {
        try {
            this.registry.bind(fileExtension, mediaFormat);
        }
        catch (ObjectAlreadyBoundException e) {
            throw new FormatAlreadyBoundException();
        }
    }

    public void rebind(String fileExtension, MediaFormat mediaFormat) {
        this.registry.rebind(fileExtension, mediaFormat);
    }

    public void unbind(String fileExtension) throws FormatNotFoundException {
        try {
            this.registry.unbind(fileExtension);
        }
        catch (ObjectNotBoundException e) {
            throw new FormatNotFoundException();
        }
    }

    public MediaFormat lookup(String fileExtension) throws FormatNotFoundException {
        try {
            return (MediaFormat)this.registry.lookup(fileExtension);
        }
        catch (ObjectNotBoundException e) {
            throw new FormatNotFoundException();
        }
    }

    public Iterator fileExtensions() {
        return this.registry.keyIterator();
    }
}

