/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.format.image.iio;

import javax.imageio.metadata.IIOMetadata;
import org.jboss.media.format.image.iio.IIOMediaHeader;

public class PNGMediaHeader
extends IIOMediaHeader {
    private static final long serialVersionUID = 0L;
    private static final String PNG_METADATA_FORMAT_NAME = "javax_imageio_png_1.0";
    private static final String[] FIELD_NAMES = new String[]{"width", "height", "bitDepth", "colorType", "compressionMethod", "filterMethod", "interlaceMethod"};
    private static final String IHDR = "IHDR";

    public PNGMediaHeader(IIOMetadata imageMetadata) {
        super(imageMetadata, PNG_METADATA_FORMAT_NAME);
    }

    public String[] getFieldNames() {
        return FIELD_NAMES;
    }

    public Object getField(String fieldname) {
        Object field = null;
        if (fieldname.equals("width")) {
            field = new Integer(this.getWidth());
        }
        if (fieldname.equals("height")) {
            field = new Integer(this.getHeight());
        }
        if (fieldname.equals("bitDepth")) {
            field = this.getBitDepth();
        }
        if (fieldname.equals("colorType")) {
            field = this.getColorType();
        }
        if (fieldname.equals("compressionMethod")) {
            field = this.getCompressionMethod();
        }
        if (fieldname.equals("filterMethod")) {
            field = this.getFilterMethod();
        }
        if (fieldname.equals("interlaceMethod")) {
            field = this.getInterlaceMethod();
        }
        return field;
    }

    public int getWidth() {
        String width = this.getAttribute(IHDR, "width");
        return Integer.parseInt(width);
    }

    public int getHeight() {
        String height = this.getAttribute(IHDR, "height");
        return Integer.parseInt(height);
    }

    public String getBitDepth() {
        return this.getAttribute(IHDR, "bitDepth");
    }

    public String getColorType() {
        return this.getAttribute(IHDR, "colorType");
    }

    public String getCompressionMethod() {
        return this.getAttribute(IHDR, "compressionMethod");
    }

    public String getFilterMethod() {
        return this.getAttribute(IHDR, "filterMethod");
    }

    public String getInterlaceMethod() {
        return this.getAttribute(IHDR, "interlaceMethod");
    }

    public int getGamma() {
        String gamma = this.getAttribute("gAMA", "value");
        return Integer.parseInt(gamma);
    }

    public int getPixelsPerUnitXAxis() {
        String pixelsPerUnitXAxis = this.getAttribute("pHYS", "pixelsPerUnitXAxis");
        return Integer.parseInt(pixelsPerUnitXAxis);
    }

    public int getPixelsPerUnitYAxis() {
        String pixelsPerUnitYAxis = this.getAttribute("pHYS", "pixelsPerUnitYAxis");
        return Integer.parseInt(pixelsPerUnitYAxis);
    }

    public String getPixelsPerUnitSpecifier() {
        return this.getAttribute("pHYS", "unitSpecifier");
    }
}

