/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.format.image.iio;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.emb.MediaException;
import javax.emb.MediaHeader;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileCacheImageInputStream;
import javax.imageio.stream.ImageInputStream;
import org.jboss.media.format.EmbeddedMediaFormat;

public abstract class IIOMediaFormat
extends EmbeddedMediaFormat {
    protected ImageReader imageReader;

    public IIOMediaFormat(ImageReader imageReader) {
        this.imageReader = imageReader;
    }

    public abstract MediaHeader extractHeader(InputStream var1) throws MediaException;

    public String getDefaultMimeType() {
        try {
            return "image/" + this.imageReader.getFormatName();
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isStreamingDesirable() {
        return false;
    }

    protected IIOMetadata extractImageMetadata(InputStream content) throws MediaException {
        ImageInputStream imageInputStream = null;
        try {
            IIOMetadata imageMetadata;
            imageInputStream = new FileCacheImageInputStream(content, null);
            this.imageReader.setInput(imageInputStream);
            IIOMetadata iIOMetadata = imageMetadata = this.imageReader.getImageMetadata(0);
            return iIOMetadata;
        }
        catch (RemoteException re) {
            throw new RuntimeException(re.getMessage());
        }
        catch (IOException ioe) {
            throw new MediaException(ioe.getMessage());
        }
        finally {
            try {
                imageInputStream.close();
                content.close();
            }
            catch (IOException ignore) {}
        }
    }
}

