/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.format.audio.mpeg;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.emb.FormatSyntaxException;
import javax.emb.MediaException;
import javax.emb.MediaHeader;
import org.jboss.media.format.audio.mpeg.ID3Tag;
import org.jboss.media.format.audio.mpeg.MpegAudioFormat;

public class MpegAudioHeader
implements MediaHeader {
    private static final int[] v1L1BitRates = new int[]{0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448};
    private static final int[] v1L2BitRates = new int[]{0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384};
    private static final int[] v1L3BitRates = new int[]{0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320};
    private static final int[] v2L1BitRates = new int[]{0, 32, 48, 56, 64, 80, 96, 112, 128, 411, 460, 476, 192, 224, 256};
    private static final int[] v2L23BitRates = new int[]{0, 8, 16, 24, 32, 40, 28, 56, 64, 80, 96, 112, 128, 144, 160};
    private static final int[] v1SampleRates = new int[]{44100, 48000, 32000};
    private static final int[] v2SampleRates = new int[]{22050, 24000, 16000};
    private static final int[] v25SampleRates = new int[]{11025, 12000, 8000};
    private static final String VERSION_KEY = "version";
    private static final String LAYER_KEY = "layer";
    private static final String BITRATE_KEY = "bitRate";
    private static final String SAMPLERATE_KEY = "samplingRate";
    private static final String CHANNELMODE_KEY = "channelMode";
    private static final String COPYRIGHT_KEY = "copyright";
    private static final String ORGINAL_KEY = "original";
    private final Map fieldMap = new HashMap(7);
    private final PushbackInputStream content;

    public MpegAudioHeader(InputStream data) throws MediaException, FormatSyntaxException {
        try {
            this.content = new PushbackInputStream(data, 4);
            int headerPos = this.findHeaderStart(this.content, 0);
            if (headerPos == -1) {
                throw new FormatSyntaxException("MPEG Audio header could not be found; this is not valid MPEG Audio data");
            }
            byte[] header = new byte[4];
            this.content.read(header);
            this.readHeader(header);
        }
        catch (IOException ex) {
            throw new MediaException(ex.getMessage());
        }
    }

    public int getBitrate() {
        return (Integer)this.fieldMap.get(BITRATE_KEY);
    }

    public MpegAudioFormat.ChannelMode getChannelMode() {
        return (MpegAudioFormat.ChannelMode)this.fieldMap.get(CHANNELMODE_KEY);
    }

    public boolean isCopyright() {
        return (Boolean)this.fieldMap.get(COPYRIGHT_KEY);
    }

    public MpegAudioFormat.Layer getLayer() {
        return (MpegAudioFormat.Layer)this.fieldMap.get(LAYER_KEY);
    }

    public boolean isOriginal() {
        return (Boolean)this.fieldMap.get(ORGINAL_KEY);
    }

    public int getSamplerate() {
        return (Integer)this.fieldMap.get(SAMPLERATE_KEY);
    }

    public MpegAudioFormat.Version getVersion() {
        return (MpegAudioFormat.Version)this.fieldMap.get(VERSION_KEY);
    }

    public String[] getFieldNames() {
        return this.fieldMap.keySet().toArray(new String[0]);
    }

    public Object getField(String fieldname) {
        return this.fieldMap.get(fieldname);
    }

    private int findHeaderStart(PushbackInputStream content, int offset) throws MediaException {
        try {
            if (offset == 0) {
                byte[] id3 = new byte[4];
                content.read(id3);
                String id3Test = new String(id3);
                content.unread(id3);
                if (id3Test.equals("ID3")) {
                    ID3Tag id3Tag = new ID3Tag(content);
                    offset += id3Tag.getSize();
                }
            }
            byte[] headerTest = new byte[2];
            while (content.read(headerTest) != -1) {
                if ((headerTest[0] & 0xFF) == 255 && (headerTest[1] & 0xE0) == 224) {
                    content.unread(headerTest);
                    return offset;
                }
                content.unread(headerTest[1]);
                ++offset;
            }
        }
        catch (IOException e) {
            throw new MediaException((Throwable)e);
        }
        return -1;
    }

    private void readHeader(byte[] header) throws FormatSyntaxException {
        if (header.length < 4) {
            throw new IllegalArgumentException("Not enough header data");
        }
        this.fieldMap.put(VERSION_KEY, this.getVersion(header[1]));
        this.fieldMap.put(LAYER_KEY, this.getLayer(header[1]));
        this.fieldMap.put(BITRATE_KEY, new Integer(this.getBitrate(header[2])));
        this.fieldMap.put(SAMPLERATE_KEY, new Integer(this.getSampleRate(header[2])));
        this.fieldMap.put(CHANNELMODE_KEY, this.getChannelMode(header[3]));
        this.fieldMap.put(COPYRIGHT_KEY, new Boolean(this.getCopyright(header[3])));
        this.fieldMap.put(ORGINAL_KEY, new Boolean(this.getOriginal(header[3])));
    }

    private MpegAudioFormat.Version getVersion(byte versionByte) throws FormatSyntaxException {
        switch (versionByte & 0x18) {
            case 0: {
                return MpegAudioFormat.Version.MPEG25;
            }
            case 16: {
                return MpegAudioFormat.Version.MPEG2;
            }
            case 24: {
                return MpegAudioFormat.Version.MPEG1;
            }
        }
        throw new FormatSyntaxException("Could not determine MPEG Audio version");
    }

    private MpegAudioFormat.Layer getLayer(byte layerByte) throws FormatSyntaxException {
        switch (layerByte & 6) {
            case 2: {
                return MpegAudioFormat.Layer.LAYERIII;
            }
            case 4: {
                return MpegAudioFormat.Layer.LAYERII;
            }
            case 6: {
                return MpegAudioFormat.Layer.LAYERI;
            }
        }
        throw new FormatSyntaxException("Could not determine MPEG Audio version");
    }

    private boolean getCRC(byte crcByte) {
        return (crcByte & 1) == 0;
    }

    private int getBitrate(byte bitrateByte) throws FormatSyntaxException {
        int bitrateKey = (bitrateByte & 0xF0) >>> 4;
        if (15 == bitrateKey) {
            throw new FormatSyntaxException("Illegal bitrate specified");
        }
        if (MpegAudioFormat.Version.MPEG1 == this.getVersion()) {
            if (MpegAudioFormat.Layer.LAYERI == this.getLayer()) {
                return v1L1BitRates[bitrateKey];
            }
            if (MpegAudioFormat.Layer.LAYERII == this.getLayer()) {
                return v1L2BitRates[bitrateKey];
            }
            if (MpegAudioFormat.Layer.LAYERIII == this.getLayer()) {
                return v1L3BitRates[bitrateKey];
            }
        }
        if (MpegAudioFormat.Version.MPEG2 == this.getVersion() || MpegAudioFormat.Version.MPEG25 == this.getVersion()) {
            if (MpegAudioFormat.Layer.LAYERI == this.getLayer()) {
                return v2L1BitRates[bitrateKey];
            }
            if (MpegAudioFormat.Layer.LAYERII == this.getLayer() || MpegAudioFormat.Layer.LAYERIII == this.getLayer()) {
                return v2L23BitRates[bitrateKey];
            }
        }
        throw new IllegalStateException("Version and layer must be determined before extracting bitrate");
    }

    private int getSampleRate(byte samplerateByte) throws FormatSyntaxException {
        int samplerateKey = (samplerateByte & 0xC) >>> 2;
        if (samplerateKey > 2) {
            throw new FormatSyntaxException("Illegal sampling rate specified");
        }
        if (MpegAudioFormat.Version.MPEG1 == this.getVersion()) {
            return v1SampleRates[samplerateKey];
        }
        if (MpegAudioFormat.Version.MPEG2 == this.getVersion()) {
            return v2SampleRates[samplerateKey];
        }
        if (MpegAudioFormat.Version.MPEG25 == this.getVersion()) {
            return v25SampleRates[samplerateKey];
        }
        throw new IllegalStateException("Version must be determined before extracting sample rate");
    }

    private MpegAudioFormat.ChannelMode getChannelMode(byte channelModeByte) throws FormatSyntaxException {
        switch (channelModeByte & 0xC0) {
            case 0: {
                return MpegAudioFormat.ChannelMode.STEREO;
            }
            case 64: {
                return MpegAudioFormat.ChannelMode.JOINT_STEREO;
            }
            case 128: {
                return MpegAudioFormat.ChannelMode.DUAL_CHANNEL;
            }
            case 192: {
                return MpegAudioFormat.ChannelMode.SINGLE_CHANNEL;
            }
        }
        throw new FormatSyntaxException("Illegal Channel Mode encountered");
    }

    private boolean getCopyright(byte copyrightByte) {
        return (copyrightByte & 8) != 0;
    }

    private boolean getOriginal(byte originalByte) {
        return (originalByte & 4) != 0;
    }
}

