/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media.format.audio.mpeg;

import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import javax.emb.MediaException;

class ID3Tag {
    private int size = 0;
    private boolean unsynchronisation;
    private boolean extendedHeader;
    private boolean experimentalHeader;
    private boolean footerPresent;
    private byte versionMajor = 0;
    private byte versionMinor = 0;

    public ID3Tag(InputStream content) throws MediaException, RemoteException {
        try {
            int offset = 3;
            content.read(new byte[6]);
            byte[] tagSize = new byte[4];
            content.read(tagSize);
            this.size = this.convertSynchsafeInt(tagSize);
            byte[] tagData = new byte[this.size];
            content.read(tagData);
            this.versionMajor = tagData[offset++];
            this.versionMinor = tagData[offset++];
            byte flags = tagData[offset++];
            this.unsynchronisation = (flags & 0x80) > 0;
            this.extendedHeader = (flags & 0x40) > 0;
            this.experimentalHeader = (flags & 0x20) > 0;
            this.footerPresent = (flags & 0x10) > 0;
        }
        catch (IOException e) {
            throw new MediaException((Throwable)e);
        }
    }

    public int getSize() {
        return this.size;
    }

    private int convertSynchsafeInt(byte[] data) {
        if (data.length < 4) {
            throw new IllegalArgumentException("Synchsafe integer must be 4 bytes long");
        }
        return this.convertSynchsafeInt(data[0], data[1], data[2], data[3]);
    }

    private int convertSynchsafeInt(byte msb, byte b3, byte b2, byte lsb) {
        return (msb << 23) + (b3 << 15) + (b2 << 7) + lsb;
    }
}

