/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.media;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import javax.emb.ContentAccessException;
import javax.emb.Media;
import javax.emb.MediaException;
import javax.emb.MediaFormat;
import javax.emb.MediaFormatRegistry;
import javax.emb.MediaHeader;
import org.jboss.media.util.ByteBufferUtils;

public class NIOMediaBean
implements Media {
    private String name;
    private String mimeType;
    private ByteBuffer byteBuffer;
    private long size;

    public NIOMediaBean(InputStream contentStream, String mimeType, String name) throws MediaException {
        if (contentStream == null || name == null) {
            throw new NullPointerException();
        }
        if (mimeType == null) {
            mimeType = this.getFormat().getDefaultMimeType();
        } else {
            this.mimeType = mimeType;
        }
        this.name = name;
        ReadableByteChannel byteChannel = Channels.newChannel(contentStream);
        try {
            this.size = byteChannel.read(this.byteBuffer);
        }
        catch (IOException e) {
            throw new ContentAccessException(e.getMessage());
        }
        finally {
            try {
                contentStream.close();
            }
            catch (IOException exception) {}
        }
    }

    public NIOMediaBean(File mediaFile, String mimeType) throws MediaException {
        try {
            FileChannel fileChannel = new FileInputStream(mediaFile).getChannel();
            this.size = fileChannel.size();
            this.byteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, (int)this.size);
        }
        catch (IOException e) {
            throw new ContentAccessException(e.getMessage());
        }
    }

    public byte[] getContent() throws MediaException {
        return this.byteBuffer.array();
    }

    public int readContent(long position, byte[] buffer) throws MediaException {
        return this.readContent(position, buffer, 0, buffer.length);
    }

    public int readContent(long position, byte[] buffer, int offset, int length) throws MediaException {
        this.byteBuffer.get(buffer, offset, length);
        return buffer.length;
    }

    public MediaFormat getFormat() throws MediaException {
        String fileExtension = NIOMediaBean.getFileExtension(this.name);
        if (fileExtension != null) {
            return MediaFormatRegistry.SINGLETON.lookup(fileExtension);
        }
        return null;
    }

    public MediaHeader getHeader() throws MediaException {
        ByteArrayInputStream content = new ByteArrayInputStream(this.getContent());
        return this.getFormat().extractHeader((InputStream)content);
    }

    public String getMimeType() throws MediaException {
        return this.mimeType;
    }

    public String getName() throws MediaException {
        return this.name;
    }

    public long getSize() throws MediaException {
        return this.size;
    }

    public Media getProxy() throws MediaException {
        ByteArrayInputStream content = new ByteArrayInputStream(this.getContent());
        return this.getFormat().extractProxy((InputStream)content);
    }

    private static String getFileName(String fileName) {
        int lastDotPosition = fileName.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return fileName;
        }
        return fileName.substring(0, lastDotPosition);
    }

    private static String getFileExtension(String fileName) {
        int lastDotPosition = fileName.lastIndexOf(46);
        if (lastDotPosition == -1) {
            return null;
        }
        return fileName.substring(lastDotPosition + 1);
    }

    private InputStream getContentStream() throws MediaException {
        return ByteBufferUtils.newInputStream(this.byteBuffer);
    }
}

