/*
 * Decompiled with CFR 0.152.
 */
package javax.management.monitor;

import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.monitor.CounterMonitorMBean;
import javax.management.monitor.Monitor;
import javax.management.monitor.MonitorNotification;
import javax.management.monitor.MonitorSettingException;

public class CounterMonitor
extends Monitor
implements CounterMonitorMBean {
    private Number[] threshold = new Number[16];
    private Number modulus = new Integer(0);
    private Number offset = new Integer(0);
    private boolean notify = false;
    private boolean differenceMode = false;
    private transient Number initThreshold = new Integer(0);
    private transient Number[] derivedGauge = new Number[16];
    private transient long[] derivedGaugeTimestamp = new long[16];
    private transient Number[] previousScanCounter = new Number[16];
    private transient boolean[] modulusExceeded = new boolean[16];
    private transient Number[] derivedGaugeExceeded = new Number[16];
    private transient boolean[] eventAlreadyNotified = new boolean[16];
    private transient int[] type = new int[16];
    private static final int INTEGER = 0;
    private static final int BYTE = 1;
    private static final int SHORT = 2;
    private static final int LONG = 3;
    private static final int THRESHOLD_ERROR_NOTIFIED = 16;
    private transient Timer timer = null;

    String makeDebugTag() {
        return "CounterMonitor";
    }

    public CounterMonitor() {
        this.dbgTag = this.makeDebugTag();
    }

    public void preDeregister() throws Exception {
        super.preDeregister();
        if (this.isTraceOn()) {
            this.trace("preDeregister", "reset the threshold values");
        }
        int n = 0;
        while (n < this.elementCount) {
            this.threshold[n] = this.initThreshold;
            ++n;
        }
    }

    public synchronized void start() {
        if (this.isTraceOn()) {
            this.trace("start", "start the counter monitor");
        }
        if (!this.isActive()) {
            this.isActive = true;
            int n = 0;
            while (n < this.elementCount) {
                this.threshold[n] = this.initThreshold;
                this.modulusExceeded[n] = false;
                this.eventAlreadyNotified[n] = false;
                this.previousScanCounter[n] = null;
                ++n;
            }
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        } else if (this.isTraceOn()) {
            this.trace("start", "the counter monitor is already activated");
        }
    }

    public void stop() {
        if (this.isTraceOn()) {
            this.trace("stop", "stop the counter monitor");
        }
        if (this.isActive()) {
            if (this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.isActive = false;
        } else if (this.isTraceOn()) {
            this.trace("stop", "the counter monitor is already deactivated");
        }
    }

    public synchronized void setGranularityPeriod(long l) throws IllegalArgumentException {
        super.setGranularityPeriod(l);
        if (this.isActive()) {
            this.timer.cancel();
            this.timer = new Timer();
            this.timer.schedule((TimerTask)new CounterAlarmClock(this), this.getGranularityPeriod(), this.getGranularityPeriod());
        }
    }

    public Number getDerivedGauge(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGauge[n];
        }
        return null;
    }

    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.derivedGaugeTimestamp[n];
        }
        return 0L;
    }

    public Number getThreshold(ObjectName objectName) {
        int n = this.indexOf(objectName);
        if (n != -1) {
            return this.threshold[n];
        }
        return null;
    }

    public Number getInitThreshold() {
        return this.initThreshold;
    }

    public void setInitThreshold(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The threshold cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The threshold must be greater than or equal to zero.");
        }
        this.initThreshold = number;
        int n = 0;
        while (n < this.elementCount) {
            this.threshold[n] = number;
            this.resetAlreadyNotified(n, 16);
            this.modulusExceeded[n] = false;
            this.eventAlreadyNotified[n] = false;
            ++n;
        }
    }

    public synchronized Number getDerivedGauge() {
        return this.derivedGauge[0];
    }

    public synchronized long getDerivedGaugeTimeStamp() {
        return this.derivedGaugeTimestamp[0];
    }

    public synchronized Number getThreshold() {
        return this.threshold[0];
    }

    public synchronized void setThreshold(Number number) throws IllegalArgumentException {
        this.setInitThreshold(number);
    }

    public synchronized Number getOffset() {
        return this.offset;
    }

    public synchronized void setOffset(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The offset cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The offset must be greater than or equal to zero.");
        }
        this.offset = number;
        int n = 0;
        while (n < this.elementCount) {
            this.resetAlreadyNotified(n, 16);
            ++n;
        }
    }

    public synchronized Number getModulus() {
        return this.modulus;
    }

    public synchronized void setModulus(Number number) throws IllegalArgumentException {
        if (number == null) {
            throw new IllegalArgumentException("The modulus cannot be null.");
        }
        if (number.longValue() < 0L) {
            throw new IllegalArgumentException("The modulus must be greater than or equal to zero.");
        }
        this.modulus = number;
        int n = 0;
        while (n < this.elementCount) {
            this.resetAlreadyNotified(n, 16);
            this.modulusExceeded[n] = false;
            ++n;
        }
    }

    public synchronized boolean getNotify() {
        return this.notify;
    }

    public synchronized void setNotify(boolean bl) {
        this.notify = bl;
    }

    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public synchronized void setDifferenceMode(boolean bl) {
        this.differenceMode = bl;
        int n = 0;
        while (n < this.elementCount) {
            this.threshold[n] = this.initThreshold;
            this.modulusExceeded[n] = false;
            this.eventAlreadyNotified[n] = false;
            this.previousScanCounter[n] = null;
            ++n;
        }
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] stringArray = new String[]{MonitorNotification.RUNTIME_ERROR, MonitorNotification.OBSERVED_OBJECT_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_ERROR, MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR, MonitorNotification.THRESHOLD_ERROR, MonitorNotification.THRESHOLD_VALUE_EXCEEDED};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[]{new MBeanNotificationInfo(stringArray, "javax.management.monitor.MonitorNotification", "Notifications sent by the CounterMonitor MBean")};
        return mBeanNotificationInfoArray;
    }

    private boolean updateDerivedGauge(Object object, int n) {
        boolean bl;
        this.derivedGaugeTimestamp[n] = System.currentTimeMillis();
        if (this.differenceMode) {
            if (this.previousScanCounter[n] != null) {
                this.setDerivedGaugeWithDifference((Number)object, null, n);
                if (this.derivedGauge[n].longValue() < 0L) {
                    if (this.modulus.longValue() > 0L) {
                        this.setDerivedGaugeWithDifference((Number)object, this.modulus, n);
                    }
                    this.threshold[n] = this.initThreshold;
                    this.eventAlreadyNotified[n] = false;
                }
                bl = true;
            } else {
                bl = false;
            }
            this.previousScanCounter[n] = (Number)object;
        } else {
            this.derivedGauge[n] = (Number)object;
            bl = true;
        }
        return bl;
    }

    private void updateNotifications(int n) {
        if (!this.eventAlreadyNotified[n]) {
            if (this.derivedGauge[n].longValue() >= this.threshold[n].longValue()) {
                if (this.notify) {
                    this.sendNotification(MonitorNotification.THRESHOLD_VALUE_EXCEEDED, this.derivedGaugeTimestamp[n], "", this.derivedGauge[n], this.threshold[n], n);
                }
                this.eventAlreadyNotified[n] = true;
            }
        } else if (this.isTraceOn()) {
            this.trace("updateNotifications", "the notification:\n\tNotification observed object = " + this.getObservedObject(n) + "\n\tNotification observed attribute = " + this.getObservedAttribute() + "\n\tNotification derived gauge = " + this.derivedGauge[n] + "has already been sent");
        }
    }

    private void updateThreshold(int n) {
        if (this.derivedGauge[n].longValue() >= this.threshold[n].longValue()) {
            if (this.offset.longValue() > 0L) {
                long l = this.threshold[n].longValue();
                while (this.derivedGauge[n].longValue() >= l) {
                    l += this.offset.longValue();
                }
                switch (this.type[n]) {
                    case 0: {
                        this.threshold[n] = new Integer((int)l);
                        break;
                    }
                    case 1: {
                        this.threshold[n] = new Byte((byte)l);
                        break;
                    }
                    case 2: {
                        this.threshold[n] = new Short((short)l);
                        break;
                    }
                    case 3: {
                        this.threshold[n] = new Long(l);
                        break;
                    }
                    default: {
                        if (!this.isDebugOn()) break;
                        this.debug("updateThreshold", "the threshold type is invalid");
                    }
                }
                if (!this.differenceMode && this.modulus.longValue() > 0L && this.threshold[n].longValue() > this.modulus.longValue()) {
                    this.modulusExceeded[n] = true;
                    this.derivedGaugeExceeded[n] = this.derivedGauge[n];
                }
                this.eventAlreadyNotified[n] = false;
            } else {
                this.modulusExceeded[n] = true;
                this.derivedGaugeExceeded[n] = this.derivedGauge[n];
            }
        }
    }

    private boolean isThresholdTypeValid(int n) {
        boolean bl = false;
        switch (this.type[n]) {
            case 0: {
                if (!(this.threshold[n] instanceof Integer) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Integer) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Integer)) break;
                bl = true;
                break;
            }
            case 1: {
                if (!(this.threshold[n] instanceof Byte) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Byte) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Byte)) break;
                bl = true;
                break;
            }
            case 2: {
                if (!(this.threshold[n] instanceof Short) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Short) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Short)) break;
                bl = true;
                break;
            }
            case 3: {
                if (!(this.threshold[n] instanceof Long) || !this.offset.equals(new Integer(0)) && !(this.offset instanceof Long) || !this.modulus.equals(new Integer(0)) && !(this.modulus instanceof Long)) break;
                bl = true;
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("isThresholdTypeValid", "the threshold type is invalid");
            }
        }
        return bl;
    }

    private void setDerivedGaugeWithDifference(Number number, Number number2, int n) {
        switch (this.type[n]) {
            case 0: {
                if (number2 == null) {
                    this.derivedGauge[n] = new Integer((Integer)number - (Integer)this.previousScanCounter[n]);
                    break;
                }
                this.derivedGauge[n] = new Integer((Integer)number - (Integer)this.previousScanCounter[n] + (Integer)this.modulus);
                break;
            }
            case 1: {
                if (number2 == null) {
                    this.derivedGauge[n] = new Byte((byte)((Byte)number - (Byte)this.previousScanCounter[n]));
                    break;
                }
                this.derivedGauge[n] = new Byte((byte)((Byte)number - (Byte)this.previousScanCounter[n] + (Byte)this.modulus));
                break;
            }
            case 2: {
                if (number2 == null) {
                    this.derivedGauge[n] = new Short((short)((Short)number - (Short)this.previousScanCounter[n]));
                    break;
                }
                this.derivedGauge[n] = new Short((short)((Short)number - (Short)this.previousScanCounter[n] + (Short)this.modulus));
                break;
            }
            case 3: {
                if (number2 == null) {
                    this.derivedGauge[n] = new Long((Long)number - (Long)this.previousScanCounter[n]);
                    break;
                }
                this.derivedGauge[n] = new Long((Long)number - (Long)this.previousScanCounter[n] + (Long)this.modulus);
                break;
            }
            default: {
                if (!this.isDebugOn()) break;
                this.debug("setDerivedGaugeWithDifference", "the threshold type is invalid");
            }
        }
    }

    void notifyAlarmClock(int n) {
        block28: {
            Object object = null;
            String string = null;
            try {
                boolean bl;
                if (!this.isActive()) break block28;
                if (this.getObservedObject(n) == null || this.getObservedAttribute() == null) {
                    return;
                }
                try {
                    object = this.server.getAttribute(this.getObservedObject(n), this.getObservedAttribute());
                    if (object == null) {
                        return;
                    }
                }
                catch (NullPointerException nullPointerException) {
                    if ((this.alreadyNotifieds[n] & 8) != 0) {
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(n, 8);
                    throw new MonitorSettingException("The counter monitor must be registered in the MBean server.");
                }
                catch (InstanceNotFoundException instanceNotFoundException) {
                    if ((this.alreadyNotifieds[n] & 1) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_OBJECT_ERROR;
                    this.setAlreadyNotified(n, 1);
                    throw new MonitorSettingException("The observed object must be registered in the MBean server.");
                }
                catch (AttributeNotFoundException attributeNotFoundException) {
                    if ((this.alreadyNotifieds[n] & 2) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(n, 2);
                    throw new MonitorSettingException("The observed attribute must be accessible in the observed object.");
                }
                catch (MBeanException mBeanException) {
                    if ((this.alreadyNotifieds[n] & 8) != 0) {
                        return;
                    }
                    string = MonitorNotification.RUNTIME_ERROR;
                    this.setAlreadyNotified(n, 8);
                    throw new MonitorSettingException(mBeanException.getMessage());
                }
                catch (ReflectionException reflectionException) {
                    if ((this.alreadyNotifieds[n] & 2) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_ERROR;
                    this.setAlreadyNotified(n, 2);
                    throw new MonitorSettingException(reflectionException.getMessage());
                }
                if (object instanceof Integer) {
                    this.type[n] = 0;
                } else if (object instanceof Byte) {
                    this.type[n] = 1;
                } else if (object instanceof Short) {
                    this.type[n] = 2;
                } else if (object instanceof Long) {
                    this.type[n] = 3;
                } else {
                    if ((this.alreadyNotifieds[n] & 4) != 0) {
                        return;
                    }
                    string = MonitorNotification.OBSERVED_ATTRIBUTE_TYPE_ERROR;
                    this.setAlreadyNotified(n, 4);
                    throw new MonitorSettingException("The observed attribute type must be an integer type.");
                }
                if (!this.isThresholdTypeValid(n)) {
                    if ((this.alreadyNotifieds[n] & 0x10) != 0) {
                        return;
                    }
                    string = MonitorNotification.THRESHOLD_ERROR;
                    this.setAlreadyNotified(n, 16);
                    throw new MonitorSettingException("The threshold, offset and modulus must be of the same type as the counter.");
                }
                this.resetAllAlreadyNotified(n);
                if (this.modulusExceeded[n] && this.derivedGauge[n].longValue() < this.derivedGaugeExceeded[n].longValue()) {
                    this.threshold[n] = this.initThreshold;
                    this.modulusExceeded[n] = false;
                    this.eventAlreadyNotified[n] = false;
                }
                if (bl = this.updateDerivedGauge(object, n)) {
                    this.updateNotifications(n);
                    this.updateThreshold(n);
                }
            }
            catch (MonitorSettingException monitorSettingException) {
                this.sendNotification(string, this.derivedGaugeTimestamp[n], monitorSettingException.getMessage(), this.derivedGauge[n], null, n);
                this.modulusExceeded[n] = false;
                this.eventAlreadyNotified[n] = false;
                this.previousScanCounter[n] = null;
            }
        }
    }

    void insertSpecificElementAt(int n) {
        Integer n2 = new Integer(0);
        this.insertNumberElementAt(this.threshold, n2, n);
        this.insertNumberElementAt(this.derivedGauge, n2, n);
        this.insertNumberElementAt(this.previousScanCounter, null, n);
        this.insertNumberElementAt(this.derivedGaugeExceeded, null, n);
        this.insertlongElementAt(this.derivedGaugeTimestamp, new Date().getTime(), n);
        this.insertbooleanElementAt(this.modulusExceeded, false, n);
        this.insertbooleanElementAt(this.eventAlreadyNotified, false, n);
        this.insertintElementAt(this.type, 0, n);
    }

    void removeSpecificElementAt(int n) {
        this.removeNumberElementAt(this.threshold, n);
        this.removeNumberElementAt(this.derivedGauge, n);
        this.removeNumberElementAt(this.previousScanCounter, n);
        this.removeNumberElementAt(this.derivedGaugeExceeded, n);
        this.removelongElementAt(this.derivedGaugeTimestamp, n);
        this.removebooleanElementAt(this.modulusExceeded, n);
        this.removebooleanElementAt(this.eventAlreadyNotified, n);
        this.removeintElementAt(this.type, n);
    }

    private static class CounterAlarmClock
    extends TimerTask {
        CounterMonitor listener = null;

        public CounterAlarmClock(CounterMonitor counterMonitor) {
            this.listener = counterMonitor;
        }

        public void run() {
            if (this.listener.isActive()) {
                int n = 0;
                while (n < this.listener.elementCount) {
                    this.listener.notifyAlarmClock(n);
                    ++n;
                }
            }
        }
    }
}

