/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jmx.interceptor;

import com.sun.jmx.interceptor.MBeanServerInterceptor;
import com.sun.jmx.mbeanserver.MBeanInstantiator;
import com.sun.jmx.mbeanserver.MetaData;
import com.sun.jmx.mbeanserver.MetaDataImpl;
import com.sun.jmx.mbeanserver.ModifiableClassLoaderRepository;
import com.sun.jmx.mbeanserver.NamedObject;
import com.sun.jmx.mbeanserver.Repository;
import com.sun.jmx.mbeanserver.RepositorySupport;
import com.sun.jmx.trace.Trace;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.InvalidAttributeValueException;
import javax.management.JMException;
import javax.management.JMRuntimeException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanPermission;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerNotification;
import javax.management.MBeanTrustPermission;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcaster;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryEval;
import javax.management.QueryExp;
import javax.management.ReflectionException;
import javax.management.RuntimeOperationsException;

public class DefaultMBeanServerInterceptor
implements MBeanServerInterceptor {
    private static final ObjectName _MBSDelegateObjectName;
    private final transient MBeanInstantiator instantiator;
    private transient MBeanServer server = null;
    private final transient MBeanServerDelegate delegate;
    private final transient MetaData meta;
    private final transient Repository repository;
    private final transient WeakHashMap listenerWrappers = new WeakHashMap();
    private final String domain;
    private boolean queryByRepo;
    private static final String dbgTag = "DefaultMBeanServerInterceptor";
    static /* synthetic */ Class class$javax$management$NotificationListener;
    static /* synthetic */ Class class$javax$management$NotificationBroadcaster;
    static /* synthetic */ Class class$javax$management$NotificationEmitter;

    public DefaultMBeanServerInterceptor(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, MBeanInstantiator mBeanInstantiator) {
        this(mBeanServer, mBeanServerDelegate, mBeanInstantiator, null, new RepositorySupport(string == null ? "DefaultDomain" : string));
    }

    public DefaultMBeanServerInterceptor(MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, MBeanInstantiator mBeanInstantiator, MetaData metaData, Repository repository) {
        if (mBeanServer == null) {
            throw new IllegalArgumentException("outer MBeanServer cannot be null");
        }
        if (mBeanServerDelegate == null) {
            throw new IllegalArgumentException("MBeanServerDelegate cannot be null");
        }
        if (mBeanInstantiator == null) {
            throw new IllegalArgumentException("MBeanInstantiator cannot be null");
        }
        if (metaData == null) {
            metaData = new MetaDataImpl(mBeanInstantiator);
        }
        if (repository == null) {
            repository = new RepositorySupport("DefaultDomain");
        }
        this.server = mBeanServer;
        this.delegate = mBeanServerDelegate;
        this.instantiator = mBeanInstantiator;
        this.meta = metaData;
        this.repository = repository;
        this.domain = repository.getDefaultDomain();
    }

    public ObjectInstance createMBean(String string, ObjectName objectName) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        return this.createMBean(string, objectName, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, null, null);
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException {
        try {
            return this.createMBean(string, objectName, null, true, objectArray, stringArray);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new IllegalArgumentException("Unexpected exception: " + instanceNotFoundException);
        }
    }

    public ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        return this.createMBean(string, objectName, objectName2, false, objectArray, stringArray);
    }

    private ObjectInstance createMBean(String string, ObjectName objectName, ObjectName objectName2, boolean bl, Object[] objectArray, String[] stringArray) throws ReflectionException, InstanceAlreadyExistsException, MBeanRegistrationException, MBeanException, NotCompliantMBeanException, InstanceNotFoundException {
        String string2;
        Class clazz;
        ObjectName objectName3 = objectName;
        if (string == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("The class name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured during MBean creation");
        }
        if (objectName != null) {
            if (objectName.isPattern()) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid name->" + objectName.toString());
                throw new RuntimeOperationsException(illegalArgumentException, "Exception occurred during MBean creation");
            }
            objectName = this.nonDefaultDomain(objectName);
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, null, "instantiate");
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "registerMBean");
        if (bl) {
            if (DefaultMBeanServerInterceptor.isTraceOn()) {
                DefaultMBeanServerInterceptor.trace(dbgTag, "createMBean", "ClassName = " + string + ",ObjectName = " + objectName);
            }
            clazz = this.instantiator.findClassWithDefaultLoaderRepository(string);
        } else if (objectName2 == null) {
            if (DefaultMBeanServerInterceptor.isTraceOn()) {
                DefaultMBeanServerInterceptor.trace(dbgTag, "createMBean", "ClassName = " + string + ",ObjectName = " + objectName + " Loader name = null");
            }
            clazz = this.instantiator.findClass(string, this.server.getClass().getClassLoader());
        } else {
            objectName2 = this.nonDefaultDomain(objectName2);
            if (DefaultMBeanServerInterceptor.isTraceOn()) {
                DefaultMBeanServerInterceptor.trace(dbgTag, "createMBean", "ClassName = " + string + ",ObjectName = " + objectName + ",Loader name = " + objectName2.toString());
            }
            clazz = this.instantiator.findClass(string, objectName2);
        }
        DefaultMBeanServerInterceptor.checkMBeanTrustPermission(clazz);
        this.instantiator.testCreation(clazz);
        this.meta.testCompliance(clazz);
        Object object = this.instantiator.instantiate(clazz, objectArray, stringArray, this.server.getClass().getClassLoader());
        try {
            string2 = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            throw new NotCompliantMBeanException(introspectionException.getMessage());
        }
        return this.registerCreatedObject(string2, object, objectName);
    }

    public ObjectInstance registerMBean(Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        String string;
        Class<?> clazz = object.getClass();
        this.meta.testCompliance(clazz);
        try {
            string = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            throw new NotCompliantMBeanException(introspectionException.getMessage());
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "registerMBean");
        DefaultMBeanServerInterceptor.checkMBeanTrustPermission(clazz);
        return this.registerObject(string, object, objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMBean(ObjectName objectName) throws InstanceNotFoundException, MBeanRegistrationException {
        Object object;
        if (objectName == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Object name cannot be null");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to unregister the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        Object object2 = this.getMBean(objectName);
        String string = null;
        try {
            string = this.meta.getMBeanClassName(object2);
        }
        catch (IntrospectionException introspectionException) {
            string = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "unregisterMBean");
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            ModifiableClassLoaderRepository modifiableClassLoaderRepository;
            object = this.repository.retrieve(objectName);
            if (object == null) {
                if (DefaultMBeanServerInterceptor.isTraceOn()) {
                    DefaultMBeanServerInterceptor.trace("unregisterMBean", objectName + ": Found no object");
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
            if (object instanceof MBeanRegistration) {
                this.meta.preDeregisterInvoker(object);
            }
            this.repository.remove(objectName);
            if (object instanceof ClassLoader && object != this.server.getClass().getClassLoader() && (modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository()) != null) {
                modifiableClassLoaderRepository.removeClassLoader(objectName);
            }
        }
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("unregisterMBean", "Send delete notification of object " + objectName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.unregistered", objectName);
        if (object instanceof MBeanRegistration) {
            this.meta.postDeregisterInvoker(object);
        }
    }

    public ObjectInstance getObjectInstance(ObjectName objectName) throws InstanceNotFoundException {
        String string;
        objectName = this.nonDefaultDomain(objectName);
        Object object = this.getMBean(objectName);
        try {
            string = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            DefaultMBeanServerInterceptor.debugX("getObjectInstance", introspectionException);
            throw new JMRuntimeException("Can't obtain class name for " + objectName + ": " + introspectionException);
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            DefaultMBeanServerInterceptor.debugX("getObjectInstance", notCompliantMBeanException);
            throw new JMRuntimeException("Can't obtain class name for " + objectName + ": " + notCompliantMBeanException);
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "getObjectInstance");
        return new ObjectInstance(objectName, string);
    }

    public Set queryMBeans(ObjectName objectName, QueryExp queryExp) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, null, "queryMBeans");
            Set set = this.queryMBeansImpl(objectName, null);
            HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    ObjectInstance objectInstance = (ObjectInstance)iterator.next();
                    DefaultMBeanServerInterceptor.checkMBeanPermission(objectInstance.getClassName(), null, objectInstance.getObjectName(), "queryMBeans");
                    hashSet.add(objectInstance);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return this.filterListOfObjectInstances(hashSet, queryExp);
        }
        return this.queryMBeansImpl(objectName, queryExp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set queryMBeansImpl(ObjectName objectName, QueryExp queryExp) {
        Set set = null;
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            set = this.repository.query(objectName, queryExp);
        }
        if (this.queryByRepo) {
            return set;
        }
        return this.filterListOfObjects(set, queryExp);
    }

    public Set queryNames(ObjectName objectName, QueryExp queryExp) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            Object object;
            DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, null, "queryNames");
            Set set = this.queryMBeansImpl(objectName, null);
            HashSet<Object> hashSet = new HashSet<Object>(set.size());
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                try {
                    object = (ObjectInstance)iterator.next();
                    DefaultMBeanServerInterceptor.checkMBeanPermission(((ObjectInstance)object).getClassName(), null, ((ObjectInstance)object).getObjectName(), "queryNames");
                    hashSet.add(object);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            object = this.filterListOfObjectInstances(hashSet, queryExp);
            HashSet<ObjectName> hashSet2 = new HashSet<ObjectName>(object.size());
            Iterator iterator2 = object.iterator();
            while (iterator2.hasNext()) {
                ObjectInstance objectInstance = (ObjectInstance)iterator2.next();
                hashSet2.add(objectInstance.getObjectName());
            }
            return hashSet2;
        }
        Set set = this.queryMBeansImpl(objectName, queryExp);
        HashSet<ObjectName> hashSet = new HashSet<ObjectName>(set.size());
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            hashSet.add(objectInstance.getObjectName());
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRegistered(ObjectName objectName) {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Object name cannot be null");
        }
        objectName = this.nonDefaultDomain(objectName);
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            boolean bl = this.repository.contains(objectName);
            return bl;
        }
    }

    public String[] getDomains() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, null, "getDomains");
            String[] stringArray = this.repository.getDomains();
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                try {
                    ObjectName objectName = new ObjectName(stringArray[n] + ":x=x");
                    DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, objectName, "getDomains");
                    arrayList.add(stringArray[n]);
                }
                catch (MalformedObjectNameException malformedObjectNameException) {
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                ++n;
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        return this.repository.getDomains();
    }

    public Integer getMBeanCount() {
        return this.repository.getCount();
    }

    public Object getAttribute(ObjectName objectName, String string) throws MBeanException, AttributeNotFoundException, InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (string == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("getAttribute", "Attribute= " + string + ", obj= " + objectName);
        }
        Object object = this.getMBean(objectName);
        String string2 = null;
        try {
            string2 = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            string2 = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string2 = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string2, string, objectName, "getAttribute");
        return this.meta.getAttribute(object, string);
    }

    public AttributeList getAttributes(ObjectName objectName, String[] stringArray) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        if (stringArray == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attributes cannot be null"), "Exception occured trying to invoke the getter on the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("getAttributes", "Object= " + objectName);
        }
        Object object = this.getMBean(objectName);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string = null;
            try {
                string = this.meta.getMBeanClassName(object);
            }
            catch (IntrospectionException introspectionException) {
                string = null;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                string = null;
            }
            DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "getAttribute");
            ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
            int n = 0;
            while (n < stringArray.length) {
                try {
                    DefaultMBeanServerInterceptor.checkMBeanPermission(string, stringArray[n], objectName, "getAttribute");
                    arrayList.add(stringArray[n]);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
                ++n;
            }
            String[] stringArray2 = arrayList.toArray(new String[0]);
            return this.meta.getAttributes(object, stringArray2);
        }
        return this.meta.getAttributes(object, stringArray);
    }

    public void setAttribute(ObjectName objectName, Attribute attribute) throws InstanceNotFoundException, AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attribute == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Attribute cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("setAttribute", "Object= " + objectName + ", attribute=" + attribute.getName());
        }
        Object object = this.getMBean(objectName);
        String string = null;
        try {
            string = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            string = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, attribute.getName(), objectName, "setAttribute");
        Object object2 = this.meta.setAttribute(object, attribute);
    }

    public AttributeList setAttributes(ObjectName objectName, AttributeList attributeList) throws InstanceNotFoundException, ReflectionException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("ObjectName name cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        if (attributeList == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("AttributeList  cannot be null"), "Exception occured trying to invoke the setter on the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        Object object = this.getMBean(objectName);
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            String string = null;
            try {
                string = this.meta.getMBeanClassName(object);
            }
            catch (IntrospectionException introspectionException) {
                string = null;
            }
            catch (NotCompliantMBeanException notCompliantMBeanException) {
                string = null;
            }
            DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "setAttribute");
            AttributeList attributeList2 = new AttributeList(attributeList.size());
            Iterator iterator = attributeList.iterator();
            while (iterator.hasNext()) {
                try {
                    Attribute attribute = (Attribute)iterator.next();
                    DefaultMBeanServerInterceptor.checkMBeanPermission(string, attribute.getName(), objectName, "setAttribute");
                    attributeList2.add(attribute);
                }
                catch (SecurityException securityException) {
                    // empty catch block
                }
            }
            return this.meta.setAttributes(object, attributeList2);
        }
        return this.meta.setAttributes(object, attributeList);
    }

    public Object invoke(ObjectName objectName, String string, Object[] objectArray, String[] stringArray) throws InstanceNotFoundException, MBeanException, ReflectionException {
        objectName = this.nonDefaultDomain(objectName);
        Object object = this.getMBean(objectName);
        String string2 = null;
        try {
            string2 = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            string2 = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string2 = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string2, string, objectName, "invoke");
        return this.meta.invoke(object, string, objectArray, stringArray);
    }

    protected MetaData meta() {
        return this.meta;
    }

    protected ObjectInstance makeObjectInstance(String string, Object object, ObjectName objectName) throws NotCompliantMBeanException {
        if (object instanceof DynamicMBean) {
            try {
                string = this.meta.getMBeanClassName(object);
            }
            catch (SecurityException securityException) {
                DefaultMBeanServerInterceptor.debugX("makeObjectInstance", securityException);
                throw securityException;
            }
            catch (IntrospectionException introspectionException) {
                DefaultMBeanServerInterceptor.debugX("makeObjectInstance", introspectionException);
                throw new NotCompliantMBeanException("Can't obtain class name for " + objectName + ": " + introspectionException);
            }
            catch (JMRuntimeException jMRuntimeException) {
                DefaultMBeanServerInterceptor.debugX("makeObjectInstance", jMRuntimeException);
                throw new NotCompliantMBeanException("Can't obtain class name for " + objectName + ": " + jMRuntimeException);
            }
        }
        if (string == null) {
            throw new NotCompliantMBeanException("The class Name returned is null");
        }
        return new ObjectInstance(this.nonDefaultDomain(objectName), string);
    }

    protected ObjectInstance registerObject(String string, Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        if (object == null) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Cannot add null object");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to register the MBean");
        }
        objectName = this.nonDefaultDomain(objectName);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace(dbgTag, "registerMBean", "ObjectName = " + objectName);
        }
        ObjectName objectName2 = objectName;
        if (object instanceof MBeanRegistration && (objectName2 = this.meta.preRegisterInvoker(object, objectName, this.server)) != objectName) {
            objectName2 = this.nonDefaultDomain(objectName2);
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName2, "registerMBean");
        if (objectName2 == null) {
            if (object instanceof MBeanRegistration) {
                this.meta.postRegisterInvoker(object, false);
            }
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException("No object name specified");
            throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to register the MBean");
        }
        ObjectInstance objectInstance = this.makeObjectInstance(string, object, objectName2);
        this.internal_addObject(object, objectName2);
        if (object instanceof MBeanRegistration) {
            this.meta.postRegisterInvoker(object, true);
        }
        if (object instanceof ClassLoader) {
            ModifiableClassLoaderRepository modifiableClassLoaderRepository = this.instantiator.getClassLoaderRepository();
            if (modifiableClassLoaderRepository == null) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Dynamic addition of class loaders is not supported");
                throw new RuntimeOperationsException(illegalArgumentException, "Exception occured trying to register the MBean as a class loader");
            }
            modifiableClassLoaderRepository.addClassLoader(objectName2, (ClassLoader)object);
        }
        return objectInstance;
    }

    protected ObjectInstance registerCreatedObject(String string, Object object, ObjectName objectName) throws InstanceAlreadyExistsException, MBeanRegistrationException, NotCompliantMBeanException {
        return this.registerObject(string, object, objectName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMBean(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Object name cannot be null"), "Exception occured trying to get an MBean");
        }
        Object object = null;
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            object = this.repository.retrieve(objectName);
            if (object == null) {
                if (DefaultMBeanServerInterceptor.isTraceOn()) {
                    DefaultMBeanServerInterceptor.trace("getMBean", objectName + ": Found no object");
                }
                throw new InstanceNotFoundException(objectName.toString());
            }
        }
        return object;
    }

    private ObjectName nonDefaultDomain(ObjectName objectName) {
        if (objectName == null || objectName.getDomain().length() > 0) {
            return objectName;
        }
        String string = this.domain + objectName;
        try {
            return new ObjectName(string);
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            String string2 = "Unexpected default domain problem: " + string + ": " + malformedObjectNameException;
            throw new IllegalArgumentException(string2);
        }
    }

    public String getDefaultDomain() {
        return this.domain;
    }

    public void addNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("addNotificationListener", "obj= " + objectName);
        }
        Object object2 = this.getMBean(objectName);
        String string = null;
        try {
            string = this.meta.getMBeanClassName(object2);
        }
        catch (IntrospectionException introspectionException) {
            string = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "addNotificationListener");
        if (!(object2 instanceof NotificationBroadcaster)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName.getCanonicalName()), "The MBean " + objectName.getCanonicalName() + " does not implement the NotificationBroadcaster interface");
        }
        NotificationBroadcaster notificationBroadcaster = (NotificationBroadcaster)object2;
        if (notificationListener == null) {
            throw new RuntimeOperationsException(new IllegalArgumentException("Null listener"), "Null listener");
        }
        NotificationListener notificationListener2 = this.getListenerWrapper(notificationListener, objectName, object2, true);
        notificationBroadcaster.addNotificationListener(notificationListener2, notificationFilter, object);
    }

    public void addNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException {
        Object object2 = this.getMBean(objectName2);
        if (!(object2 instanceof NotificationListener)) {
            throw new RuntimeOperationsException(new IllegalArgumentException(objectName2.getCanonicalName()), "The MBean " + objectName2.getCanonicalName() + "does not implement the NotificationListener interface");
        }
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("addNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.server.addNotificationListener(objectName, (NotificationListener)object2, notificationFilter, object);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(objectName, notificationListener, null, null, true);
    }

    public void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        this.removeNotificationListener(objectName, notificationListener, notificationFilter, object, false);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener notificationListener = this.getListener(objectName2);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("removeNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.server.removeNotificationListener(objectName, notificationListener);
    }

    public void removeNotificationListener(ObjectName objectName, ObjectName objectName2, NotificationFilter notificationFilter, Object object) throws InstanceNotFoundException, ListenerNotFoundException {
        NotificationListener notificationListener = this.getListener(objectName2);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("removeNotificationListener", "obj= " + objectName + " listener= " + objectName2);
        }
        this.server.removeNotificationListener(objectName, notificationListener, notificationFilter, object);
    }

    private NotificationListener getListener(ObjectName objectName) throws ListenerNotFoundException {
        Object object;
        try {
            object = this.getMBean(objectName);
        }
        catch (InstanceNotFoundException instanceNotFoundException) {
            throw new ListenerNotFoundException(instanceNotFoundException.getMessage());
        }
        if (!(object instanceof NotificationListener)) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(objectName.getCanonicalName());
            String string = "MBean " + objectName.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationListener == null ? (class$javax$management$NotificationListener = DefaultMBeanServerInterceptor.class$("javax.management.NotificationListener")) : class$javax$management$NotificationListener).getName();
            throw new RuntimeOperationsException(illegalArgumentException, string);
        }
        return (NotificationListener)object;
    }

    private void removeNotificationListener(ObjectName objectName, NotificationListener notificationListener, NotificationFilter notificationFilter, Object object, boolean bl) throws InstanceNotFoundException, ListenerNotFoundException {
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("removeNotificationListener", "obj= " + objectName);
        }
        Object object2 = this.getMBean(objectName);
        String string = null;
        try {
            string = this.meta.getMBeanClassName(object2);
        }
        catch (IntrospectionException introspectionException) {
            string = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "removeNotificationListener");
        NotificationBroadcaster notificationBroadcaster = null;
        NotificationEmitter notificationEmitter = null;
        if (bl) {
            if (!(object2 instanceof NotificationBroadcaster)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(objectName.getCanonicalName());
                String string2 = "MBean " + objectName.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationBroadcaster == null ? (class$javax$management$NotificationBroadcaster = DefaultMBeanServerInterceptor.class$("javax.management.NotificationBroadcaster")) : class$javax$management$NotificationBroadcaster).getName();
                throw new RuntimeOperationsException(illegalArgumentException, string2);
            }
            notificationBroadcaster = (NotificationBroadcaster)object2;
        } else {
            if (!(object2 instanceof NotificationEmitter)) {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException(objectName.getCanonicalName());
                String string3 = "MBean " + objectName.getCanonicalName() + " does not " + "implement " + (class$javax$management$NotificationEmitter == null ? (class$javax$management$NotificationEmitter = DefaultMBeanServerInterceptor.class$("javax.management.NotificationEmitter")) : class$javax$management$NotificationEmitter).getName();
                throw new RuntimeOperationsException(illegalArgumentException, string3);
            }
            notificationEmitter = (NotificationEmitter)object2;
        }
        NotificationListener notificationListener2 = this.getListenerWrapper(notificationListener, objectName, object2, false);
        if (notificationListener2 == null) {
            throw new ListenerNotFoundException("Unknown listener");
        }
        if (bl) {
            notificationBroadcaster.removeNotificationListener(notificationListener2);
        } else {
            notificationEmitter.removeNotificationListener(notificationListener2, notificationFilter, object);
        }
    }

    public MBeanInfo getMBeanInfo(ObjectName objectName) throws InstanceNotFoundException, IntrospectionException, ReflectionException {
        Object object = this.getMBean(objectName);
        MBeanInfo mBeanInfo = this.meta.getMBeanInfo(object);
        if (mBeanInfo == null) {
            throw new JMRuntimeException("MBean " + objectName + "has no MBeanInfo");
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(mBeanInfo.getClassName(), null, objectName, "getMBeanInfo");
        return mBeanInfo;
    }

    public boolean isInstanceOf(ObjectName objectName, String string) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        String string2 = null;
        try {
            string2 = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            string2 = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string2 = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string2, null, objectName, "isInstanceOf");
        try {
            return this.meta.isInstanceOf(object, string);
        }
        catch (ReflectionException reflectionException) {
            DefaultMBeanServerInterceptor.debugX("isInstanceOf", reflectionException);
            return false;
        }
    }

    public ClassLoader getClassLoaderFor(ObjectName objectName) throws InstanceNotFoundException {
        Object object = this.getMBean(objectName);
        String string = null;
        try {
            string = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            string = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "getClassLoaderFor");
        return object.getClass().getClassLoader();
    }

    public ClassLoader getClassLoader(ObjectName objectName) throws InstanceNotFoundException {
        if (objectName == null) {
            DefaultMBeanServerInterceptor.checkMBeanPermission(null, null, null, "getClassLoader");
            return this.server.getClass().getClassLoader();
        }
        Object object = this.getMBean(objectName);
        String string = null;
        try {
            string = this.meta.getMBeanClassName(object);
        }
        catch (IntrospectionException introspectionException) {
            string = null;
        }
        catch (NotCompliantMBeanException notCompliantMBeanException) {
            string = null;
        }
        DefaultMBeanServerInterceptor.checkMBeanPermission(string, null, objectName, "getClassLoader");
        if (!(object instanceof ClassLoader)) {
            throw new InstanceNotFoundException(objectName.toString() + " is not a classloader");
        }
        return (ClassLoader)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internal_addObject(Object object, ObjectName objectName) throws InstanceAlreadyExistsException {
        DefaultMBeanServerInterceptor defaultMBeanServerInterceptor = this;
        synchronized (defaultMBeanServerInterceptor) {
            try {
                this.repository.addMBean(object, objectName);
            }
            catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {
                if (object instanceof MBeanRegistration) {
                    this.meta.postRegisterInvoker(object, false);
                }
                throw instanceAlreadyExistsException;
            }
        }
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("addObject", "Send create notification of object " + objectName.getCanonicalName());
        }
        this.sendNotification("JMX.mbean.registered", objectName);
    }

    private void sendNotification(String string, ObjectName objectName) {
        MBeanServerNotification mBeanServerNotification = new MBeanServerNotification(string, (Object)_MBSDelegateObjectName, 0L, objectName);
        if (DefaultMBeanServerInterceptor.isTraceOn()) {
            DefaultMBeanServerInterceptor.trace("sendNotification", string + " " + objectName);
        }
        this.delegate.sendNotification(mBeanServerNotification);
    }

    private void initialize(String string, MBeanServer mBeanServer, MBeanServerDelegate mBeanServerDelegate, MBeanInstantiator mBeanInstantiator, MetaData metaData, Repository repository) {
        if (!this.domain.equals(this.repository.getDefaultDomain())) {
            throw new IllegalArgumentException("Domain Name Mismatch");
        }
        try {
            this.queryByRepo = this.repository.isFiltering();
        }
        catch (SecurityException securityException) {
            throw securityException;
        }
        catch (Exception exception) {
            this.queryByRepo = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set filterListOfObjects(Set set, QueryExp queryExp) {
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        if (queryExp == null) {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                NamedObject namedObject;
                block12: {
                    namedObject = (NamedObject)iterator.next();
                    Object object = namedObject.getObject();
                    string = null;
                    try {
                        string = this.meta.getMBeanClassName(object);
                    }
                    catch (JMException jMException) {
                        if (!DefaultMBeanServerInterceptor.isDebugOn()) break block12;
                        DefaultMBeanServerInterceptor.debug("filterListOfObjects", "Can't obtain class name for " + namedObject.getName() + ": " + jMException);
                    }
                }
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        } else {
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                String string;
                NamedObject namedObject;
                block14: {
                    Object var11_18;
                    namedObject = (NamedObject)iterator.next();
                    Object object = namedObject.getObject();
                    boolean bl = false;
                    MBeanServer mBeanServer = QueryEval.getMBeanServer();
                    queryExp.setMBeanServer(this.server);
                    try {
                        try {
                            bl = queryExp.apply(namedObject.getName());
                        }
                        catch (Exception exception) {
                            bl = false;
                            var11_18 = null;
                            queryExp.setMBeanServer(mBeanServer);
                        }
                        var11_18 = null;
                        queryExp.setMBeanServer(mBeanServer);
                    }
                    catch (Throwable throwable) {
                        var11_18 = null;
                        queryExp.setMBeanServer(mBeanServer);
                        throw throwable;
                    }
                    if (!bl) continue;
                    string = null;
                    try {
                        string = this.meta.getMBeanClassName(object);
                    }
                    catch (JMException jMException) {
                        if (!DefaultMBeanServerInterceptor.isDebugOn()) break block14;
                        DefaultMBeanServerInterceptor.debug("filterListOfObjects", "Can't obtain class name for " + namedObject.getName() + ": " + jMException);
                    }
                }
                hashSet.add(new ObjectInstance(namedObject.getName(), string));
            }
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set filterListOfObjectInstances(Set set, QueryExp queryExp) {
        if (queryExp == null) {
            return set;
        }
        HashSet<ObjectInstance> hashSet = new HashSet<ObjectInstance>();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Object var10_9;
            ObjectInstance objectInstance = (ObjectInstance)iterator.next();
            boolean bl = false;
            MBeanServer mBeanServer = QueryEval.getMBeanServer();
            queryExp.setMBeanServer(this.server);
            try {
                try {
                    bl = queryExp.apply(objectInstance.getObjectName());
                }
                catch (Exception exception) {
                    bl = false;
                    var10_9 = null;
                    queryExp.setMBeanServer(mBeanServer);
                }
                var10_9 = null;
                queryExp.setMBeanServer(mBeanServer);
            }
            catch (Throwable throwable) {
                var10_9 = null;
                queryExp.setMBeanServer(mBeanServer);
                throw throwable;
            }
            if (!bl) continue;
            hashSet.add(objectInstance);
        }
        return hashSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NotificationListener getListenerWrapper(NotificationListener notificationListener, ObjectName objectName, Object object, boolean bl) {
        ListenerWrapper listenerWrapper = new ListenerWrapper(notificationListener, objectName, object);
        WeakHashMap weakHashMap = this.listenerWrappers;
        synchronized (weakHashMap) {
            NotificationListener notificationListener2;
            block6: {
                block5: {
                    WeakReference weakReference = (WeakReference)this.listenerWrappers.get(listenerWrapper);
                    if (weakReference == null || (notificationListener2 = (NotificationListener)weakReference.get()) == null) break block5;
                    NotificationListener notificationListener3 = notificationListener2;
                    return notificationListener3;
                }
                if (!bl) break block6;
                this.listenerWrappers.put(listenerWrapper, new WeakReference<ListenerWrapper>(listenerWrapper));
                notificationListener2 = listenerWrapper;
                return notificationListener2;
            }
            notificationListener2 = null;
            return notificationListener2;
        }
    }

    private static void checkMBeanPermission(String string, String string2, ObjectName objectName, String string3) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanPermission mBeanPermission = new MBeanPermission(string, string2, objectName, string3);
            securityManager.checkPermission(mBeanPermission);
        }
    }

    private static void checkMBeanTrustPermission(final Class clazz) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            MBeanTrustPermission mBeanTrustPermission = new MBeanTrustPermission("register");
            ProtectionDomain protectionDomain = (ProtectionDomain)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return clazz.getProtectionDomain();
                }
            });
            if (!protectionDomain.implies(mBeanTrustPermission)) {
                throw new SecurityException("access denied (" + mBeanTrustPermission.getClass().getName() + " " + mBeanTrustPermission.getName() + ")");
            }
        }
    }

    private static boolean isTraceOn() {
        return Trace.isSelected(1, 1);
    }

    private static void trace(String string, String string2, String string3) {
        Trace.send(1, 1, string, string2, string3);
    }

    private static void trace(String string, String string2) {
        DefaultMBeanServerInterceptor.trace(dbgTag, string, string2);
    }

    private static boolean isDebugOn() {
        return Trace.isSelected(2, 1);
    }

    private static void debug(String string, String string2, String string3) {
        Trace.send(2, 1, string, string2, string3);
    }

    private static void debug(String string, String string2) {
        DefaultMBeanServerInterceptor.debug(dbgTag, string, string2);
    }

    private static void debugX(String string, Throwable throwable) {
        if (DefaultMBeanServerInterceptor.isDebugOn()) {
            StringWriter stringWriter = new StringWriter();
            throwable.printStackTrace(new PrintWriter(stringWriter));
            String string2 = stringWriter.toString();
            DefaultMBeanServerInterceptor.debug(dbgTag, string, "Exception caught in " + string + "(): " + throwable);
            DefaultMBeanServerInterceptor.debug(dbgTag, string, string2);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            _MBSDelegateObjectName = new ObjectName("JMImplementation:type=MBeanServerDelegate");
        }
        catch (MalformedObjectNameException malformedObjectNameException) {
            throw new UnsupportedOperationException(malformedObjectNameException.getMessage());
        }
    }

    private static class ListenerWrapper
    implements NotificationListener {
        private NotificationListener listener;
        private ObjectName name;
        private Object mbean;

        ListenerWrapper(NotificationListener notificationListener, ObjectName objectName, Object object) {
            this.listener = notificationListener;
            this.name = objectName;
            this.mbean = object;
        }

        public void handleNotification(Notification notification, Object object) {
            if (notification != null && notification.getSource() == this.mbean) {
                notification.setSource(this.name);
            }
            this.listener.handleNotification(notification, object);
        }

        public boolean equals(Object object) {
            if (!(object instanceof ListenerWrapper)) {
                return false;
            }
            ListenerWrapper listenerWrapper = (ListenerWrapper)object;
            return listenerWrapper.listener == this.listener && listenerWrapper.mbean == this.mbean && listenerWrapper.name.equals(this.name);
        }

        public int hashCode() {
            return System.identityHashCode(this.listener) ^ System.identityHashCode(this.mbean);
        }
    }
}

